/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.TwitchEmotesApi;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import chatty.util.api.Emoticons;
import java.awt.event.ActionEvent;

public class EmoteContextMenu
extends ContextMenu {
    private static final Object unique = new Object();
    private static Emoticons emoteManager;
    private final ContextMenuListener listener;
    private final CachedImage<Emoticon> emoteImage;

    public EmoteContextMenu(CachedImage<Emoticon> emoteImage, ContextMenuListener listener) {
        Emoticon emote = emoteImage.getObject();
        this.listener = listener;
        this.emoteImage = emoteImage;
        if (emote.subType == Emoticon.SubType.CHEER) {
            this.addItem("cheer", "Cheering Emote");
        } else {
            this.addItem("code", StringUtil.shortenTo(emote.code, 40, 28));
            if (emote.type == Emoticon.Type.EMOJI && emote.stringId != null) {
                if (emote.stringIdAlias != null) {
                    this.addItem("codeEmoji", emote.stringId + " (" + emote.stringIdAlias + ")");
                } else {
                    this.addItem("codeEmoji", emote.stringId);
                }
            }
        }
        String imageMenu = emoteImage.getSizeString();
        this.addItem("emoteImage", "Source", imageMenu);
        this.addItem("emoteImageLoaded", "Loaded from", imageMenu);
        this.setSubMenuIcon(imageMenu, ContextMenuHelper.ICON_IMAGE);
        switch (emote.type) {
            case TWITCH: 
            case FFZ: 
            case BTTV: 
            case SEVENTV: {
                this.addItem("emoteId", "ID: " + StringUtil.shortenTo(emote.stringId, 14), ContextMenuHelper.ICON_WEB);
            }
        }
        if (emote.type != Emoticon.Type.TWITCH) {
            this.addSeparator();
            switch (emote.type) {
                case FFZ: {
                    this.addItem("ffzlink", "FrankerFaceZ Emote", ContextMenuHelper.ICON_WEB);
                    break;
                }
                case BTTV: {
                    this.addItem("bttvlink", "BetterTTV Emote", ContextMenuHelper.ICON_WEB);
                    break;
                }
                case SEVENTV: {
                    this.addItem("seventvlink", "7TV Emote", ContextMenuHelper.ICON_WEB);
                    break;
                }
                case CUSTOM: {
                    this.addItem("", "Custom Emote");
                    break;
                }
                case CUSTOM2: {
                    this.addItem("", "Local Emote");
                    break;
                }
                case EMOJI: {
                    this.addItem("", "Emoji");
                }
            }
            if (emote.creator != null) {
                this.addItem("emoteCreator", Language.getString("emoteCm.emoteBy", emote.creator));
            }
            if (emote.subType == Emoticon.SubType.EVENT) {
                for (String info : emote.getInfos()) {
                    this.addItem("", "Featured " + info);
                }
            } else {
                for (String info : emote.getInfos()) {
                    this.addItem("", info);
                }
            }
            this.addStreamSubmenu(emote);
        }
        if (!emote.hasGlobalEmoteset()) {
            this.addSeparator();
            this.addItem("", TwitchEmotesApi.getEmoteType(emote));
        }
        this.addSeparator();
        this.addItem("emoteDetails", Language.getString("emoteCm.showDetails"));
        this.addSeparator();
        if (!emoteManager.isEmoteIgnored(emote, 0)) {
            this.addItem("ignoreEmote", Language.getString("emoteCm.ignore"));
        } else {
            this.addItem("ignoreEmote", Language.getString("emoteCm.changeIgnore"));
        }
        if (emote.subType != Emoticon.SubType.CHEER && (emote.emoteset != null && !emote.emoteset.isEmpty() || emote.type != Emoticon.Type.TWITCH)) {
            if (emoteManager.isFavorite(emote)) {
                this.addItem("unfavoriteEmote", Language.getString("emoteCm.unfavorite"));
            } else {
                this.addItem("favoriteEmote", Language.getString("emoteCm.favorite"));
            }
        }
        if (emoteManager.canAddCustomLocal(emote)) {
            if (!emoteManager.isCustomLocal(emote)) {
                this.addItem("addCustomLocalEmote", "Add local emote");
            } else {
                this.addItem("removeCustomLocalEmote", "Remove local emote");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.emoteMenuItemClicked(e, this.emoteImage);
        }
    }

    public static void setEmoteManager(Emoticons emotes) {
        emoteManager = emotes;
    }

    private void addStreamSubmenu(Emoticon emote) {
        if (emote.hasStreamSet() && Helper.isValidStream(emote.getStream())) {
            String subMenu = emote.getStream();
            this.addItem("stream", "Twitch Stream", subMenu);
            this.addItem("join", Language.getString("userCm.join", emote.getStream()), subMenu);
            this.addSeparator(subMenu);
            this.addItem("showChannelEmotes", Language.getString("emoteCm.showEmotes"), subMenu);
        }
    }
}

