/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.RoutingTargetContextMenu;
import chatty.lang.Language;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class HighlightsContextMenu
extends ContextMenu {
    public HighlightsContextMenu(boolean isDocked, boolean autoOpen, long showLegacyValue, long channelLogoValue, long showChannelNameValue) {
        this.addItem("clearHighlights", Language.getString("highlightedDialog.cm.clear"));
        this.addSeparator();
        this.addCheckboxItem("dockToggleDocked", "Dock as tab", isDocked);
        this.addCheckboxItem("dockToggleAutoOpenActivity", "Open on message", autoOpen);
        this.addSeparator();
        RoutingTargetContextMenu.addChannelLogoOptions(this, channelLogoValue);
        RoutingTargetContextMenu.addShowChannelNameOptions(this, showChannelNameValue);
        this.addLegacyChannelNameOptions(showLegacyValue);
    }

    private void addLegacyChannelNameOptions(long showLegacyValue) {
        HashMap<Long, String> showLegacyOptions = new HashMap<Long, String>();
        showLegacyOptions.put(0L, "Off");
        showLegacyOptions.put(1L, "Show channel name on own line");
        ContextMenuHelper.addNumericOptions(this, "Legacy Channel Name", "legacyChannelName", showLegacyValue, showLegacyOptions);
        this.getItem("legacyChannelName1").setToolTipText("Show channel name as a separate line before messages every few messages");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ContextMenuListener l : this.getContextMenuListeners()) {
            l.menuItemClicked(e);
        }
    }
}

