/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class HistoryContextMenu
extends ContextMenu {
    private static final String RANGE_MENU = Language.getString("channelInfo.viewers.cm.timeRange");

    public HistoryContextMenu() {
        this.addRadioItem("historyRange60", this.format(1), RANGE_MENU, RANGE_MENU);
        this.addRadioItem("historyRange120", this.format(2), RANGE_MENU, RANGE_MENU);
        this.addRadioItem("historyRange240", this.format(4), RANGE_MENU, RANGE_MENU);
        this.addRadioItem("historyRange480", this.format(8), RANGE_MENU, RANGE_MENU);
        this.addRadioItem("historyRange720", this.format(12), RANGE_MENU, RANGE_MENU);
        this.addSeparator(RANGE_MENU);
        this.addRadioItem("historyRange-1", Language.getString("channelInfo.viewers.cm.timeRange.all"), RANGE_MENU, RANGE_MENU);
        this.addCheckboxItem("toggleVerticalZoom", Language.getString("channelInfo.viewers.cm.verticalZoom"), false);
        this.addSeparator();
        this.addCheckboxItem("dockToggleDocked", "Dock as tab", false);
    }

    private String format(int hours) {
        return Language.getString("channelInfo.viewers.cm.timeRange.option", hours);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ContextMenuListener l : this.getContextMenuListeners()) {
            l.menuItemClicked(e);
        }
    }

    public void setRange(int range) {
        String key = "historyRange" + range;
        JMenuItem item = this.getItem(key);
        if (item != null) {
            item.setSelected(true);
        }
    }

    public void setZoom(boolean zoom) {
        this.getItem("toggleVerticalZoom").setSelected(zoom);
    }

    public void setDocked(boolean docked) {
        this.getItem("dockToggleDocked").setSelected(docked);
    }
}

