/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.util.srl.Race;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RaceEntrantContextMenu
extends ContextMenu {
    private final Collection<String> streams;
    private final ContextMenuListener listener;

    public RaceEntrantContextMenu(List<Race.Entrant> entrants, ContextMenuListener listener) {
        this.listener = listener;
        this.streams = new ArrayList<String>();
        for (Race.Entrant entrant : entrants) {
            if (entrant.twitch.isEmpty()) continue;
            this.streams.add(entrant.twitch);
        }
        if (this.streams.isEmpty()) {
            this.addItem("", "No stream set");
        } else {
            ContextMenuHelper.addStreamsOptions(this, this.streams.size(), null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.listener.streamsMenuItemClicked(e, this.streams);
    }
}

