/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.DockedDialogHelper;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.settings.RoutingSettingsTable;
import chatty.lang.Language;
import java.awt.event.ActionEvent;
import java.util.List;

public class RoutingTargetContextMenu
extends ContextMenu {
    public RoutingTargetContextMenu(List<Channel> openChannels, boolean fixedChannelEnabled, boolean addAllEntry, boolean showAll, String currentChannel, int channelLogoValue, int showChannelName) {
        if (openChannels != null) {
            this.addItem("clearAll", "Clear all");
            this.addItem("clearCurrent", "Clear current");
            this.addSeparator();
            DockedDialogHelper.addChannelSelectionToContextMenu(this, openChannels, fixedChannelEnabled, addAllEntry, showAll, currentChannel);
        } else {
            this.addItem("clearAll", "Clear");
        }
        this.addSeparator();
        RoutingTargetContextMenu.addChannelLogoOptions(this, channelLogoValue);
        RoutingTargetContextMenu.addShowChannelNameOptions(this, showChannelName);
    }

    public static void addChannelLogoOptions(ContextMenu menu, long channelLogoValue) {
        ContextMenuHelper.addNumericOptions(menu, Language.getString("settings.label.routingTargets.channelLogo").replace(":", ""), "logoSize", channelLogoValue, RoutingSettingsTable.makeChannelLogoValues());
    }

    public static void addShowChannelNameOptions(ContextMenu menu, long showChannelName) {
        ContextMenuHelper.addNumericOptions(menu, Language.getString("settings.label.routingTargets.showChannelName").replace(":", ""), "showChannelName", showChannelName, RoutingSettingsTable.makeChannelNameValues());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ContextMenuListener l : this.getContextMenuListeners()) {
            l.menuItemClicked(e);
        }
    }
}

