/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.TwitchClient;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StreamChatContextMenu
extends ContextMenu {
    public static TwitchClient client;
    private static final String CHANNEL_SETTING = "streamChatChannels";
    private static final String LOGO_SETTING = "streamChatLogos";

    public StreamChatContextMenu(boolean isDocked) {
        this.addItem("clearHighlights", Language.getString("highlightedDialog.cm.clear"));
        this.addSeparator();
        ArrayList<String> channels = new ArrayList<String>();
        List enabledChannels = StreamChatContextMenu.client.settings.getList(CHANNEL_SETTING);
        channels.addAll(enabledChannels);
        StreamChatContextMenu.addChans(channels, client.getOpenChannels());
        Collections.sort(channels);
        for (String chan : channels) {
            this.addCheckboxItem("toggleChannel." + chan, chan, "Enabled Channels", enabledChannels.contains(chan));
        }
        String logoSubmenu = "Channel Logos";
        int defaultSize = Integer.parseInt(StreamChatContextMenu.client.settings.getStringDefault(LOGO_SETTING));
        int currentSize = Integer.parseInt(StreamChatContextMenu.client.settings.getString(LOGO_SETTING));
        for (int i = 30; i > 10; i -= 2) {
            String action = "logoSize" + i;
            if (i == defaultSize) {
                this.addRadioItem(action, i + "px (default)", "Channel Logos", "Channel Logos");
            } else {
                this.addRadioItem(action, i + "px", "Channel Logos", "Channel Logos");
            }
            if (i != currentSize) continue;
            this.getItem(action).setSelected(true);
        }
        this.addSeparator("Channel Logos");
        this.addRadioItem("logoOff", "Off", "Channel Logos", "Channel Logos");
        if (currentSize == 0) {
            this.getItem("logoOff").setSelected(true);
        }
        this.addSeparator();
        this.addCheckboxItem("dockToggleDocked", "Dock as tab", isDocked);
    }

    private static void addChans(List<String> chans, Collection<String> add) {
        for (String chan : add) {
            if (chans.contains(chan = StringUtil.toLowerCase(chan))) continue;
            chans.add(chan);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("toggleChannel.")) {
            String channel = e.getActionCommand().substring("toggleChannel.".length());
            if (!StreamChatContextMenu.client.settings.listContains(CHANNEL_SETTING, channel)) {
                StreamChatContextMenu.client.settings.listAdd(CHANNEL_SETTING, channel);
            } else {
                StreamChatContextMenu.client.settings.listRemove(CHANNEL_SETTING, channel);
            }
            StreamChatContextMenu.client.settings.setSettingChanged(CHANNEL_SETTING);
        } else if (e.getActionCommand().startsWith("logoSize")) {
            StreamChatContextMenu.client.settings.setString(LOGO_SETTING, e.getActionCommand().substring("logoSize".length()));
        } else if (e.getActionCommand().equals("logoOff")) {
            StreamChatContextMenu.client.settings.setString(LOGO_SETTING, "0");
        }
        for (ContextMenuListener l : this.getContextMenuListeners()) {
            l.menuItemClicked(e);
        }
    }
}

