/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.LiveStreamsDialog;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.api.StreamInfo;
import chatty.util.commands.Parameters;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class StreamInfosContextMenu
extends ContextMenu {
    private final List<StreamInfo> streamInfos;
    private static final String SORT_SUBMENU = Language.getString("streams.cm.menu.sortBy");
    private static final String SORT_GROUP = "sort";
    private static final String FILTER_SUBMENU = Language.getString("streams.cm.menu.filter");
    private static final ImageIcon FAV_ICON = new ImageIcon(ContextMenu.class.getResource("/chatty/gui/star.png"));
    private static final ImageIcon GAME_FAV_ICON = new ImageIcon(ContextMenu.class.getResource("/chatty/gui/game.png"));

    public StreamInfosContextMenu(List<StreamInfo> selected, boolean liveStreams, boolean favFirst, boolean favsOnly, boolean docked) {
        this.streamInfos = selected;
        ArrayList<String> streams = new ArrayList<String>();
        for (StreamInfo info : selected) {
            streams.add(info.getStream());
        }
        if (!selected.isEmpty()) {
            this.addItem("openChannelInfo", "Info: " + selected.get(0).getStream());
            this.addSeparator();
            ContextMenuHelper.addStreamsOptions(this, streams.size(), Parameters.create(StringUtil.join(streams, " ")));
            if (liveStreams) {
                this.addSeparator();
            }
        }
        if (liveStreams) {
            for (LiveStreamsDialog.Sorting s : LiveStreamsDialog.Sorting.values()) {
                this.addRadioItem("sort_" + s.key, s.getLabel(), SORT_GROUP, SORT_SUBMENU);
                this.getItem("sort_" + s.key).setToolTipText(s.getToolTipText());
            }
            this.addSeparator(SORT_SUBMENU);
            this.addCheckboxItem("sortOption_favFirst", Language.getString("streams.sortingOption.fav"), SORT_SUBMENU, favFirst);
            this.getItem("sortOption_favFirst").setToolTipText(SettingsUtil.addTooltipLinebreaks(Language.getString("streams.sortingOption.fav.tip")));
            this.addSeparator(SORT_SUBMENU);
            this.addItem("favoriteChannel", Language.getString("channelCm.favorite"), SORT_SUBMENU, FAV_ICON);
            this.addItem("unfavoriteChannel", Language.getString("channelCm.unfavorite"), SORT_SUBMENU);
            this.addItem("favoriteGame", Language.getString("channelCm.favoriteGame"), SORT_SUBMENU, GAME_FAV_ICON);
            this.addItem("unfavoriteGame", Language.getString("channelCm.unfavoriteGame"), SORT_SUBMENU);
            this.addCheckboxItem("filterOption_favsOnly", Language.getString("streams.filterOption.favsOnly"), FILTER_SUBMENU, favsOnly);
            this.addSeparator(FILTER_SUBMENU);
            this.addItem("favoriteChannel", Language.getString("channelCm.favorite"), FILTER_SUBMENU, FAV_ICON);
            this.addItem("unfavoriteChannel", Language.getString("channelCm.unfavorite"), FILTER_SUBMENU);
            this.addItem("favoriteGame", Language.getString("channelCm.favoriteGame"), FILTER_SUBMENU, GAME_FAV_ICON);
            this.addItem("unfavoriteGame", Language.getString("channelCm.unfavoriteGame"), FILTER_SUBMENU);
            this.addItem("liveStreamsSettings", Language.getString("streams.cm.moreSettings"));
            this.addItem("showRemovedList", Language.getString("streams.cm.removedStreams"));
            this.addSeparator();
            this.addItem("manualRefreshStreams", Language.getString("streams.cm.refresh"));
            this.addSeparator();
            this.addCheckboxItem("dockToggleDocked", "Dock as tab", docked);
        }
    }

    public void setSorting(String key) {
        JMenuItem item = this.getItem("sort_" + key);
        if (item != null) {
            item.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ContextMenuListener l : this.getContextMenuListeners()) {
            l.streamInfosMenuItemClicked(e, this.streamInfos);
        }
    }
}

