/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.gui.Channels;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.settings.TabSettings;
import chatty.util.StringUtil;
import chatty.util.dnd.DockContent;
import chatty.util.settings.Settings;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class TabContextMenu
extends ContextMenu {
    private final ContextMenuListener listener;
    private final DockContent content;

    public TabContextMenu(ContextMenuListener listener, DockContent content, Map<String, Collection<DockContent>> closeInfo, Settings settings) {
        this.listener = listener;
        this.content = content;
        String typeLabel = TabSettings.tabPosLabel(content.getId().substring(0, 1));
        this.addItem("popoutChannel", "Popout " + content.getTitle());
        this.addItem("popoutChannelWindow", "Popout as Window");
        this.addSeparator();
        this.addItem("closeChannel", "Close");
        String closeTabsMenu = "This tab pane";
        String closeAllMenu = "All tabs";
        JMenu closeMenu = new JMenu("Close Tabs");
        JMenu closeMenuThis = new JMenu(closeTabsMenu);
        JMenu closeMenuAll = new JMenu(closeAllMenu);
        this.registerSubmenu(closeMenu);
        this.registerSubmenu(closeMenuThis);
        this.registerSubmenu(closeMenuAll);
        this.addNumItem("closeAllTabsButCurrent", "Except current", closeTabsMenu, closeInfo);
        this.addNumItem("closeAllTabsToLeft", "To left of current", closeTabsMenu, closeInfo);
        this.addNumItem("closeAllTabsToRight", "To right of current", closeTabsMenu, closeInfo);
        this.addSeparator(closeTabsMenu);
        this.addNumItem("closeAllTabsOffline", "Offline channels", closeTabsMenu, closeInfo);
        this.addSeparator(closeTabsMenu);
        this.addNumItem("closeAllTabs", "All", closeTabsMenu, closeInfo);
        this.addNumItem("closeAllTabs2ButCurrent", "Except current", closeAllMenu, closeInfo);
        this.addSeparator(closeAllMenu);
        this.addNumItem("closeAllTabs2Offline", "Offline channels", closeAllMenu, closeInfo);
        this.addSeparator(closeAllMenu);
        this.addNumItem("closeAllTabs2", "All", closeAllMenu, closeInfo);
        closeMenu.add(closeMenuThis);
        closeMenu.add(closeMenuAll);
        this.addCheckboxItem("tabsCloseSameType", "Same tab type only", "Close Tabs", settings.getBoolean("closeTabsSameType"));
        this.getItem("tabsCloseSameType").setToolTipText("Only close tabs of the same type you opened this menu for (currently " + typeLabel + ")");
        this.add(closeMenu);
        String customOrderMenuName = "This tab";
        String customOrderMenuName2 = typeLabel;
        JMenu orderMenu = new JMenu("Order");
        JMenu customOrderMenu = new JMenu(customOrderMenuName);
        JMenu customOrderMenu2 = new JMenu(customOrderMenuName2);
        this.registerSubmenu(orderMenu);
        this.registerSubmenu(customOrderMenu);
        this.registerSubmenu(customOrderMenu2);
        orderMenu.add(customOrderMenu);
        orderMenu.add(customOrderMenu2);
        this.addCheckboxItem("tabsAutoSort", "Resort on changes", "Order", settings.getBoolean("tabsAutoSort"));
        this.getItem("tabsAutoSort").setToolTipText("Automatically resort tabs when changing tab order settings");
        orderMenu.addSeparator();
        this.addItem("tabsSort", "Resort all tabs", "Order");
        Map<Long, List<String>> posIds = Channels.getTabPosIds(settings);
        this.addPosItems(posIds, Channels.getTabPos(settings, content.getId()), customOrderMenuName, "tabsPosTab");
        this.addPosItems(posIds, Channels.getTabPos(settings, content.getId().substring(0, 1)), customOrderMenuName2, "tabsPosType");
        this.addSeparator();
        this.add(orderMenu);
        if (content instanceof Channels.DockChannelContainer && ((Channel)((Channels.DockChannelContainer)content).getContent()).getType() == Channel.Type.CHANNEL) {
            Channel chan = (Channel)content.getComponent();
            CommandMenuItems.addCommands(CommandMenuItems.MenuType.CHANNEL, this, Helper.createRoomParameters(chan.getRoom()));
        }
    }

    private void addPosItems(Map<Long, List<String>> posIds, long pos, String menuName, String actionName) {
        for (long i = -10L; i <= 10L; ++i) {
            String title = String.valueOf(i);
            switch ((int)i) {
                case -10: {
                    title = title + " (further in front)";
                    break;
                }
                case 0: {
                    title = title + " (Default)";
                    break;
                }
                case 10: {
                    title = title + " (further in back)";
                }
            }
            if (i != 0L && posIds.containsKey(i)) {
                List<String> ids = posIds.get(i);
                title = title + " / " + StringUtil.shortenTo(StringUtil.join(ids, ", "), 30);
            }
            this.addRadioItem(actionName + i, title, actionName, menuName);
        }
        JMenuItem tabsPosItem = this.getItem(actionName + pos);
        if (tabsPosItem != null) {
            tabsPosItem.setSelected(true);
        }
    }

    private void addNumItem(String cmd, String label, String submenu, Map<String, Collection<DockContent>> info) {
        if (info.containsKey(cmd)) {
            int size = info.get(cmd).size();
            JMenuItem item = this.addItem(cmd, String.format("%s (%d)", label, size), submenu);
            if (size == 0) {
                item.setEnabled(false);
            }
        } else {
            this.addItem(cmd, label, submenu);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.tabMenuItemClicked(e, this.content);
        }
    }
}

