/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.menus.CommandActionEvent;
import chatty.gui.components.menus.CommandMenuItem;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.settings.CommandSettings;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class TestContextMenu
extends ContextMenu {
    private String errorsInfo = "";

    public TestContextMenu(String value) {
        Object errorDescription;
        String readme = "Readme";
        this.addItem("", "Test Context Menu", "Readme");
        this.addItem("", "a) Only shows custom menu items (not the pre-defined ones)", "Readme");
        this.addItem("", "b) Clicking on an item shows info about the associated command", "Readme");
        this.addItem("", "c) The associated command doesn't get executed", "Readme");
        this.addItem("", "d) Restrictions/dynamic labels won't work properly in this context", "Readme");
        int errorCount = 0;
        HashMap<CustomCommand, Integer> restrictions = new HashMap<CustomCommand, Integer>();
        List<CommandMenuItem> items = CommandMenuItems.parse(value);
        for (CommandMenuItem commandMenuItem : items) {
            if (commandMenuItem.getCommand() != null && commandMenuItem.getCommand().getError() != null) {
                errorDescription = String.format("<p style='font-family:monospaced;'>%s=Error%s: %s</p>", commandMenuItem.getLabel(), TestContextMenu.makeLineNumber(commandMenuItem.getLineNumber()), CommandSettings.formatCommandInfo(commandMenuItem.getCommand().getError(), true));
                this.errorsInfo = StringUtil.append(this.errorsInfo, "<br />", (String)errorDescription);
                ++errorCount;
            }
            if (commandMenuItem.getLabelCommand() != null && commandMenuItem.getLabelCommand().getError() != null) {
                errorDescription = String.format("<p style='font-family:monospaced;'>Error in label%s: %s</p>", TestContextMenu.makeLineNumber(commandMenuItem.getLineNumber()), CommandSettings.formatCommandInfo(commandMenuItem.getLabelCommand().getError(), true));
                this.errorsInfo = StringUtil.append(this.errorsInfo, "<br />", (String)errorDescription);
                ++errorCount;
            }
            if (!commandMenuItem.hasRestrictionCommands()) continue;
            for (CustomCommand r : commandMenuItem.getRestrictionCommands()) {
                if (restrictions.containsKey(r)) continue;
                restrictions.put(r, commandMenuItem.getLineNumber() - 1);
            }
        }
        for (Map.Entry entry : restrictions.entrySet()) {
            if (((CustomCommand)entry.getKey()).getError() == null) continue;
            errorDescription = String.format("<p style='font-family:monospaced;'>Error in restriction%s: %s</p>", TestContextMenu.makeLineNumber((Integer)entry.getValue()), CommandSettings.formatCommandInfo(((CustomCommand)entry.getKey()).getError(), true));
            this.errorsInfo = StringUtil.append(this.errorsInfo, "<br />", (String)errorDescription);
            ++errorCount;
        }
        if (errorCount > 0) {
            int size = this.getFontMetrics(this.getFont()).getHeight();
            Icon icon = GuiUtil.getFallbackIcon(UIManager.getIcon("OptionPane.warningIcon"), MainGui.class, "warning.png");
            this.addItem("errors", errorCount + " Errors", -1, null, GuiUtil.getScaledIcon(icon, size, size));
        }
        this.addSeparator();
        for (CommandMenuItem commandMenuItem : items) {
            Parameters parameters = Parameters.create("");
            parameters.put("menu-test", "true");
            JMenuItem mItem = this.addCommandItem(commandMenuItem, CommandMenuItems.getMenuParameters(commandMenuItem, parameters));
            if (mItem == null || !mItem.getText().isEmpty()) continue;
            mItem.setToolTipText(StringUtil.append(mItem.getToolTipText(), " ", String.format("[Original label: %s]", commandMenuItem.getLabel())));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("errors")) {
            GuiUtil.showNonModalMessage(this.getInvoker(), "Errors", this.errorsInfo, 2, true);
        }
        if (e instanceof CommandActionEvent) {
            CustomCommand command = ((CommandActionEvent)e).getCommand();
            CommandSettings.showCommandInfoPopup(this.getInvoker(), command);
        }
    }

    private static String makeLineNumber(int lineNumber) {
        return lineNumber > 0 ? " (on line " + lineNumber + ")" : "";
    }
}

