/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class TextSelectionMenu
extends ContextMenu {
    public static ContextMenuListener listener;
    private final JTextComponent component;
    private static final List<WeakReference<JTextComponent>> components;

    public TextSelectionMenu(JTextComponent component, boolean editingEnabled) {
        this.component = component;
        this.add(new DefaultEditorKit.CopyAction(), Language.getString("textCm.copy"), 67);
        if (editingEnabled) {
            this.add(new DefaultEditorKit.CutAction(), Language.getString("textCm.cut"), 88);
            this.add(new DefaultEditorKit.PasteAction(), Language.getString("textCm.paste"), 80);
        }
        CommandMenuItems.addCommands(CommandMenuItems.MenuType.TEXT, this, null);
    }

    private void add(Action action, String name, int key) {
        action.putValue("Name", name);
        action.putValue("MnemonicKey", key);
        this.add(action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (listener != null) {
            listener.textMenuItemClick(e, this.component.getSelectedText());
        }
    }

    public static void install(JTextComponent c) {
        c.setComponentPopupMenu(new TextSelectionMenu(c, true));
        components.add(new WeakReference<JTextComponent>(c));
    }

    public static void update() {
        Iterator<WeakReference<JTextComponent>> it = components.iterator();
        while (it.hasNext()) {
            JTextComponent c = (JTextComponent)it.next().get();
            if (c == null || !(c.getComponentPopupMenu() instanceof TextSelectionMenu)) {
                it.remove();
                continue;
            }
            c.setComponentPopupMenu(new TextSelectionMenu(c, true));
        }
    }

    static {
        components = new ArrayList<WeakReference<JTextComponent>>();
    }
}

