/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import java.awt.event.ActionEvent;

public class UrlContextMenu
extends ContextMenu {
    private final ContextMenuListener listener;
    private final String url;
    private String channel;
    private User dummyUser;

    public UrlContextMenu(String url, boolean deleted, ContextMenuListener listener) {
        this.url = url;
        this.listener = listener;
        if (deleted) {
            this.addItem("", "Warning: Link may be malicious");
            this.addSeparator();
        }
        this.addItem("open", "Open link");
        this.addItem("copy", "Copy to clipboard");
        this.channel = Helper.getChannelFromUrl(url);
        if (this.channel != null && Helper.isValidChannel(this.channel)) {
            this.addSeparator();
            this.addItem("join", "Join #" + this.channel);
            Helper.TwitchPopoutUrlInfo popoutInfo = Helper.getPopoutUrlInfo(url);
            if (popoutInfo != null && popoutInfo.username != null) {
                this.addSeparator();
                this.dummyUser = new User(popoutInfo.username, Room.EMPTY);
                this.addItem("userinfo.#" + this.channel, String.format("User: %s in #%s", popoutInfo.username, this.channel));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            if (e.getActionCommand().equals("join")) {
                this.listener.urlMenuItemClicked(e, this.channel);
            } else if (e.getActionCommand().startsWith("userinfo.")) {
                this.listener.userMenuItemClicked(e, this.dummyUser, null, null);
            } else {
                this.listener.urlMenuItemClicked(e, this.url);
            }
        }
    }
}

