/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.TwitchClient;
import chatty.User;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import chatty.util.UserRoom;
import chatty.util.commands.Parameters;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UserContextMenu
extends ContextMenu {
    private final ContextMenuListener listener;
    private final User user;
    private final String msgId;
    private final String autoModMsgId;
    private static final String MISC_MENU = Language.getString("userCm.menu.misc");
    private static final String ROOMS_MENU = Language.getString("userCm.menu.openIn");
    public static TwitchClient client;

    public UserContextMenu(User user, String msgId, String autoModMsgId, ContextMenuListener listener) {
        this.listener = listener;
        this.user = user;
        this.msgId = msgId;
        this.autoModMsgId = autoModMsgId;
        Parameters parameters = Parameters.create(user.getRegularDisplayNick());
        parameters.putObject("room", user.getRoom());
        Helper.addUserParameters(user, msgId, autoModMsgId, parameters);
        this.addItem("userinfo", Language.getString("userCm.user", user.getDisplayNick()));
        if (client != null) {
            List<UserRoom> rooms = client.getOpenUserRooms(user);
            Collections.sort(rooms);
            if (rooms.isEmpty()) {
                this.addItem("", "No rooms", ROOMS_MENU);
            } else {
                for (UserRoom userRoom : rooms) {
                    String label = userRoom.user != null && userRoom.user.getNumberOfLines() > 0 ? String.format("%s (%s)", userRoom.room.getDisplayName(), userRoom.user.getNumberOfLines()) : userRoom.room.getDisplayName();
                    if (user.getRoom().equals(userRoom.room)) {
                        label = ">" + label;
                    }
                    this.addItem("userinfo." + userRoom.room.getChannel(), label, ROOMS_MENU);
                }
            }
        }
        this.addSeparator();
        ContextMenuHelper.addStreamsOptions(this, 1, false, parameters);
        this.addSeparator();
        this.addItem("join", Language.getString("userCm.join", user.getName()));
        this.addSeparator();
        if (autoModMsgId != null) {
            this.addItem("autoModApprove", "Approve");
            this.addItem("autoModDeny", "Deny");
            this.addSeparator();
        }
        this.addItem("copyNick", Language.getString("userCm.copyName"), MISC_MENU);
        this.addItem("copyDisplayNick", Language.getString("userCm.copyDisplayName"), MISC_MENU);
        this.addSeparator(MISC_MENU);
        ContextMenuHelper.addIgnore(this, user.getName(), MISC_MENU, false);
        ContextMenuHelper.addIgnore(this, user.getName(), MISC_MENU, true);
        this.addSeparator(MISC_MENU);
        this.addItem("setcolor", Language.getString("userCm.setColor"), MISC_MENU);
        this.addItem("setname", Language.getString("userCm.setName"), MISC_MENU);
        this.addSeparator(MISC_MENU);
        this.addItem("notes", "Notes", MISC_MENU);
        List<String> presetCategories = user.getPresetCategories();
        if (presetCategories != null) {
            String submenu = "Addressbook";
            Set<String> userCategories = user.getCategories();
            for (String presetCategory : presetCategories) {
                boolean selected = userCategories != null ? userCategories.contains(presetCategory) : false;
                this.addCheckboxItem("cat" + presetCategory, presetCategory, "Addressbook", selected);
            }
            if (!presetCategories.isEmpty()) {
                this.addSeparator("Addressbook");
            }
            if (userCategories != null) {
                this.addItem("addressbookEdit", Language.getString("dialog.button.edit"), "Addressbook");
                this.addItem("addressbookRemove", Language.getString("dialog.button.remove"), "Addressbook");
            } else {
                this.addItem("addressbookEdit", Language.getString("dialog.button.add"), "Addressbook");
            }
        }
        CommandMenuItems.addCommands(CommandMenuItems.MenuType.USER, this, parameters);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.userMenuItemClicked(e, this.user, this.msgId, this.autoModMsgId);
        }
    }
}

