/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.util.StringUtil;
import chatty.util.api.CachedImage;
import chatty.util.api.usericons.Usericon;
import java.awt.event.ActionEvent;

public class UsericonContextMenu
extends ContextMenu {
    private final ContextMenuListener listener;
    private final CachedImage<Usericon> usericonImage;

    public UsericonContextMenu(CachedImage<Usericon> usericonImage, ContextMenuListener listener) {
        this.listener = listener;
        this.usericonImage = usericonImage;
        Usericon usericon = usericonImage.getObject();
        if (usericon.type == Usericon.Type.CHANNEL_LOGO) {
            this.addItem("badgeImage", usericonImage.getSizeString(), ContextMenuHelper.ICON_IMAGE);
            this.addItem("hideChannelLogo", "Hide channel logo");
            return;
        }
        if (usericon.metaTitle.isEmpty()) {
            this.addItem("", "Badge: " + usericon.type.label);
        } else {
            this.addItem("", "Badge: " + usericon.metaTitle);
            if (!usericon.metaTitle.equals(usericon.metaDescription) && !usericon.metaDescription.isEmpty()) {
                this.addItem("", StringUtil.shortenTo(usericon.metaDescription, 30));
            }
        }
        this.addItem("badgeImage", usericonImage.getSizeString(), ContextMenuHelper.ICON_IMAGE);
        if (usericon.source != 20) {
            this.addSeparator();
            this.addItem("hideUsericonOfBadgeType", "Hide badges of this type");
        }
        String infoMenu = "More..";
        if (usericon.source == 20) {
            infoMenu = "Custom Usericon";
        }
        if (!usericon.badgeType.isEmpty()) {
            this.addItem("copyBadgeType", "ID/Version: " + usericon.badgeType.toString(), -1, infoMenu, ContextMenuHelper.ICON_COPY);
        }
        if (usericon.restriction != null) {
            if (usericon.restriction.isEmpty()) {
                this.addItem("", "No Restriction", infoMenu);
            } else {
                this.addItem("", "Restriction: " + usericon.restriction, infoMenu);
            }
        }
        if (!usericon.channelRestriction.isEmpty()) {
            this.addItem("", "Channel: " + usericon.channelRestriction, infoMenu);
        }
        if (usericon.source != 20) {
            if (usericon.badgeType.isEmpty()) {
                this.addItem("addUsericonOfBadgeType", "Override/Hide (" + usericon.type.label + ")", infoMenu);
            } else {
                this.addSeparator(infoMenu);
                this.addItem("addUsericonOfBadgeType", "Override/Hide (" + usericon.badgeType + ")", infoMenu);
                this.addItem("addUsericonOfBadgeTypeAllVariants", "Override/Hide (all " + usericon.badgeType.id + " variants)", infoMenu);
            }
        }
        if (!usericon.metaUrl.isEmpty()) {
            this.addSeparator();
            this.addItem("usericonUrl", "Click for info", ContextMenuHelper.ICON_WEB);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.usericonMenuItemClicked(e, this.usericonImage);
        }
    }
}

