/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.routing;

import chatty.User;
import chatty.gui.Channels;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.Highlighter;
import chatty.gui.MainGui;
import chatty.gui.StyleManager;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.routing.RoutingTarget;
import chatty.gui.components.routing.RoutingTargetInfo;
import chatty.gui.components.routing.RoutingTargetSettings;
import chatty.gui.components.routing.RoutingTargets;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.UserMessage;
import chatty.util.Pair;
import chatty.util.StringUtil;
import chatty.util.chatlog.ChatLog;
import chatty.util.history.HistoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class RoutingManager {
    private static final Logger LOGGER = Logger.getLogger(RoutingManager.class.getName());
    private final Map<String, RoutingTargetSettings> entries = new HashMap<String, RoutingTargetSettings>();
    private final Map<String, RoutingTarget> targets = new HashMap<String, RoutingTarget>();
    private final List<Highlighter.HighlightItem> routing = new ArrayList<Highlighter.HighlightItem>();
    private final MainGui main;
    private final StyleManager styles;
    private final Channels channels;
    private final ChatLog chatLog;
    private final ContextMenuListener contextMenuListener;

    public RoutingManager(MainGui main, Channels channels, StyleManager styles, ContextMenuListener contextMenuListener, ChatLog chatLog) {
        this.main = main;
        this.styles = styles;
        this.channels = channels;
        this.contextMenuListener = contextMenuListener;
        this.chatLog = chatLog;
        main.getSettings().addSettingChangeListener((setting, type, value) -> {
            if (setting.equals("tabsMessage")) {
                SwingUtilities.invokeLater(() -> this.loadTabSettings());
            }
        });
        this.loadSettings();
    }

    public List<RoutingTargetInfo> getInfo() {
        HashMap<String, RoutingTargetInfo> byId = new HashMap<String, RoutingTargetInfo>();
        for (Map.Entry<String, RoutingTarget> entry : this.targets.entrySet()) {
            byId.put(entry.getKey(), new RoutingTargetInfo(entry.getValue().getContent().getTitle(), entry.getValue().getNumMessages()));
            System.out.println(entry.getValue().getNumMessages() + " " + entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            if (byId.containsKey(entry.getKey())) continue;
            byId.put(entry.getKey(), new RoutingTargetInfo(((RoutingTargetSettings)entry.getValue()).getName(), -1));
        }
        ArrayList<RoutingTargetInfo> result = new ArrayList<RoutingTargetInfo>(byId.values());
        Collections.sort(result);
        return result;
    }

    public List<RoutingTargetSettings> getData() {
        return new ArrayList<RoutingTargetSettings>(this.entries.values());
    }

    public void setData(List<RoutingTargetSettings> data) {
        this.entries.clear();
        for (RoutingTargetSettings entry : data) {
            this.entries.put(entry.getId(), entry);
            RoutingTarget target = this.targets.get(entry.getId());
            if (target == null) continue;
            target.setName(entry.getName());
            target.settingsUpdated();
        }
        this.saveSettings();
    }

    public void updateRouting(List<String> items) {
        this.routing.clear();
        for (String input : items) {
            Highlighter.HighlightItem item = new Highlighter.HighlightItem(input, "routing");
            if (item.hasError()) {
                LOGGER.warning("Error parsing routing item: " + item.getError());
                continue;
            }
            if (item.getRoutingTargets() == null) {
                LOGGER.warning("Error parsing routing item (no targets): " + item);
                continue;
            }
            this.routing.add(item);
        }
    }

    public void setChannel(Channel channel) {
        for (RoutingTarget target : this.targets.values()) {
            target.setChannel(channel.getChannel(), false);
        }
    }

    public void addUserMessage(RoutingTargets targets, UserMessage message, User localUser) {
        if (!this.filterTargets(targets)) {
            this.addRoutingTargets(targets, message, localUser);
        }
        this.filterTargets(targets);
        if (!targets.hasTargets()) {
            return;
        }
        for (Map.Entry<String, Pair<String, Highlighter.HighlightItem>> t : targets.getResultTargets().entrySet()) {
            String name = (String)t.getValue().key;
            Highlighter.HighlightItem hlItem = (Highlighter.HighlightItem)t.getValue().value;
            if (!HistoryUtil.checkAllowMatch(message.tags, "Routing", hlItem, this.main.getSettings())) continue;
            RoutingTarget target = this.getTarget(name);
            UserMessage thisMessage = message.copy();
            thisMessage.routingSource = hlItem;
            target.addMessage(localUser.getChannel(), thisMessage);
            RoutingTargetSettings ts = this.getSettings(name);
            switch (ts.openOnMessage) {
                case 1: 
                case 2: {
                    this.channels.addContent(target.getContent());
                }
            }
            if (!ts.shouldLog() || message.tags != null && message.tags.isHistoricMsg()) continue;
            this.chatLog.message(ts.getPrefixedLogFilename(), message.user, message.text, message.action, message.user.getChannel());
        }
    }

    public void addInfoMessage(RoutingTargets targets, InfoMessage message, User user, User localUser, Channel channel) {
        if (!this.filterTargets(targets)) {
            this.addRoutingTargets(targets, message, user, localUser);
        }
        this.filterTargets(targets);
        if (!targets.hasTargets()) {
            return;
        }
        for (Map.Entry<String, Pair<String, Highlighter.HighlightItem>> t : targets.getResultTargets().entrySet()) {
            String name = (String)t.getValue().key;
            Highlighter.HighlightItem hlItem = (Highlighter.HighlightItem)t.getValue().value;
            RoutingTarget target = this.getTarget(name);
            InfoMessage thisMessage = message.copy();
            thisMessage.routingSource = hlItem;
            thisMessage.localUser = localUser;
            target.addInfoMessage(channel.getChannel(), thisMessage);
            RoutingTargetSettings ts = this.getSettings(name);
            switch (ts.openOnMessage) {
                case 1: 
                case 3: {
                    this.channels.addContent(target.getContent());
                }
            }
            if (!ts.shouldLog()) continue;
            this.chatLog.info(ts.getPrefixedLogFilename(), message.text, channel.getChannel());
        }
    }

    public void addBan(User user, long duration, String reason, String targetMsgId) {
        for (RoutingTarget target : this.targets.values()) {
            target.addBan(user, duration, reason, targetMsgId);
        }
    }

    public void addNotification(String targetName, String channel, InfoMessage msg) {
        RoutingTarget target = this.getTarget(targetName);
        target.addInfoMessage(channel, msg);
        RoutingTargetSettings ts = this.getSettings(targetName);
        switch (ts.openOnMessage) {
            case 1: 
            case 3: {
                this.channels.addContent(target.getContent());
            }
        }
        if (ts.shouldLog()) {
            this.chatLog.info(ts.getPrefixedLogFilename(), msg.text, null);
        }
    }

    private void addRoutingTargets(RoutingTargets targets, UserMessage message, User localUser) {
        for (Highlighter.HighlightItem item : this.routing) {
            if (!item.matches(Highlighter.HighlightItem.Type.REGULAR, message.text, message.user, localUser, message.tags)) continue;
            targets.add(item);
            if (this.isRoutingMulti()) continue;
            return;
        }
    }

    private void addRoutingTargets(RoutingTargets targets, InfoMessage message, User user, User localUser) {
        for (Highlighter.HighlightItem item : this.routing) {
            if (!item.matches(Highlighter.HighlightItem.Type.INFO, message.text, user, localUser, message.tags)) continue;
            targets.add(item);
            if (this.isRoutingMulti()) continue;
            return;
        }
    }

    private boolean filterTargets(RoutingTargets targets) {
        if (targets.hasTargets() && !this.main.getSettings().getBoolean("routingMulti")) {
            targets.removeAllExceptFirst();
            return true;
        }
        return false;
    }

    private boolean isRoutingMulti() {
        return this.main.getSettings().getBoolean("routingMulti");
    }

    public void addTarget(String id) {
        this.channels.addContent(this.getTarget(id).getContent());
    }

    public void selectTarget(String name) {
        RoutingTarget target = this.getTarget(name);
        this.channels.addContent(target.getContent());
        this.channels.getDock().setActiveContent(target.getContent());
    }

    private RoutingTarget getTarget(String targetName) {
        String targetId = RoutingManager.toId(targetName);
        RoutingTargetSettings ts = this.getSettings(targetName);
        RoutingTarget target = this.targets.get(targetId);
        if (target == null) {
            target = new RoutingTarget(targetId, ts.getName(), this.main, this.styles, this.channels, this.contextMenuListener, this);
            this.targets.put(targetId, target);
            this.loadTabSettings(target.getContent());
        }
        return target;
    }

    protected void updateSettings(String targetId, RoutingTargetSettings settings) {
        this.entries.put(targetId, settings);
        this.targets.get(targetId).settingsUpdated();
        this.saveSettings();
    }

    public static String toId(String name) {
        return StringUtil.toLowerCase(name);
    }

    private static String contentIdToTargetId(String id) {
        return id.substring(1, id.length() - 1);
    }

    protected RoutingTargetSettings getSettings(String targetName) {
        String targetId = RoutingManager.toId(targetName);
        RoutingTargetSettings entry = this.entries.get(targetId);
        if (entry == null) {
            entry = new RoutingTargetSettings(targetName, 1, true, false, "", 0, false, false, 22, 0);
            this.entries.put(targetId, entry);
        }
        return entry;
    }

    private void loadSettings() {
        List settingsList = this.main.getSettings().getList("routingTargets");
        for (Object item : settingsList) {
            RoutingTargetSettings entry = RoutingTargetSettings.fromList((List)item);
            if (entry == null) continue;
            this.entries.put(entry.getId(), entry);
        }
    }

    private void saveSettings() {
        ArrayList<List> settingsData = new ArrayList<List>();
        for (RoutingTargetSettings entry : this.entries.values()) {
            settingsData.add(entry.toList());
        }
        this.main.getSettings().putList("routingTargets", settingsData);
    }

    private void loadTabSettings() {
        for (RoutingTarget t : this.targets.values()) {
            this.loadTabSettings(t.getContent());
        }
    }

    private void loadTabSettings(DockStyledTabContainer content) {
        if (content instanceof DockStyledTabContainer) {
            content.setSettings(0L, this.main.getSettings().getLong("tabsMessage"), 0L, 0L, 0L, -1L);
        }
    }

    public void refreshStyles() {
        for (RoutingTarget target : this.targets.values()) {
            target.refreshStyles();
        }
    }

    public void scroll(String contentId, String action) {
        RoutingTarget target = this.targets.get(RoutingManager.contentIdToTargetId(contentId));
        if (target != null) {
            target.scroll(action);
        }
    }
}

