/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.routing;

import chatty.User;
import chatty.gui.Channels;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.MainGui;
import chatty.gui.StyleManager;
import chatty.gui.StyleServer;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.RoutingTargetContextMenu;
import chatty.gui.components.menus.TabContextMenu;
import chatty.gui.components.routing.RoutingManager;
import chatty.gui.components.routing.RoutingTargetSettings;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.Message;
import chatty.util.Timestamp;
import chatty.util.colors.ColorCorrector;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class RoutingTarget {
    private final String targetId;
    private final DockStyledTabContainer<JComponent> content;
    private int numMessages;
    private final MainGui main;
    private final StyleServer modifiedStyles;
    private final ContextMenuListener contextMenuListener;
    private final Channels channels;
    private final RoutingManager routingManager;
    private static final String EMPTY_CHANNEL_KEY = "--empty--";
    private static final String ALL_CHANNEL_KEY = "--all--";
    private final Map<String, TextPane> textPanes = new HashMap<String, TextPane>();
    private final Set<String> unread = new HashSet<String>();
    private final JPanel base;
    private final CardLayout cardLayout;
    private TextPane emptyChannel;
    private String currentChannel;
    private String currentKey;

    public RoutingTarget(String id, String title, final MainGui main, final StyleManager styles, final Channels channels, final ContextMenuListener contextMenuListener, RoutingManager routingManager) {
        this.targetId = id;
        this.routingManager = routingManager;
        this.main = main;
        this.contextMenuListener = contextMenuListener;
        this.channels = channels;
        this.modifiedStyles = new StyleServer(){

            @Override
            public Color getColor(String type) {
                return styles.getColor(type);
            }

            @Override
            public MutableAttributeSet getStyle(String type) {
                if (type.equals("settings")) {
                    SimpleAttributeSet attr = new SimpleAttributeSet(styles.getStyle(type));
                    attr.addAttribute((Object)ChannelTextPane.Setting.SHOW_BANMESSAGES, false);
                    attr.addAttribute((Object)ChannelTextPane.Setting.CHANNEL_LOGO_SIZE, RoutingTarget.this.channelLogo());
                    attr.addAttribute((Object)ChannelTextPane.Setting.SHOW_CHANNEL_NAME, RoutingTarget.this.showChannelName());
                    return attr;
                }
                return styles.getStyle(type);
            }

            @Override
            public Font getFont(String type) {
                return styles.getFont(type);
            }

            @Override
            public Timestamp getTimestampFormat() {
                return styles.getTimestampFormat();
            }

            @Override
            public ColorCorrector getColorCorrector() {
                return styles.getColorCorrector();
            }
        };
        this.cardLayout = new CardLayout();
        this.base = new JPanel(this.cardLayout);
        String contentId = "'" + id + "'";
        this.content = new DockStyledTabContainer<JComponent>((JComponent)this.base, contentId, channels.getDock()){

            @Override
            public JPopupMenu getContextMenu() {
                return new TabContextMenu(contextMenuListener, this, Channels.getCloseTabs(channels, this, main.getSettings().getBoolean("closeTabsSameType")), main.getSettings());
            }
        };
        this.content.setId(contentId);
        this.content.setTitle(title);
        this.getTextPane(ALL_CHANNEL_KEY);
        this.showChannel(null, ALL_CHANNEL_KEY);
    }

    public void settingsUpdated() {
        this.setChannel(this.currentChannel, true);
        this.refreshStyles();
    }

    private int multiChannel() {
        return this.routingManager.getSettings((String)this.targetId).multiChannel;
    }

    private boolean showAll() {
        return this.routingManager.getSettings((String)this.targetId).showAll;
    }

    private boolean channelFixed() {
        return this.routingManager.getSettings((String)this.targetId).channelFixed;
    }

    private int channelLogo() {
        return this.routingManager.getSettings((String)this.targetId).channelLogo;
    }

    private int showChannelName() {
        return this.routingManager.getSettings((String)this.targetId).showChannelName;
    }

    public void setChannel(String channel, boolean force) {
        if (this.multiChannel() == 0 || this.showAll()) {
            this.showChannel(null, ALL_CHANNEL_KEY);
            if (!(this.channelFixed() && this.currentChannel != null || channel == null)) {
                this.currentChannel = channel;
            }
            return;
        }
        if (this.channelFixed() && this.currentChannel != null && !force) {
            return;
        }
        if (this.textPanes.containsKey(channel)) {
            this.showChannel(channel, channel);
        } else {
            if (this.emptyChannel == null) {
                this.emptyChannel = this.createTextPane(EMPTY_CHANNEL_KEY);
            }
            this.showChannel(channel, EMPTY_CHANNEL_KEY);
        }
    }

    private void showChannel(String channel, String key) {
        if (this.content.isContentVisible()) {
            this.unread.remove(key);
        }
        this.content.setNewMessage(this.unread.contains(key));
        this.cardLayout.show(this.base, key);
        if (channel != null) {
            this.content.setLongTitle(String.format("%s (%s)", this.content.getTitle(), channel));
            this.currentChannel = channel;
        } else {
            this.content.setLongTitle(String.format("%s", this.content.getTitle()));
        }
        this.currentKey = key;
    }

    private TextPane getTextPane(String channel) {
        TextPane textPane = this.textPanes.get(channel);
        if (textPane == null) {
            textPane = this.createTextPane(channel);
            this.textPanes.put(channel, textPane);
            if (Objects.equals(this.currentChannel, channel)) {
                this.showChannel(channel, channel);
            }
        }
        return textPane;
    }

    private TextPane createTextPane(String channel) {
        TextPane textPane = new TextPane(this.main, this.modifiedStyles);
        JScrollPane scroll = new JScrollPane(textPane);
        textPane.setScrollPane(scroll);
        textPane.setContextMenuListener(new ContextMenuAdapter(this.contextMenuListener){

            @Override
            public void menuItemClicked(ActionEvent e) {
                if (e.getActionCommand().equals("clearAll")) {
                    RoutingTarget.this.clearAll();
                } else if (e.getActionCommand().equals("clearCurrent")) {
                    RoutingTarget.this.clearCurrent();
                } else if (e.getActionCommand().startsWith("dockChangeChannel.")) {
                    String chan = e.getActionCommand().substring("dockChangeChannel.".length());
                    if (chan.equals("all")) {
                        chan = RoutingTarget.ALL_CHANNEL_KEY;
                    }
                    RoutingTarget.this.setChannel(chan, true);
                } else if (e.getActionCommand().equals("dockChannelsShowAll")) {
                    RoutingTargetSettings settings = RoutingTarget.this.routingManager.getSettings(RoutingTarget.this.targetId);
                    boolean showAll = !settings.showAll;
                    RoutingTarget.this.routingManager.updateSettings(RoutingTarget.this.targetId, settings.setShowAll(showAll));
                } else if (e.getActionCommand().equals("dockToggleFixedChannel")) {
                    RoutingTargetSettings settings = RoutingTarget.this.routingManager.getSettings(RoutingTarget.this.targetId);
                    RoutingTarget.this.routingManager.updateSettings(RoutingTarget.this.targetId, settings.setChannelFixed(!settings.channelFixed));
                } else if (e.getActionCommand().startsWith("logoSize")) {
                    int size = Integer.parseInt(e.getActionCommand().substring("logoSize".length()));
                    RoutingTargetSettings settings = RoutingTarget.this.routingManager.getSettings(RoutingTarget.this.targetId);
                    RoutingTarget.this.routingManager.updateSettings(RoutingTarget.this.targetId, settings.setChannelLogo(size));
                }
                ContextMenuHelper.handleNumericOption(e.getActionCommand(), "showChannelName", value -> {
                    RoutingTargetSettings settings = RoutingTarget.this.routingManager.getSettings(RoutingTarget.this.targetId);
                    RoutingTarget.this.routingManager.updateSettings(RoutingTarget.this.targetId, settings.setShowChannelName(value.intValue()));
                });
                super.menuItemClicked(e);
            }
        });
        this.base.add((Component)scroll, channel);
        return textPane;
    }

    public void messageAdded(String channelKey) {
        ++this.numMessages;
        boolean currentChan = Objects.equals(this.currentKey, channelKey);
        if (!this.content.isContentVisible() || !currentChan) {
            this.unread.add(channelKey);
        }
        if (!this.content.isContentVisible() && currentChan) {
            this.content.setNewMessage(true);
        }
    }

    private void performForChannel(String channel, boolean isMsg, Consumer<TextPane> action) {
        if (this.multiChannel() == 0 || this.multiChannel() == 2) {
            action.accept(this.getTextPane(ALL_CHANNEL_KEY));
            if (isMsg) {
                this.messageAdded(ALL_CHANNEL_KEY);
            }
        }
        if (this.multiChannel() > 0 && channel != null) {
            action.accept(this.getTextPane(channel));
            if (isMsg) {
                this.messageAdded(channel);
            }
        }
    }

    public void addMessage(String channel, Message message) {
        this.performForChannel(channel, true, t -> t.printMessage(message));
    }

    public void addInfoMessage(String channel, InfoMessage message) {
        this.performForChannel(channel, true, t -> t.printInfoMessage(message));
    }

    public void addBan(User user, long duration, String reason, String targetMsgId) {
        this.performForChannel(user.getChannel(), false, t -> t.userBanned(user, duration, reason, targetMsgId));
    }

    public void refreshStyles() {
        for (TextPane textPane : this.textPanes.values()) {
            textPane.refreshStyles();
        }
    }

    public void clearAll() {
        this.numMessages = 0;
        for (Map.Entry<String, TextPane> entry : this.textPanes.entrySet()) {
            entry.getValue().clearAll();
            this.unread.remove(entry.getKey());
        }
    }

    public void clearCurrent() {
        TextPane textPane = this.textPanes.get(this.currentKey);
        if (textPane != null) {
            textPane.clearAll();
            this.unread.remove(this.currentKey);
        }
    }

    public DockStyledTabContainer<JComponent> getContent() {
        return this.content;
    }

    public int getNumMessages() {
        return this.numMessages;
    }

    protected void setName(String name) {
        this.content.setTitle(name);
    }

    protected void scroll(String action) {
        TextPane textPane = this.textPanes.get(this.currentKey);
        if (textPane != null) {
            Channel.scroll(textPane.getScrollPane().getVerticalScrollBar(), action);
        }
    }

    class TextPane
    extends ChannelTextPane {
        private JScrollPane scrollPane;

        public TextPane(MainGui main, StyleServer styleServer) {
            super(main, styleServer, ChannelTextPane.Type.REGULAR, true, main.getSettings().getBoolean("chatInsertTop"));
            this.linkController.setContextMenuCreator(() -> new RoutingTargetContextMenu(RoutingTarget.this.multiChannel() > 0 ? RoutingTarget.this.channels.getChannelsOfType(Channel.Type.CHANNEL) : null, ((RoutingTarget)RoutingTarget.this).routingManager.getSettings((String)((RoutingTarget)RoutingTarget.this).targetId).channelFixed, RoutingTarget.this.multiChannel() == 2, ((RoutingTarget)RoutingTarget.this).routingManager.getSettings((String)((RoutingTarget)RoutingTarget.this).targetId).showAll, RoutingTarget.this.currentChannel, RoutingTarget.this.channelLogo(), RoutingTarget.this.showChannelName()));
        }

        @Override
        public void setScrollPane(JScrollPane scrollPane) {
            super.setScrollPane(scrollPane);
            this.scrollPane = scrollPane;
        }

        public JScrollPane getScrollPane() {
            return this.scrollPane;
        }
    }
}

