/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.routing;

import chatty.gui.components.routing.RoutingManager;
import chatty.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class RoutingTargetSettings {
    private static Logger LOGGER = Logger.getLogger(RoutingTargetSettings.class.getName());
    private static final Map<Long, String> openOnMessageValues = new HashMap<Long, String>();
    public static final int CHANNEL_LOGO_DEFAULT = 22;
    public static final int SHOW_CHANNEL_NAME_DEFAULT = 0;
    private final String targetName;
    public final int openOnMessage;
    public final boolean exclusive;
    private final String id;
    public final boolean logEnabled;
    private final String logFilename;
    public final int multiChannel;
    public final boolean channelFixed;
    public final boolean showAll;
    public final int channelLogo;
    public final int showChannelName;

    public RoutingTargetSettings(String targetName, int openOnMessage, boolean exlusive, boolean logEnabled, String logFilename, int multiChannel, boolean channelFixed, boolean showAll, int channelLogo, int showChannelName) {
        this.targetName = targetName;
        this.openOnMessage = openOnMessage;
        this.exclusive = exlusive;
        this.id = RoutingManager.toId(targetName);
        this.logEnabled = logEnabled;
        this.logFilename = logFilename;
        this.multiChannel = multiChannel;
        this.channelFixed = channelFixed;
        this.showAll = showAll;
        this.channelLogo = channelLogo;
        this.showChannelName = showChannelName;
    }

    public String getName() {
        return this.targetName;
    }

    public String getId() {
        return this.id;
    }

    public boolean shouldLog() {
        return this.logEnabled && this.logFilename != null && !this.logFilename.isEmpty();
    }

    public String getRawLogFilename() {
        return this.logFilename;
    }

    public String getPrefixedLogFilename() {
        return this.shouldLog() ? "customTab-" + this.logFilename : null;
    }

    public String getFullLogFilename() {
        return this.shouldLog() ? "customTab-" + this.logFilename + ".log" : null;
    }

    public String makeSettingsInfo() {
        String info = openOnMessageValues.get(this.openOnMessage);
        if (this.multiChannel == 1) {
            info = info + ", by channel";
        } else if (this.multiChannel == 2) {
            info = info + ", by channel/all";
        }
        return info;
    }

    public RoutingTargetSettings setChannelFixed(boolean newValue) {
        if (this.channelFixed == newValue) {
            return this;
        }
        return new RoutingTargetSettings(this.targetName, this.openOnMessage, this.exclusive, this.logEnabled, this.logFilename, this.multiChannel, newValue, this.showAll, this.channelLogo, this.showChannelName);
    }

    public RoutingTargetSettings setShowAll(boolean newValue) {
        if (this.showAll == newValue) {
            return this;
        }
        return new RoutingTargetSettings(this.targetName, this.openOnMessage, this.exclusive, this.logEnabled, this.logFilename, this.multiChannel, this.channelFixed, newValue, this.channelLogo, this.showChannelName);
    }

    public RoutingTargetSettings setChannelLogo(int newValue) {
        if (this.channelLogo == newValue) {
            return this;
        }
        return new RoutingTargetSettings(this.targetName, this.openOnMessage, this.exclusive, this.logEnabled, this.logFilename, this.multiChannel, this.channelFixed, this.showAll, newValue, this.showChannelName);
    }

    public RoutingTargetSettings setShowChannelName(int newValue) {
        if (this.showChannelName == newValue) {
            return this;
        }
        return new RoutingTargetSettings(this.targetName, this.openOnMessage, this.exclusive, this.logEnabled, this.logFilename, this.multiChannel, this.channelFixed, this.showAll, this.channelLogo, newValue);
    }

    public List toList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.targetName);
        result.add(this.openOnMessage);
        result.add(this.exclusive ? 1 : 0);
        result.add(this.logEnabled ? 1 : 0);
        result.add(this.logFilename);
        result.add(this.multiChannel);
        result.add(this.channelFixed ? 1 : 0);
        result.add(this.showAll ? 1 : 0);
        result.add(this.channelLogo);
        result.add(this.showChannelName);
        return result;
    }

    public static RoutingTargetSettings fromList(List list) {
        try {
            String name = (String)list.get(0);
            int openOnMessage = ((Number)list.get(1)).intValue();
            boolean exclusive = MiscUtil.isNumTrue(list.get(2));
            boolean logEnabled = false;
            String logFile = "";
            int multiChannel = 0;
            boolean channelFixed = false;
            boolean showAll = false;
            int channelLogo = 22;
            int showChannelName = 0;
            if (list.size() > 3) {
                logEnabled = MiscUtil.isNumTrue(list.get(3));
                logFile = (String)list.get(4);
                multiChannel = ((Number)list.get(5)).intValue();
                channelFixed = MiscUtil.isNumTrue(list.get(6));
                showAll = MiscUtil.isNumTrue(list.get(7));
            }
            if (list.size() > 8) {
                channelLogo = ((Number)list.get(8)).intValue();
            }
            if (list.size() > 9) {
                showChannelName = ((Number)list.get(9)).intValue();
            }
            return new RoutingTargetSettings(name, openOnMessage, exclusive, logEnabled, logFile, multiChannel, channelFixed, showAll, channelLogo, showChannelName);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing routing entry: " + ex);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingTargetSettings other = (RoutingTargetSettings)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public static Map<Long, String> getOpenOnMessageValues() {
        return new HashMap<Long, String>(openOnMessageValues);
    }

    static {
        openOnMessageValues.put(0L, "Don't open on message");
        openOnMessageValues.put(1L, "Open on any message");
        openOnMessageValues.put(2L, "Open on regular chat message");
        openOnMessageValues.put(3L, "Open on info message");
    }
}

