/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.routing;

import chatty.gui.Highlighter;
import chatty.gui.components.routing.RoutingManager;
import chatty.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RoutingTargets {
    private LinkedHashMap<String, Pair<String, Highlighter.HighlightItem>> resultTargets;

    public void add(Highlighter.HighlightItem hlItem) {
        List<String> targets = hlItem.getRoutingTargets();
        if (targets != null && !targets.isEmpty()) {
            if (this.resultTargets == null) {
                this.resultTargets = new LinkedHashMap();
            }
            for (String target : targets) {
                String id = RoutingManager.toId(target);
                if (this.resultTargets.containsKey(id)) continue;
                this.resultTargets.put(id, new Pair<String, Highlighter.HighlightItem>(target, hlItem));
            }
        }
    }

    public Map<String, Pair<String, Highlighter.HighlightItem>> getResultTargets() {
        return this.resultTargets;
    }

    public boolean hasTargets() {
        return this.resultTargets != null && !this.resultTargets.isEmpty();
    }

    public void removeAllExceptFirst() {
        if (this.resultTargets == null || this.resultTargets.size() == 1) {
            return;
        }
        Map.Entry<String, Pair<String, Highlighter.HighlightItem>> entry = this.resultTargets.entrySet().iterator().next();
        this.resultTargets = new LinkedHashMap();
        this.resultTargets.put(entry.getKey(), entry.getValue());
    }
}

