/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.MiscUtil;
import chatty.util.settings.FileManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class BackupManager
extends JDialog {
    private final JTable table;
    private final MyTableModel data;
    private final FileManager fileManager;
    private final JButton loadButton;
    private final JButton deleteButton;
    private final JButton openDirButton;
    private final JTextArea infoText;

    public BackupManager(Window parent, FileManager fileManager) {
        super(parent);
        this.setTitle(Language.getString("settings.backup.title"));
        this.setLayout(new GridBagLayout());
        this.fileManager = fileManager;
        this.data = new MyTableModel();
        this.table = new JTable(this.data){

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.rowAtPoint(e.getPoint());
                int column = this.columnAtPoint(e.getPoint());
                if (row == -1 || column == -1) {
                    return null;
                }
                FileManager.FileInfo info = BackupManager.this.data.getRowData(this.convertRowIndexToModel(row));
                column = this.convertColumnIndexToModel(column);
                switch (column) {
                    case 0: {
                        return info.getFile().toString();
                    }
                    case 1: {
                        return String.format("%d bytes", info.getSize());
                    }
                    case 2: {
                        return String.format("Modified: %s", DateTime.formatFullDatetime(info.getModifiedTime()));
                    }
                    case 3: {
                        return String.format("Backup Created: %s", DateTime.formatFullDatetime(info.getCreated()));
                    }
                    case 4: {
                        return info.getInfo();
                    }
                }
                return null;
            }
        };
        FontMetrics measure = new JLabel().getFontMetrics(this.table.getFont());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(measure.stringWidth("manual_1586904521__settings") + 20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(measure.stringWidth("12345") + 10);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(measure.stringWidth("12 hours ago") + 10);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(measure.stringWidth("12 hours ago") + 10);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(420);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new AgoRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new AgoRenderer());
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> this.update());
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(3, SortOrder.DESCENDING)));
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 3, 1);
        this.add((Component)new JLabel("<html><body width='600px'>" + SettingsUtil.getInfo("info-backup.html", null)), gbc);
        gbc = GuiUtil.makeGbc(0, 1, 3, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.8;
        JScrollPane tableScroll = new JScrollPane(this.table);
        tableScroll.setPreferredSize(new Dimension(this.table.getPreferredSize().width, 200));
        this.add((Component)tableScroll, gbc);
        this.openDirButton = new JButton("Open Backup Directory");
        this.openDirButton.addActionListener(e -> MiscUtil.openFile(fileManager.getBackupPath().toFile(), (Component)this));
        gbc = GuiUtil.makeGbc(0, 2, 1, 1);
        gbc.weightx = 2.0;
        gbc.anchor = 17;
        this.add((Component)this.openDirButton, gbc);
        this.deleteButton = new JButton("Delete Selected Backup");
        this.deleteButton.addActionListener(e -> this.deleteBackup());
        gbc = GuiUtil.makeGbc(2, 2, 1, 1);
        this.add((Component)this.deleteButton, gbc);
        this.loadButton = new JButton("Load Selected Backup");
        this.loadButton.addActionListener(e -> this.loadBackup());
        gbc = GuiUtil.makeGbc(1, 2, 1, 1);
        this.add((Component)this.loadButton, gbc);
        this.infoText = new JTextArea();
        this.infoText.setEditable(false);
        this.infoText.setRows(5);
        this.infoText.setMinimumSize(this.infoText.getPreferredSize());
        gbc = GuiUtil.makeGbc(0, 3, 3, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.4;
        this.add((Component)new JScrollPane(this.infoText), gbc);
    }

    private void update() {
        FileManager.FileInfo selected = this.getSelected();
        this.loadButton.setEnabled(selected != null);
        this.deleteButton.setEnabled(selected != null);
        if (selected != null) {
            this.infoText.setText(String.format("The following file will be copied when loading the backup:\n[From]\n %s\n[To]\n %s", selected.getFile(), selected.getSettings().path));
        }
    }

    private FileManager.FileInfo getSelected() {
        int selected = this.table.getSelectedRow();
        if (selected != -1) {
            return this.data.getRowData(this.table.convertRowIndexToModel(selected));
        }
        return null;
    }

    private void deleteBackup() {
        FileManager.FileInfo selected = this.getSelected();
        if (selected != null) {
            try {
                int selectedRow = this.table.getSelectedRow();
                Files.delete(selected.getFile());
                this.infoText.setText(String.format("Deleted %s", selected.getFile()));
                this.refreshList();
                this.table.getSelectionModel().setSelectionInterval(0, selectedRow < this.table.getRowCount() ? selectedRow : this.table.getRowCount() - 1);
            }
            catch (IOException ex) {
                this.infoText.setText("Error deleting backup: " + ex);
            }
        }
    }

    private void loadBackup() {
        FileManager.FileInfo selected = this.getSelected();
        if (selected != null) {
            try {
                this.fileManager.loadBackup(selected);
                this.infoText.setText(String.format("[Copied]\n %s\n[To]\n %s\nYou may restart Chatty now or load another backup.", selected.getFile(), selected.getSettings().path));
            }
            catch (IOException ex) {
                this.infoText.setText("Error loading backup: " + ex);
            }
        }
    }

    private void refreshList() {
        try {
            this.data.setData(this.fileManager.getBackupFileInfo().getList());
        }
        catch (IOException ex) {
            this.infoText.setText("Error loading list: " + ex);
        }
    }

    public void open() {
        this.refreshList();
        this.update();
        this.pack();
        this.setVisible(true);
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private final String[] COLUMNS = new String[]{"Filename", "Size", "Modified", "Created", "Info"};
        private final List<FileManager.FileInfo> data = new ArrayList<FileManager.FileInfo>();

        private MyTableModel() {
        }

        public void setData(List<FileManager.FileInfo> data) {
            this.data.clear();
            this.data.addAll(data);
            super.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        public FileManager.FileInfo getRowData(int index) {
            return this.data.get(index);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMNS[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FileManager.FileInfo info = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return info.getFile().getFileName();
                }
                case 1: {
                    return info.getSize();
                }
                case 2: {
                    return info.getModifiedTime();
                }
                case 3: {
                    return info.getCreated();
                }
                case 4: {
                    return info.getInfo();
                }
            }
            return null;
        }
    }

    private static class AgoRenderer
    extends DefaultTableCellRenderer {
        private AgoRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Long) {
                this.setText(DateTime.agoText((Long)value));
            } else {
                this.setText("");
            }
        }
    }
}

