/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SimpleTableEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChatSettings
extends SettingsPanel {
    private static final String PAUSE_CHAT_INFO = "<html><body style='width:310px'>Pausing the chat stops scrolling, only works when window already filled with messages (and thus scrollbar is active). Read the help for more information.";

    public ChatSettings(SettingsDialog d) {
        JPanel main = this.addTitledPanel("Chat Settings", 0, true);
        JPanel autoScrollPanel = new JPanel();
        autoScrollPanel.add(d.addSimpleBooleanSetting("autoScroll", "Scroll down after", "After the given number of seconds of not changing position of the scrollbar, automatically scroll down."));
        autoScrollPanel.add(d.addSimpleLongSetting("autoScrollTimeout", 3, true));
        autoScrollPanel.add(new JLabel("seconds of inactiviy"));
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 3, 1, 17);
        gbc.insets = new Insets(4, 1, 0, 5);
        main.add((Component)autoScrollPanel, gbc);
        SettingsUtil.addLabeledComponent(main, "bufferSize", 0, 4, 1, 17, d.addSimpleLongSetting("bufferSize", 3, true));
        BufferSizes bufferSizes = new BufferSizes(d);
        JButton bufferSizesButton = new JButton("Per tab buffer sizes");
        GuiUtil.smallButtonInsets(bufferSizesButton);
        bufferSizesButton.addActionListener(e -> {
            bufferSizes.setLocationRelativeTo(this);
            bufferSizes.setVisible(true);
        });
        gbc = SettingsDialog.makeGbc(2, 4, 1, 1, 17);
        main.add((Component)bufferSizesButton, gbc);
        gbc = SettingsDialog.makeGbc(0, 6, 3, 1, 17);
        main.add((Component)d.addSimpleBooleanSetting("showImageTooltips"), gbc);
        gbc = SettingsDialog.makeGbcSub(0, 7, 3, 1, 17);
        main.add((Component)d.addSimpleBooleanSetting("showTooltipImages"), gbc);
        gbc = SettingsDialog.makeGbc(0, 8, 3, 1, 17);
        main.add((Component)d.addSimpleBooleanSetting("mentionReplyRestricted"), gbc);
        gbc = SettingsDialog.makeGbc(0, 9, 3, 1, 17);
        main.add((Component)d.addSimpleBooleanSetting("chatInsertTop"), gbc);
        JPanel pauseChat = this.addTitledPanel("Pause Chat", 1);
        gbc = SettingsDialog.makeGbc(0, 0, 3, 1);
        ++gbc.insets.bottom;
        pauseChat.add((Component)new JLabel(PAUSE_CHAT_INFO), gbc);
        final SimpleBooleanSetting pause = d.addSimpleBooleanSetting("pauseChatOnMouseMove", "Pause chat when moving the mouse over it", "Stop scrolling while moving the mouse over chat (only if the scrollbar is active)");
        pause.setSelected(true);
        pauseChat.add((Component)pause, SettingsDialog.makeGbc(0, 1, 3, 1, 17));
        final SimpleBooleanSetting ctrl = d.addSimpleBooleanSetting("pauseChatOnMouseMoveCtrlRequired", "Require Ctrl being pressed to start pausing chat", "Requires you to have Ctrl pressed when moving the mouse over that to pause chat");
        gbc = SettingsDialog.makeGbc(0, 2, 3, 1, 17);
        gbc.insets.left += 10;
        gbc.insets.top -= 4;
        pauseChat.add((Component)ctrl, gbc);
        pause.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ctrl.setEnabled(pause.isSelected());
            }
        });
        JPanel commandPanel = new JPanel(new GridBagLayout());
        LinkedHashMap<String, String> commandsDef = new LinkedHashMap<String, String>();
        commandsDef.put("commandOnCtrlClick", "Run command when clicking on user (holding Ctrl):");
        commandsDef.put("commandOnMiddleClick", "Run command when middle-clicking on user:");
        commandsDef.put("commandOnCtrlMiddleClick", "Run command when middle-clicking on user (holding Ctrl):");
        int commandY = 0;
        for (Map.Entry entry : commandsDef.entrySet()) {
            commandPanel.add((Component)new JLabel((String)entry.getValue()), SettingsDialog.makeGbc(0, commandY, 1, 1, 17));
            HashMap<String, String> commandChoices = new HashMap<String, String>();
            commandChoices.put("", "Off");
            commandChoices.put("/timeout", "Timeout");
            commandChoices.put("/ban", "Ban");
            commandChoices.put("/delete $$(msg-id)", "Delete message");
            ComboStringSetting commandOnCtrlClick = d.addComboStringSetting((String)entry.getKey(), 100, true, commandChoices);
            gbc = SettingsDialog.makeGbc(0, commandY + 1, 1, 1);
            gbc.fill = 2;
            commandPanel.add((Component)commandOnCtrlClick, gbc);
            commandY += 2;
        }
        gbc = SettingsDialog.makeGbc(0, commandY, 1, 1);
        commandPanel.add((Component)new LinkLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>When manually editing the command: If there is only a single word, it will execute the built-in command of that name (username as parameter), otherwise you can use [help-commands:replacements Custom Command Replacements] such as <code>$1</code> (username) or <code>$(msg-id)</code>.", d.getLinkLabelListener()), gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 3, 1, 17);
        gbc.insets = new Insets(0, 0, 0, 0);
        pauseChat.add((Component)commandPanel, gbc);
    }

    private static class BufferSizes
    extends JDialog {
        private static final String INFO = SettingsUtil.getInfo("info-buffer_sizes.html", null);

        private BufferSizes(SettingsDialog d) {
            super(d);
            this.setDefaultCloseOperation(1);
            this.setLayout(new GridBagLayout());
            this.setTitle("Per-tab buffer size (scrollback)");
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
            this.add((Component)new JLabel(INFO), gbc);
            gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            SimpleTableEditor<Long> editor = d.addLongMapSetting("bufferSizes", 300, 200, "Tab Name", "Buffer Size");
            this.add(editor, gbc);
            gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            JButton closeButton = new JButton("Close");
            this.add((Component)closeButton, gbc);
            closeButton.addActionListener(e -> this.setVisible(false));
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
        }
    }
}

