/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.NamedColorsPanel;
import chatty.lang.Language;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooser
extends JDialog {
    public static final int FOREGROUND = 0;
    public static final int BACKGROUND = 1;
    private int type = 0;
    private final JColorChooser chooser = new JColorChooser();
    private final MyPreview preview = new MyPreview();
    private final JButton doneButton = new JButton(Language.getString("settings.colorChooser.button.useSelected"));
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    private Color secondaryColor;
    private boolean returnNewColor;

    public ColorChooser(JDialog parent) {
        super(parent);
        this.setModal(true);
        this.setTitle("Choose color");
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.configureChooser();
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorChooser.this.updatePreview();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.chooser, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.doneButton, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.2;
        this.add((Component)this.cancelButton, gbc);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ColorChooser.this.doneButton) {
                    ColorChooser.this.returnNewColor = true;
                }
                ColorChooser.this.setVisible(false);
            }
        };
        this.doneButton.addActionListener(buttonListener);
        this.cancelButton.addActionListener(buttonListener);
        this.pack();
    }

    private void configureChooser() {
        for (AbstractColorChooserPanel panel : this.chooser.getChooserPanels()) {
            if (!(panel instanceof NamedColorsPanel)) continue;
            return;
        }
        this.chooser.addChooserPanel(new NamedColorsPanel());
        this.chooser.setPreviewPanel(this.preview);
    }

    private void updatePreview() {
        Color newColor = this.chooser.getColor();
        if (this.type == 0) {
            this.preview.update(newColor, this.secondaryColor);
        } else {
            this.preview.update(this.secondaryColor, newColor);
        }
    }

    public String chooseColorString(int type, Color presetColor, Color secondaryColor, String name, String text) {
        return HtmlColors.getNamedColorString(this.chooseColor(type, presetColor, secondaryColor, name, text));
    }

    public Color chooseColor(int type, Color presetColor, Color secondaryColor, String name, String text) {
        this.configureChooser();
        this.returnNewColor = false;
        this.setTitle(Language.getString("settings.colorChooser.title", name));
        this.type = type;
        this.secondaryColor = secondaryColor;
        this.preview.setText(text);
        this.chooser.setColor(presetColor);
        this.updatePreview();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        if (this.returnNewColor) {
            return this.chooser.getColor();
        }
        return presetColor;
    }

    static class MyPreview
    extends JLabel {
        MyPreview() {
            super("Preview Text", 0);
            this.setPreferredSize(new Dimension(400, 50));
            this.setOpaque(true);
            this.setFont(new Font("Arial", 1, 14));
        }

        public void update(Color foreground, Color background) {
            if (foreground != null) {
                super.setForeground(new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue()));
            } else {
                super.setForeground(null);
            }
            if (background != null) {
                super.setBackground(new Color(background.getRed(), background.getGreen(), background.getBlue()));
            } else {
                super.setBackground(null);
            }
        }

        @Override
        public void setForeground(Color foregroundColor) {
        }

        @Override
        public void setBackground(Color backgroundColor) {
        }
    }
}

