/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSettingListener;
import chatty.gui.components.settings.StringSetting;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColorSetting
extends JPanel
implements StringSetting {
    public static final int FOREGROUND = 0;
    public static final int BACKGROUND = 1;
    private final int type;
    private String baseColorSetting;
    private final JTextField textField = new JTextField(6);
    private final JLabel preview = new JLabel();
    private String baseColor;
    private boolean useBaseColor = true;
    private Color currentColor;
    private Color secondaryColor;
    private String previewText;
    private final Set<ColorSettingListener> listeners = new HashSet<ColorSettingListener>();
    private ColorChooser colorChooser;
    private final JButton chooseColor = new JButton();

    public ColorSetting(final int type, String baseColorSetting, final String name, String text, final Supplier<ColorChooser> chooserCreator) {
        this.setLayout(new GridBagLayout());
        this.type = type;
        this.baseColorSetting = baseColorSetting;
        this.previewText = text;
        if (!text.isEmpty()) {
            this.preview.setText(" " + text);
            this.preview.setOpaque(true);
        }
        this.preview.setToolTipText(name);
        this.preview.setPreferredSize(new Dimension(120, 20));
        this.chooseColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorSetting.this.colorChooser == null) {
                    ColorSetting.this.colorChooser = (ColorChooser)chooserCreator.get();
                }
                String result = ColorSetting.this.colorChooser.chooseColorString(type, ColorSetting.this.currentColor, ColorSetting.this.secondaryColor, name, ColorSetting.this.previewText);
                ColorSetting.this.setSettingValue(result);
            }
        });
        this.chooseColor.setMargin(new Insets(0, 0, 0, 0));
        this.chooseColor.setIcon(new ImageIcon(ColorSetting.class.getResource("colorpicker.png")));
        this.textField.setEditable(false);
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.textField.setHorizontalAlignment(4);
        this.initiate();
    }

    public boolean hasBase(String setting) {
        return setting.equals(this.baseColorSetting);
    }

    private void initiate() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.add((Component)this.preview, gbc);
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.add((Component)this.textField, gbc);
        gbc.weightx = 0.0;
        this.add((Component)this.chooseColor, gbc);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void updated() {
        Color backgroundColor;
        Color foregroundColor;
        this.currentColor = HtmlColors.decode(this.getSettingValue());
        this.secondaryColor = this.useBaseColor ? HtmlColors.decode(this.baseColor) : null;
        if (this.type == 0) {
            foregroundColor = this.currentColor;
            backgroundColor = this.secondaryColor;
        } else {
            foregroundColor = this.secondaryColor;
            backgroundColor = this.currentColor;
        }
        this.preview.setForeground(foregroundColor);
        this.preview.setBackground(backgroundColor);
        this.textField.setForeground(foregroundColor);
        this.textField.setBackground(backgroundColor);
    }

    public void setBaseColor(String baseColor) {
        this.baseColor = baseColor;
        this.updated();
    }

    public void setBaseColor(Color color) {
        this.setBaseColor(HtmlColors.getColorString(color));
    }

    public void setBaseColorSetting(String setting) {
        this.baseColorSetting = setting;
    }

    public void setUseBaseColor(boolean use) {
        this.useBaseColor = use;
        this.updated();
    }

    public void setPreviewText(String previewText) {
        if (previewText == null) {
            previewText = "";
        }
        this.preview.setText(" " + previewText);
        this.previewText = previewText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.preview.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.chooseColor.setEnabled(enabled);
    }

    @Override
    public String getSettingValue() {
        return this.textField.getText();
    }

    @Override
    public void setSettingValue(String value) {
        if (Objects.equals(this.textField.getText(), value)) {
            return;
        }
        this.textField.setText(value);
        this.updated();
        for (ColorSettingListener listener : this.listeners) {
            listener.colorUpdated();
        }
    }

    public Color getSettingValueAsColor() {
        return this.currentColor;
    }

    public void addListener(ColorSettingListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ColorSettingListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.textField.addMouseListener(listener);
        this.preview.addMouseListener(listener);
    }
}

