/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.BooleanSetting;
import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.ColorSettingListener;
import chatty.gui.components.settings.ColorTemplates;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorSettings
extends SettingsPanel {
    public static final String[] PRESET_SETTINGS = new String[]{"backgroundColor", "foregroundColor", "infoColor", "compactColor", "highlightColor", "inputBackgroundColor", "inputForegroundColor", "searchResultColor", "searchResultColor2", "backgroundColor2", "highlightBackgroundColor", "separatorColor", "timestampColor", "timestampColorInherit"};
    public static final String[] PRESET_SETTINGS_BOOLEAN = new String[]{"alternateBackground", "messageSeparator", "highlightBackground", "timestampColorEnabled"};
    public static final String[] DARK = new String[]{"#111111", "LightGrey", "DeepSkyBlue", "#A0A0A0", "#DDDDDD", "#222222", "White", "DarkSlateBlue", "SlateBlue", "#2D2D2D", "#7A0000", "#383838", "LightGrey", "off"};
    public static final Boolean[] DARK_BOOLEAN = new Boolean[]{false, false, true, false};
    public static final String[] DARK_SMOOTH = new String[]{"#323232", "LightGrey", "Aquamarine", "#A0A0A0", "#FFFFFF", "#222222", "#FFFFFF", "DarkSlateBlue", "SlateBlue", "#3B3B3B", "#5C0000", "#DFDFDF", "#C5C5C5", "40"};
    public static final Boolean[] DARK_SMOOTH_BOOLEAN = new Boolean[]{true, false, true, true};
    public static final String[] LIGHT_FAST = new String[]{"#FAFAFA", "#111111", "#001480", "#A0A0A0", "#D10000", "White", "Black", "LightYellow", "#FFFF80", "#EAEAEA", "#FFFFEA", "#DFDFDF", "#6E6779", "30"};
    public static final Boolean[] LIGHT_FAST_BOOLEAN = new Boolean[]{false, false, true, true};
    private final SettingsDialog d;
    private final Map<String, ColorSetting> colorSettings = new HashMap<String, ColorSetting>();
    private ColorChooser colorChooser;
    private final JPanel mainPanel;
    private final JPanel colorsPanel;
    private final ColorTemplates presets;

    public ColorSettings(SettingsDialog d, Settings settings) {
        this.d = d;
        this.mainPanel = this.addTitledPanel(Language.getString("settings.section.colors"), 0);
        this.colorsPanel = new JPanel(new GridBagLayout());
        ColorSetting backgroundColor = this.addColorSetting("backgroundColor", 1, "foregroundColor", Language.getString("settings.colors.background"), 0, 0);
        ColorSetting backgroundColor2 = this.addColorSetting("backgroundColor2", 1, "foregroundColor", Language.getString("settings.colors.background2"), 1, 0);
        ColorSetting separatorColor = this.addColorSetting("separatorColor", 0, "backgroundColor", Language.getString("settings.colors.messageSeparator"), 3, 0);
        ColorSetting highlightBackgroundColor = this.addColorSetting("highlightBackgroundColor", 1, "highlightColor", Language.getString("settings.colors.highlightBackground"), 11, 0);
        highlightBackgroundColor.setEnabled(false);
        ColorSetting highlightColor = this.addColorSetting("highlightColor", 0, "backgroundColor", Language.getString("settings.colors.highlight"), 11, 1);
        ColorSetting timestampColor = this.addColorSetting("timestampColor", 0, "backgroundColor", Language.getString("settings.colors.timestamp"), 8, 0);
        this.switchOnHover(highlightBackgroundColor, "backgroundColor", "highlightBackgroundColor", "highlightBackground", timestampColor);
        LinkedHashMap<String, String> timestampInheritOptions = new LinkedHashMap<String, String>();
        timestampInheritOptions.put("off", "Off");
        for (int i = 10; i <= 100; i += 10) {
            timestampInheritOptions.put(String.valueOf(i), i + "%");
        }
        ComboStringSetting timestampInheritSelection = new ComboStringSetting((Map<String, String>)timestampInheritOptions);
        d.addStringSetting("timestampColorInherit", timestampInheritSelection);
        SimpleBooleanSetting alternateBackground = d.addSimpleBooleanSetting("alternateBackground");
        SimpleBooleanSetting messageSeparator = d.addSimpleBooleanSetting("messageSeparator");
        SimpleBooleanSetting highlightBackground = d.addSimpleBooleanSetting("highlightBackground");
        SimpleBooleanSetting timestampColorEnabled = d.addSimpleBooleanSetting("timestampColorEnabled");
        this.presets = new ColorTemplates(settings, "colorPresets", new StringSetting[]{backgroundColor, this.addColorSetting("foregroundColor", 0, "backgroundColor", Language.getString("settings.colors.foreground"), 0, 1), this.addColorSetting("infoColor", 0, "backgroundColor", Language.getString("settings.colors.info"), 6, 0), this.addColorSetting("compactColor", 0, "backgroundColor", Language.getString("settings.colors.compact"), 6, 1), highlightColor, this.addColorSetting("inputBackgroundColor", 1, "inputForegroundColor", Language.getString("settings.colors.inputBackground"), 7, 0), this.addColorSetting("inputForegroundColor", 0, "inputBackgroundColor", Language.getString("settings.colors.inputForeground"), 7, 1), this.addColorSetting("searchResultColor", 1, "foregroundColor", Language.getString("settings.colors.searchResult"), 14, 0), this.addColorSetting("searchResultColor2", 1, "foregroundColor", Language.getString("settings.colors.searchResult2"), 14, 1), backgroundColor2, highlightBackgroundColor, separatorColor, timestampColor, timestampInheritSelection}, new BooleanSetting[]{alternateBackground, messageSeparator, highlightBackground, timestampColorEnabled});
        String[] defaultValues = new String[PRESET_SETTINGS.length];
        for (int i = 0; i < PRESET_SETTINGS.length; ++i) {
            defaultValues[i] = settings.getStringDefault(PRESET_SETTINGS[i]);
        }
        Boolean[] defaultValuesBoolean = new Boolean[PRESET_SETTINGS_BOOLEAN.length];
        for (int i = 0; i < PRESET_SETTINGS_BOOLEAN.length; ++i) {
            defaultValuesBoolean[i] = settings.getBooleanDefault(PRESET_SETTINGS_BOOLEAN[i]);
        }
        this.presets.addPreset(Language.getString("settings.colorPresets.option.default"), defaultValues, defaultValuesBoolean);
        this.presets.addPreset(Language.getString("settings.colorPresets.option.dark"), DARK, DARK_BOOLEAN);
        this.presets.addPreset(Language.getString("settings.colorPresets.option.dark2"), new String[]{"Black", "White", "#FF9900", "#FFCC00", "#66FF66", "#FFFFFF", "#000000", "#333333", "#555555", "#1E1E1E", "#660000", "#7A4B00", "White", "off"}, new Boolean[]{false, false, false, false});
        this.presets.addPreset("Twitch", new String[]{"#EFEEF1", "#111111", "#001480", "#A0A0A0", "#111111", "White", "#111111", "LightYellow", "#FFFF80", "#DBDBDB", "#F0A5B0", "#C6C6C6", "#6e6779", "100"}, new Boolean[]{false, false, true, true});
        this.presets.addPreset("Twitch Dark", new String[]{"#17141A", "#CFC8CD", "White", "#A0A0A0", "#D6D0D4", "#17141A", "#CFC8CD", "#333333", "#555555", "#241F29", "#590E1A", "#7A4B00", "#898395", "70"}, new Boolean[]{true, false, true, true});
        this.presets.addPreset("Theater", new String[]{"#0E0C13", "#DAD8DE", "#A0A0A0", "#6A7559", "#D88A35", "#0E0C13", "#DAD8DE", "#31362F", "#444B42", "#191522", "#660000", "#2D2D2D", "#898395", "100"}, new Boolean[]{false, false, false, true});
        this.presets.addPreset("Dark Smooth", DARK_SMOOTH, DARK_SMOOTH_BOOLEAN);
        this.presets.init();
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(-1, 10, 0, 0);
        SettingsUtil.addSubsettings(alternateBackground, backgroundColor2);
        this.colorsPanel.add((Component)alternateBackground, gbc);
        gbc = SettingsDialog.makeGbc(0, 4, 2, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(-1, 10, 0, 0);
        SettingsUtil.addSubsettings(messageSeparator, separatorColor);
        this.colorsPanel.add((Component)messageSeparator, gbc);
        gbc = SettingsDialog.makeGbc(0, 12, 2, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(-1, 10, 0, 0);
        highlightBackground.addItemListener(e -> {
            if (highlightBackground.isSelected()) {
                highlightColor.setBaseColorSetting("highlightBackgroundColor");
                this.updated("highlightBackgroundColor");
            } else {
                highlightColor.setBaseColorSetting("backgroundColor");
                this.updated("backgroundColor");
            }
            highlightBackgroundColor.setEnabled(highlightBackground.isSelected());
        });
        this.colorsPanel.add((Component)highlightBackground, gbc);
        gbc = SettingsDialog.makeGbc(0, 9, 2, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(-1, 10, 0, 0);
        SettingsUtil.addSubsettings(timestampColorEnabled, timestampColor, timestampInheritSelection);
        this.colorsPanel.add((Component)timestampColorEnabled, gbc);
        gbc = SettingsDialog.makeGbc(1, 9, 2, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(-1, 10, 0, 0);
        this.colorsPanel.add((Component)SettingsUtil.createPanel("timestampColorInherit", timestampInheritSelection), gbc);
        gbc = SettingsDialog.makeGbc(1, 1, 1, 1, 17);
        JButton switchButton = new JButton(Language.getString("settings.colors.button.switchBackgrounds"));
        GuiUtil.smallButtonInsets(switchButton);
        switchButton.addActionListener(e -> {
            String bg = backgroundColor.getSettingValue();
            backgroundColor.setSettingValue(backgroundColor2.getSettingValue());
            backgroundColor2.setSettingValue(bg);
        });
        this.colorsPanel.add((Component)switchButton, gbc);
        gbc = SettingsDialog.makeGbc(0, 5, 2, 1);
        gbc.insets = new Insets(10, 0, 2, 0);
        this.colorsPanel.add((Component)new JLabel(Language.getString("settings.colors.heading.misc")), gbc);
        gbc = SettingsDialog.makeGbc(0, 10, 2, 1);
        gbc.insets = new Insets(10, 0, 2, 0);
        this.colorsPanel.add((Component)new JLabel(Language.getString("settings.colors.heading.highlights")), gbc);
        gbc = SettingsDialog.makeGbc(0, 13, 2, 1);
        gbc.insets = new Insets(10, 0, 2, 0);
        this.colorsPanel.add((Component)new JLabel(Language.getString("settings.colors.heading.searchResult")), gbc);
        gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        this.mainPanel.add((Component)this.presets, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        this.mainPanel.add((Component)this.colorsPanel, gbc);
        gbc = SettingsDialog.makeGbc(0, 20, 1, 1);
        gbc.anchor = 10;
        gbc.insets = new Insets(15, 5, 5, 5);
        this.mainPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.colors.lookandfeel")), gbc);
    }

    private ColorSetting addColorSetting(String setting, int type, String baseSetting, String colorDescription, int row, int column) {
        String colorType = type == 0 ? Language.getString("settings.colors.general.foregroundColor") : Language.getString("settings.colors.general.backgroundColor");
        String extendedName = colorDescription + " [" + colorType + "]";
        ColorSetting colorSetting = new ColorSetting(type, baseSetting, extendedName, colorDescription, () -> {
            if (this.colorChooser == null) {
                this.colorChooser = new ColorChooser(this.d);
            }
            return this.colorChooser;
        });
        colorSetting.addListener(new MyColorSettingListener(setting));
        this.d.addStringSetting(setting, colorSetting);
        this.colorSettings.put(setting, colorSetting);
        GridBagConstraints gbc = SettingsDialog.makeGbc(column, row, 1, 1, 17);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(3, 4, 2, 4);
        this.colorsPanel.add((Component)colorSetting, gbc);
        return colorSetting;
    }

    private void updated(String setting) {
        String newColor = this.colorSettings.get(setting).getSettingValue();
        for (ColorSetting colorSetting : this.colorSettings.values()) {
            if (!colorSetting.hasBase(setting)) continue;
            colorSetting.setBaseColor(newColor);
        }
        this.d.updateBackgroundColor();
    }

    private void switchOnHover(ColorSetting hoverSetting, final String normalSetting, final String tempSetting, final String onlyIf, final ColorSetting ... settings) {
        hoverSetting.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (onlyIf != null && !ColorSettings.this.d.getBooleanSetting(onlyIf).booleanValue()) {
                    return;
                }
                for (ColorSetting setting : settings) {
                    setting.setBaseColorSetting(tempSetting);
                }
                ColorSettings.this.updated(tempSetting);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (ColorSetting setting : settings) {
                    setting.setBaseColorSetting(normalSetting);
                }
                ColorSettings.this.updated(normalSetting);
            }
        });
    }

    class MyColorSettingListener
    implements ColorSettingListener {
        private final String setting;

        MyColorSettingListener(String setting) {
            this.setting = setting;
        }

        @Override
        public void colorUpdated() {
            ColorSettings.this.updated(this.setting);
        }
    }
}

