/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.BooleanSetting;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.GenericComboSetting;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ColorTemplates
extends JPanel {
    private final List<StringSetting> colorSettings = new ArrayList<StringSetting>();
    private final List<BooleanSetting> booleanSettings = new ArrayList<BooleanSetting>();
    private final List<Preset> hardcodedPresets = new ArrayList<Preset>();
    private final List<Preset> userPresets = new ArrayList<Preset>();
    private final JButton saveButton = new JButton(Language.getString("settings.colorPresets.button.save"));
    private final JButton saveAsButton = new JButton(Language.getString("settings.colorPresets.button.saveAs"));
    private final JButton removeButton = new JButton(Language.getString("settings.colorPresets.button.delete"));
    private final GenericComboSetting<Preset> selection = new GenericComboSetting();
    private final Settings settings;
    private final String settingName;

    public ColorTemplates(Settings settings, String settingName, ColorSetting[] values) {
        this(settings, settingName, values, new BooleanSetting[0]);
    }

    public ColorTemplates(Settings settings, String settingName, StringSetting[] values, BooleanSetting[] booleanValues) {
        this.colorSettings.addAll(Arrays.asList(values));
        this.booleanSettings.addAll(Arrays.asList(booleanValues));
        for (StringSetting c : this.colorSettings) {
            if (!(c instanceof ColorSetting)) continue;
            ((ColorSetting)c).addListener(() -> this.update());
        }
        this.settings = settings;
        this.settingName = settingName;
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 3, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add(this.selection, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 1, 1);
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 0.3;
        this.add((Component)this.saveButton, gbc);
        gbc = GuiUtil.makeGbc(1, 1, 1, 1);
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 0.3;
        this.add((Component)this.saveAsButton, gbc);
        gbc = GuiUtil.makeGbc(2, 1, 1, 1);
        gbc.insets = insets;
        this.add((Component)this.removeButton, gbc);
        gbc = GuiUtil.makeGbc(0, 2, 3, 1);
        JLabel saveNote = new JLabel(Language.getString("settings.colorPresets.info"));
        this.selection.addItemListener(e -> {
            boolean hardcoded = this.hardcodedPresets.contains(this.selection.getSettingValue());
            if (this.selection.getSettingValue() == null) {
                hardcoded = true;
            }
            this.saveButton.setEnabled(!hardcoded);
            this.removeButton.setEnabled(!hardcoded);
        });
        this.selection.addActionListener(e -> this.loadSelectedPreset());
        this.saveButton.addActionListener(e -> this.overwriteCurrent());
        this.saveAsButton.addActionListener(e -> this.addCurrentAsPreset());
        this.removeButton.addActionListener(e -> this.removeSelectedPreset());
        this.loadFromSettings();
        this.init();
    }

    public void selectDefault() {
        this.selection.setSelectedIndex(0);
    }

    public void init() {
        this.selection.clear();
        this.selection.add((Preset)null, "-- " + Language.getString("settings.colorPresets.colorPresets") + " --");
        for (Preset p : this.userPresets) {
            this.selection.add(p, p.name);
        }
        for (Preset p : this.hardcodedPresets) {
            this.selection.add(p, p.name + "*");
        }
    }

    private void update() {
        Preset p = this.selection.getSettingValue();
        if (p != null && !this.hardcodedPresets.contains(p)) {
            this.saveButton.setEnabled(!this.currentEqualTo(p));
        }
    }

    private boolean currentEqualTo(Preset p) {
        Object s;
        int i;
        for (i = 0; i < this.colorSettings.size(); ++i) {
            s = this.colorSettings.get(i);
            if (p.colors.size() <= i) {
                return false;
            }
            if (((String)p.colors.get(i)).equalsIgnoreCase(s.getSettingValue())) continue;
            return false;
        }
        for (i = 0; i < this.booleanSettings.size(); ++i) {
            s = this.booleanSettings.get(i);
            if (p.booleans.size() <= i) {
                return false;
            }
            if (((Boolean)p.booleans.get(i)).booleanValue() == s.getSettingValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void loadSelectedPreset() {
        Preset p = this.selection.getSettingValue();
        if (p != null) {
            int i;
            for (i = 0; i < this.colorSettings.size(); ++i) {
                if (p.colors.size() <= i) continue;
                this.colorSettings.get(i).setSettingValue((String)p.colors.get(i));
            }
            for (i = 0; i < this.booleanSettings.size(); ++i) {
                if (p.booleans.size() <= i) continue;
                this.booleanSettings.get(i).setSettingValue((Boolean)p.booleans.get(i));
            }
        }
    }

    private void addCurrentAsPreset() {
        String name = JOptionPane.showInputDialog(this, (Object)"Enter name to save current colors:");
        if (name != null) {
            Preset p = new Preset(name, this.getCurrentColors(), this.getCurrentBooleans());
            this.userPresets.add(p);
            int insertPos = this.userPresets.size();
            this.selection.insert(p, p.name, insertPos);
            this.selection.setSettingValue(p);
            this.saveToSettings();
        }
    }

    private void overwriteCurrent() {
        Preset current = this.selection.getSettingValue();
        Preset p = new Preset(current.name, this.getCurrentColors(), this.getCurrentBooleans());
        int pos = this.userPresets.indexOf(current);
        this.userPresets.set(pos, p);
        this.selection.replace(current, p);
        this.selection.setSettingValue(p);
        this.saveToSettings();
    }

    private List<String> getCurrentColors() {
        ArrayList<String> colors = new ArrayList<String>();
        for (StringSetting s : this.colorSettings) {
            colors.add(s.getSettingValue());
        }
        return colors;
    }

    private List<Boolean> getCurrentBooleans() {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (BooleanSetting s : this.booleanSettings) {
            booleans.add(s.getSettingValue());
        }
        return booleans;
    }

    private void removeSelectedPreset() {
        Preset p = this.selection.getSettingValue();
        this.userPresets.remove(p);
        this.selection.remove(p);
        this.saveToSettings();
    }

    public void addPreset(String name, String[] values) {
        this.addPreset(name, values, new Boolean[0]);
    }

    public void addPreset(String name, String[] values, Boolean[] booleanValues) {
        if (values.length < this.colorSettings.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (booleanValues.length < this.booleanSettings.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Preset p = new Preset(name, Arrays.asList(values), Arrays.asList(booleanValues));
        this.hardcodedPresets.add(p);
    }

    private void saveToSettings() {
        ArrayList<List> result = new ArrayList<List>();
        for (Preset p : this.userPresets) {
            result.add(p.toList());
        }
        this.settings.putList(this.settingName, result);
    }

    private void loadFromSettings() {
        this.userPresets.clear();
        List source = this.settings.getList(this.settingName);
        for (Object o : source) {
            List list;
            Preset p;
            if (!(o instanceof List) || (p = Preset.fromList(list = (List)o)) == null) continue;
            this.userPresets.add(p);
        }
    }

    private static class Preset {
        private final String name;
        private final List<String> colors;
        private final List<Boolean> booleans;

        public Preset(String name, List<String> colors, List<Boolean> booleans) {
            this.name = name;
            this.colors = colors;
            this.booleans = booleans;
        }

        public List toList() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.name);
            result.addAll(this.colors);
            result.addAll(this.booleans);
            return result;
        }

        public String toString() {
            return this.name;
        }

        public static Preset fromList(List list) {
            if (list.size() > 1 && list.get(0) instanceof String) {
                String name = (String)list.get(0);
                ArrayList<String> colors = new ArrayList<String>();
                ArrayList<Boolean> booleans = new ArrayList<Boolean>();
                for (Object o : list.subList(1, list.size())) {
                    if (o instanceof String) {
                        colors.add((String)o);
                        continue;
                    }
                    if (!(o instanceof Boolean)) continue;
                    booleans.add((Boolean)o);
                }
                return new Preset(name, colors, booleans);
            }
            return null;
        }
    }
}

