/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.components.menus.CommandMenuItem;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.TestContextMenu;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.userinfo.UserInfoDialog;
import chatty.gui.components.userinfo.UserInfoListener;
import chatty.util.commands.CommandSyntaxHighlighter;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.CustomCommands;
import chatty.util.commands.Parameters;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CommandSettings
extends SettingsPanel {
    private static final String INFO_HEADER = "<html><style type='text/css'>p { margin: 2px; }dt { margin-top: 8px; }dd { margin-left: 10px; margin-top: 4px; }li { margin-top: 4px; }</style><body style='width:300px;font-weight:normal;'>";
    private static final String INFO_COMMANDS = "<html><style type='text/css'>p { margin: 2px; }dt { margin-top: 8px; }dd { margin-left: 10px; margin-top: 4px; }li { margin-top: 4px; }</style><body style='width:300px;font-weight:normal;'>" + SettingsUtil.getInfo("info-commands.html", null);
    private final SettingsDialog d;

    private static String getInfo(String type) {
        return INFO_HEADER + SettingsUtil.getInfo("info-menu.html", type);
    }

    public CommandSettings(final SettingsDialog d) {
        super(true);
        this.d = d;
        JPanel base = this.addTitledPanel("Custom Commands", 0, true);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        ListSelector items = d.addListSetting("commands", "Custom Command", 400, 150, true, true);
        items.setDataFormatter(new DataFormatter<String>(){

            @Override
            public String format(String input) {
                return input.trim();
            }
        });
        items.setTester(CommandSettings.createCommandTester());
        items.setInfo(INFO_COMMANDS);
        items.setInfoLinkLabelListener(d.getLinkLabelListener());
        items.setSyntaxHighlighter(new CommandSyntaxHighlighter());
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        base.add((Component)items, gbc);
        JPanel menus = this.addTitledPanel("Menu/Button Commands", 1);
        Editor.Tester menuTester = new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                TestContextMenu m = new TestContextMenu(value);
                m.show(component, x, y);
                return null;
            }
        };
        Editor.Tester userDialogTester = new Editor.Tester(){
            private final User user = new User("testUser", Room.createRegular("#testchannel"));

            @Override
            public String test(final Window parent, Component component, int x, int y, String value) {
                this.updateErrors(value);
                UserInfoDialog dialog = new UserInfoDialog(parent, new UserInfoListener(){

                    @Override
                    public void anonCustomCommand(Room room, CustomCommand command, Parameters parameters) {
                        CustomCommands.addChans(room, parameters);
                        String result = String.format("<html><body><p style='font-family:monospaced;'>%s</p>", CommandSettings.formatCommandInfo(command.replace(parameters)));
                        JOptionPane.showMessageDialog(parent, result, "Command result", 1);
                    }
                }, null, d.settings, null);
                dialog.setUserDefinedButtonsDef(value, true);
                GuiUtil.setLocationRelativeTo(dialog, parent);
                dialog.show(component, this.user, "s0m3-msg-1d", null, null);
                return null;
            }

            private void updateErrors(String value) {
                this.user.clearLines();
                List<CommandMenuItem> items = CommandMenuItems.parse(value);
                for (CommandMenuItem item : items) {
                    if (item.getCommand() == null || !item.getCommand().hasError()) continue;
                    this.user.addMessage(String.format("Error in command '%s': %s", item.getLabel(), item.getCommand().getSingleLineError()), false, null);
                }
                this.user.addMessage("Note that some replacements may not work in this test dialog.", false, "s0m3-msg-1d");
            }
        };
        this.addSetting("channelContextMenu", "channelMenu", 0, menus, menuTester);
        this.addSetting("streamsContextMenu", "streamsMenu", 1, menus, menuTester);
        this.addSetting("userContextMenu", "userMenu", 2, menus, menuTester);
        this.addSetting("timeoutButtons", "userDialog", 3, menus, userDialogTester);
        this.addSetting("textContextMenu", "textMenu", 4, menus, menuTester);
        this.addSetting("adminContextMenu", "adminMenu", 5, menus, menuTester);
        menus.add((Component)d.addSimpleBooleanSetting("menuCommandLabels"), SettingsDialog.makeGbc(0, 6, 2, 1, 17));
        menus.add((Component)d.addSimpleBooleanSetting("menuRestrictions"), SettingsDialog.makeGbc(0, 7, 2, 1, 17));
    }

    private void addSetting(String settingName, String infoName, int y, JPanel panel, Editor.Tester tester) {
        JLabel label = SettingsUtil.createLabel(settingName);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, y, 1, 1);
        gbc.anchor = 13;
        panel.add((Component)label, gbc);
        gbc = SettingsDialog.makeGbc(1, y, 1, 1);
        EditorStringSetting setting = this.d.addEditorStringSetting(settingName, 20, true, label.getText(), true, CommandSettings.getInfo(infoName), tester);
        label.setLabelFor(setting);
        setting.setLinkLabelListener(this.d.getLinkLabelListener());
        panel.add((Component)setting, gbc);
    }

    public static Editor.Tester createCommandTester() {
        return new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                CustomCommand command = CustomCommands.parseCommandWithName(value);
                CommandSettings.showCommandInfoPopup(component, command);
                return null;
            }
        };
    }

    public static void showCommandInfoPopup(Component parent, CustomCommand command) {
        String message = "<p style='font-family:sans-serif;'>This shows how the parser understands the part to be executed. It may not be very obvious what it means, but it can be helpful for debugging. If no error is shown here, it's at least formally correct.</p><br />";
        message = command == null ? message + "No command." : (command.hasError() ? message + "<p style='font-family:monospaced;'>Error: " + CommandSettings.formatCommandInfo(command.getError(), true) + "</p>" : message + CommandSettings.formatCommandInfo(command.toString(), false));
        String name = "";
        String chan = "";
        if (command != null) {
            name = command.hasName() ? " (" + command.getName() + ")" : "";
            chan = command.hasChan() ? " [#" + command.getChan() + "]" : "";
        }
        GuiUtil.showNonModalMessage(parent, "Custom Command" + name + chan, message, 1, true);
    }

    public static String formatCommandInfo(String input) {
        return CommandSettings.formatCommandInfo(input, false);
    }

    public static String formatCommandInfo(String input, boolean singleLine) {
        if (input == null) {
            return "<em>Empty</em>";
        }
        String result = Helper.htmlspecialchars_encode(input).replace("\n", "<br>");
        result = singleLine ? result.replace(" ", "&nbsp;") : result.replace("  ", "&nbsp;&nbsp;");
        return result;
    }
}

