/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SimpleTableEditor;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CompletionSettings
extends SettingsPanel {
    private final SettingsDialog d;

    public CompletionSettings(SettingsDialog d) {
        super(false);
        this.d = d;
        JPanel entries = this.addTitledPanel(Language.getString("settings.section.completion"), 0);
        entries.add((Component)d.addSimpleBooleanSetting("completionEnabled"), SettingsDialog.makeGbc(0, 0, 4, 1, 17));
        LinkedHashMap<String, String> tabChoices = new LinkedHashMap<String, String>();
        tabChoices.put("names", Language.getString("settings.completion.option.names"));
        tabChoices.put("emotes", Language.getString("settings.completion.option.emotes"));
        tabChoices.put("both", Language.getString("settings.completion.option.namesEmotes"));
        tabChoices.put("both2", Language.getString("settings.completion.option.emotesNames"));
        tabChoices.put("custom", Language.getString("settings.completion.option.custom"));
        entries.add((Component)new JLabel("TAB:"), SettingsDialog.makeGbc(0, 1, 1, 1, 13));
        entries.add((Component)d.addComboStringSetting("completionTab", 0, false, tabChoices), SettingsDialog.makeGbc(1, 1, 1, 1, 17));
        entries.add((Component)new JLabel("Shift-TAB:"), SettingsDialog.makeGbc(2, 1, 1, 1, 13));
        entries.add((Component)d.addComboStringSetting("completionTab2", 0, false, tabChoices), SettingsDialog.makeGbc(3, 1, 1, 1, 17));
        entries.add((Component)new JLabel("<html><body style='width:300px;padding-bottom:3px;'>" + Language.getString("settings.completion.info")), SettingsDialog.makeGbc(0, 2, 4, 1));
        LinkedHashMap<String, String> emotePrefixValues = new LinkedHashMap<String, String>();
        emotePrefixValues.put("", Language.getString("settings.completionEmotePrefix.option.none"));
        for (String item : ":,;-#~!'$\u00a7%&".split("")) {
            emotePrefixValues.put(item, item);
        }
        ComboStringSetting prefix = d.addComboStringSetting("completionEmotePrefix", 10, false, emotePrefixValues);
        ComboLongSetting mixed = d.addComboLongSetting("completionMixed", 0, 1, 2);
        Consumer<String> preferEmojiTest = s -> mixed.setEnabled(prefix.getSettingValue().equals(s));
        preferEmojiTest.accept(":");
        prefix.addActionListener(e -> preferEmojiTest.accept(":"));
        entries.add((Component)SettingsUtil.createPanel("completionEmotePrefix", prefix, mixed), SettingsDialog.makeGbc(0, 3, 4, 1, 17));
        CustomCompletionEntries customCompletionDialog = new CustomCompletionEntries(d);
        JButton editCustomCompletion = new JButton("Edit Custom Completion Items");
        GuiUtil.smallButtonInsets(editCustomCompletion);
        editCustomCompletion.addActionListener(e -> customCompletionDialog.show(d));
        entries.add((Component)editCustomCompletion, SettingsDialog.makeGbc(0, 6, 4, 1, 17));
        JPanel localized = this.addTitledPanel(Language.getString("settings.section.completionNames"), 2);
        localized.add((Component)d.addSimpleBooleanSetting("completionPreferUsernames"), SettingsDialog.makeGbc(0, 2, 4, 1, 17));
        SimpleBooleanSetting completionAllNameTypes = d.addSimpleBooleanSetting("completionAllNameTypes");
        localized.add((Component)completionAllNameTypes, SettingsDialog.makeGbcCloser(0, 3, 4, 1, 17));
        SimpleBooleanSetting completionAllNameTypesRestriction = d.addSimpleBooleanSetting("completionAllNameTypesRestriction");
        localized.add((Component)completionAllNameTypesRestriction, SettingsDialog.makeGbcSub(0, 4, 4, 1, 17));
        SettingsUtil.addSubsettings(completionAllNameTypes, completionAllNameTypesRestriction);
        JPanel appearance = this.addTitledPanel(Language.getString("settings.section.completionAppearance"), 1);
        SimpleBooleanSetting popup = d.addSimpleBooleanSetting("completionShowPopup");
        JPanel numResults = SettingsUtil.createStandardGapPanel();
        JTextField max = d.addSimpleLongSetting("completionMaxItemsShown", 3, true);
        numResults.add(popup);
        numResults.add(max);
        numResults.add(SettingsUtil.createLabel("searchResults"));
        appearance.add((Component)numResults, SettingsDialog.makeNoGapGbc(0, 0, 2, 1, 21));
        JPanel popupSettings = new JPanel(new GridBagLayout());
        SimpleBooleanSetting auto = d.addSimpleBooleanSetting("completionAuto");
        popupSettings.add((Component)auto, SettingsDialog.makeGbcCloser(0, 1, 1, 1, 21));
        SimpleBooleanSetting common = d.addSimpleBooleanSetting("completionCommonPrefix");
        popupSettings.add((Component)common, SettingsDialog.makeGbcCloser(0, 2, 1, 1, 17));
        SettingsUtil.addSubsettings(popup, max, common, auto);
        appearance.add((Component)popupSettings, SettingsDialog.makeGbcSub(0, 1, 2, 1, 17));
        appearance.add((Component)new JLabel(Language.getString("settings.completion.nameSorting")), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
        HashMap<String, String> choices = new HashMap<String, String>();
        choices.put("predictive", Language.getString("settings.completion.option.predictive"));
        choices.put("alphabetical", Language.getString("settings.completion.option.alphabetical"));
        choices.put("userlist", Language.getString("settings.completion.option.userlist"));
        appearance.add((Component)d.addComboStringSetting("completionSorting", 4, false, choices), SettingsDialog.makeGbc(1, 2, 1, 1, 17));
        appearance.add((Component)new JLabel(Language.getString("settings.string.completionSearch")), SettingsDialog.makeGbc(0, 3, 1, 1));
        appearance.add((Component)d.addComboStringSetting("completionSearch", false, "start", "words", "anywhere"), SettingsDialog.makeGbc(1, 3, 1, 1, 17));
        appearance.add((Component)d.addSimpleBooleanSetting("completionSpace"), SettingsDialog.makeGbcCloser(0, 4, 4, 1, 17));
        appearance.add((Component)d.addSimpleBooleanSetting("completionFavEmotesFirst"), SettingsDialog.makeGbc(0, 5, 2, 1, 17));
    }

    private class CustomCompletionEntries
    extends LazyDialog {
        private final JDialog owner;
        private final SimpleTableEditor<String> editor;

        public CustomCompletionEntries(JDialog owner) {
            this.owner = owner;
            this.editor = CompletionSettings.this.d.addStringMapSetting("customCompletion", 270, 180, "Key", "Value");
            this.editor.setKeyFilter("[^\\w]");
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(CustomCompletionEntries.this.owner);
                this.setTitle("Custom Completion Items");
                this.setDefaultCloseOperation(1);
                this.add((Component)new JLabel("<html><body style='width:300px;padding:7px 7px 10px 7px;'>Use <kbd>TAB</kbd> to complete '.Key' (prefixed with a dot) to 'Value'.<br /><br />Example: Add <code>chatty</code> as Key and <code>http://chatty.github.io</code> as Value, then <code>.chatty</code> completes to <code>http://chatty.github.io</code>. <br /><br />You have to enter the key exactly, so for example just <code>chat</code> won't find <code>chatty</code>.<br /><br />If you have selected 'Custom Completion' for the <kbd>TAB</kbd> or <kbd>Shift-Tab</kbd> setting then you can also use that to perform the completion without the dot in front."), "North");
                this.add((Component)CustomCompletionEntries.this.editor, "Center");
                JButton close = new JButton("Close");
                close.addActionListener(e -> this.setVisible(false));
                this.add((Component)close, "South");
                this.pack();
            }
        }
    }
}

