/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.BooleanSetting;
import chatty.gui.components.settings.LongSetting;

public class CompoundBooleanSetting
implements LongSetting {
    private final BooleanSetting[] settings;

    public CompoundBooleanSetting(BooleanSetting ... settings) {
        this.settings = settings;
    }

    @Override
    public Long getSettingValue() {
        long result = 0L;
        for (int i = 0; i < this.settings.length; ++i) {
            if (!this.settings[i].getSettingValue().booleanValue()) continue;
            result += (long)(1 << i);
        }
        return result;
    }

    @Override
    public Long getSettingValue(Long def) {
        return this.getSettingValue();
    }

    @Override
    public void setSettingValue(Long settingValue) {
        int value = settingValue.intValue();
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i].setSettingValue((value & 1 << i) != 0);
        }
    }
}

