/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SimpleLongSetting;
import chatty.lang.Language;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeletedMessagesModeSetting
extends JPanel {
    private static final String OPTION_DELETE = Language.getString("settings.option.deletedMessagesMode.delete");
    private static final String OPTION_STRIKE_THROUGH = Language.getString("settings.option.deletedMessagesMode.strikeThrough");
    private static final String OPTION_STRIKE_THROUGH_SHORTEN = Language.getString("settings.option.deletedMessagesMode.strikeThroughShorten");
    private final ComboStringSetting combo;
    private final SimpleLongSetting maxLength = new SimpleLongSetting(3, true);
    private final JLabel maxLengthLabel = new JLabel(" (" + Language.getString("settings.deletedMessages.max") + " ");
    private final JLabel maxLengthLabel2 = new JLabel(Language.getString("settings.deletedMessages.characters") + ")");

    public DeletedMessagesModeSetting(SettingsDialog d) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("delete", OPTION_DELETE);
        options.put("keep", OPTION_STRIKE_THROUGH);
        options.put("keepShortened", OPTION_STRIKE_THROUGH_SHORTEN);
        this.combo = new ComboStringSetting((Map<String, String>)options);
        this.combo.setEditable(false);
        d.addStringSetting("deletedMessagesMode", this.combo);
        d.addLongSetting("deletedMessagesMaxLength", this.maxLength);
        this.combo.addItemListener(new MyItemListener());
        this.add(this.combo);
        this.add(this.maxLengthLabel);
        this.add(this.maxLength);
        this.add(this.maxLengthLabel2);
        this.update();
    }

    private void update() {
        String selected = this.combo.getSettingValue();
        boolean shorten = selected.equals("keepShortened");
        this.maxLength.setEnabled(shorten);
        this.maxLengthLabel.setEnabled(shorten);
        this.maxLengthLabel2.setEnabled(shorten);
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DeletedMessagesModeSetting.this.update();
        }
    }
}

