/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DialogComboSetting
extends JPanel
implements StringSetting {
    private final JTextField display = new JTextField(20);
    private String value;
    private final Supplier<Map<String, String>> optionsCreator;
    private final Function<String, String> valueFormatter;
    private Set<Consumer<DialogComboSetting>> changeListeners;

    public DialogComboSetting(Window parent, Supplier<Map<String, String>> optionsCreator, Function<String, String> valueFormatter) {
        this.display.setEditable(false);
        this.optionsCreator = optionsCreator;
        this.valueFormatter = valueFormatter;
        JButton changeButton = new JButton(Language.getString("dialog.button.change"));
        GuiUtil.smallButtonInsets(changeButton);
        changeButton.addActionListener(e -> this.change(parent));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.display, gbc);
        gbc = GuiUtil.makeGbc(1, 0, 1, 1);
        this.add((Component)changeButton, gbc);
    }

    private void change(Window parent) {
        JDialog dialog = new JDialog(parent);
        dialog.setTitle("Change value");
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setLayout(new GridBagLayout());
        dialog.setResizable(false);
        ComboStringSetting list = new ComboStringSetting(this.optionsCreator.get());
        list.setSettingValue(this.value);
        JButton save = new JButton(Language.getString("dialog.button.save"));
        save.addActionListener(e -> {
            this.setSettingValue(list.getSettingValue());
            dialog.setVisible(false);
        });
        JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
        cancel.addActionListener(e -> dialog.setVisible(false));
        dialog.add((Component)list, GuiUtil.makeGbc(0, 0, 2, 1));
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        dialog.add((Component)save, gbc);
        dialog.add((Component)cancel, GuiUtil.makeGbc(1, 1, 1, 1));
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    @Override
    public String getSettingValue() {
        return this.value;
    }

    @Override
    public void setSettingValue(String value) {
        this.value = value;
        this.display.setText(this.valueFormatter.apply(value));
        this.informChangeListeners();
    }

    public void addSettingChangeListener(Consumer<DialogComboSetting> listener) {
        if (listener != null) {
            if (this.changeListeners == null) {
                this.changeListeners = new HashSet<Consumer<DialogComboSetting>>();
            }
            this.changeListeners.add(listener);
        }
    }

    private void informChangeListeners() {
        if (this.changeListeners != null) {
            this.changeListeners.forEach(listener -> listener.accept(this));
        }
    }
}

