/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.RegexDocumentFilter;
import chatty.gui.components.settings.LongSetting;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;

public class DurationSetting
extends JTextField
implements LongSetting {
    public DurationSetting(int size, boolean editable) {
        super(size);
        this.setEditable(editable);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new RegexDocumentFilter("[^\\dms]+", this));
    }

    @Override
    public Long getSettingValue() {
        return this.getSettingValue(null);
    }

    @Override
    public Long getSettingValue(Long def) {
        String value = this.getText();
        Long number = null;
        try {
            number = Long.parseLong(value.replaceAll("[^0-9]*", ""));
        }
        catch (NumberFormatException ex) {
            return def;
        }
        if (value.endsWith("m")) {
            number = number * 60L;
        }
        return number;
    }

    @Override
    public void setSettingValue(Long setting) {
        if (setting % 60L != 0L || setting == 0L) {
            this.setText(setting + "s");
        } else {
            this.setText(setting / 60L + "m");
        }
    }
}

