/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.StringEditor;
import chatty.lang.Language;
import chatty.util.LineNumbers;
import chatty.util.SyntaxHighlighter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Editor
implements StringEditor {
    private static final int INPUT_LENGTH_LIMIT = 200000;
    private final JDialog dialog;
    private final JLabel label;
    private final JTextArea input;
    private final JScrollPane scrollpane;
    private final JButton okButton = new JButton(Language.getString("dialog.button.save"));
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton testButton = new JButton(Language.getString("dialog.button.test"));
    private final JToggleButton toggleInfoButton = new JToggleButton(Language.getString("dialog.button.help"));
    private final JCheckBox toggleHighlighting = new JCheckBox("Syntax Highlighting");
    private final Window parent;
    private final LinkLabel info;
    private DataFormatter<String> formatter;
    private Tester tester;
    private SyntaxHighlighter highlighter;
    private Runnable highlighterUpdate;
    private boolean allowEmpty;
    private boolean showInfoByDefault;
    private String result;

    public Editor(Window parent) {
        this.dialog = new JDialog(parent);
        this.parent = parent;
        this.dialog.setTitle("Input");
        this.dialog.setModal(true);
        GuiUtil.installEscapeCloseOperation(this.dialog);
        this.dialog.setLayout(new GridBagLayout());
        this.label = new JLabel("abc");
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 2, 1, 17);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.dialog.add((Component)this.label, gbc);
        gbc = GuiUtil.makeGbc(3, 0, 1, 1, 13);
        GuiUtil.smallButtonInsets(this.testButton);
        this.dialog.add((Component)this.testButton, gbc);
        this.testButton.setVisible(false);
        gbc = GuiUtil.makeGbc(0, 1, 4, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 7, 5, 7);
        this.input = new JTextArea();
        this.input.getDocument().addDocumentListener(new ChangeListener());
        this.input.setMargin(new Insets(2, 2, 2, 2));
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        this.input.setText("test");
        this.input.setFont(Font.decode("Monospaced"));
        GuiUtil.installLengthLimitDocumentFilter(this.input, 200000, false, new Object[0]);
        GuiUtil.resetFocusTraversalKeys(this.input);
        this.scrollpane = new JScrollPane(this.input);
        this.dialog.add((Component)this.scrollpane, gbc);
        gbc = GuiUtil.makeGbc(0, 4, 4, 1);
        gbc.insets = new Insets(5, 8, 8, 8);
        gbc.anchor = 10;
        this.info = new LinkLabel("", null);
        this.dialog.add((Component)this.info, gbc);
        this.info.setVisible(false);
        gbc = GuiUtil.makeGbc(0, 3, 1, 1);
        this.dialog.add((Component)this.toggleInfoButton, gbc);
        gbc = GuiUtil.makeGbc(1, 3, 1, 1);
        this.dialog.add((Component)this.toggleHighlighting, gbc);
        gbc = GuiUtil.makeGbc(2, 3, 1, 1);
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        this.dialog.add((Component)this.okButton, gbc);
        gbc = GuiUtil.makeGbc(3, 3, 1, 1);
        this.dialog.add((Component)this.cancelButton, gbc);
        ButtonAction buttonAction = new ButtonAction();
        this.okButton.addActionListener(buttonAction);
        this.cancelButton.addActionListener(buttonAction);
        this.toggleInfoButton.addActionListener(buttonAction);
        this.testButton.addActionListener(buttonAction);
        this.toggleHighlighting.setVisible(false);
        this.toggleHighlighting.setSelected(true);
        this.toggleHighlighting.addItemListener(e -> {
            if (this.toggleHighlighting.isSelected()) {
                this.highlighter.setEnabled(true);
                this.highlighterUpdate.run();
            } else {
                this.input.getHighlighter().removeAllHighlights();
                this.highlighter.setEnabled(false);
            }
        });
        this.okButton.setMnemonic(83);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setToolTipText("Press ESC to cancel");
        this.dialog.pack();
        Dimension preferred = this.dialog.getPreferredSize();
        this.dialog.setMinimumSize(new Dimension(400, preferred.height));
    }

    @Override
    public String showDialog(String title, String preset, String info) {
        this.input.setText(preset);
        this.label.setText(title);
        this.info.setText(info);
        if (info == null) {
            this.info.setVisible(false);
        } else {
            this.info.setVisible(this.showInfoByDefault);
        }
        this.toggleInfoButton.setVisible(info != null);
        this.toggleInfoButton.setSelected(this.info.isVisible());
        this.result = null;
        this.input.requestFocusInWindow();
        this.dialog.pack();
        Dimension p = this.dialog.getPreferredSize();
        Rectangle screen = this.parent.getGraphicsConfiguration().getBounds();
        if (p.height > screen.height / 2) {
            this.dialog.setSize(p.width, screen.height / 2);
        }
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
        return this.result;
    }

    public void setFormatter(DataFormatter<String> formatter) {
        this.formatter = formatter;
    }

    public void setTester(Tester tester) {
        this.tester = tester;
        this.testButton.setVisible(tester != null);
    }

    public void setSyntaxHighlighter(SyntaxHighlighter highlighter) {
        if (this.highlighter == null && highlighter != null) {
            this.highlighter = highlighter;
            this.highlighterUpdate = SyntaxHighlighter.install(this.input, highlighter);
            this.toggleHighlighting.setVisible(true);
        }
    }

    @Override
    public void setLinkLabelListener(LinkLabelListener listener) {
        this.info.setListener(listener);
    }

    public void setAllowEmpty(boolean allow) {
        this.allowEmpty = allow;
    }

    public final void setAllowLinebreaks(boolean allow) {
        GuiUtil.installLengthLimitDocumentFilter(this.input, 200000, allow, new Object[0]);
        this.scrollpane.setRowHeaderView(allow ? new LineNumbers(this.input) : null);
    }

    public final void setShowInfoByDefault(boolean show) {
        this.showInfoByDefault = show;
    }

    private String format(String input) {
        if (this.formatter != null && input != null) {
            return this.formatter.format(input);
        }
        return input;
    }

    private void updateOkButton() {
        this.okButton.setEnabled(this.isSomethingToSave());
    }

    private boolean isSomethingToSave() {
        if (this.allowEmpty) {
            return true;
        }
        String currentInput = this.format(this.input.getText());
        return currentInput != null && !currentInput.isEmpty();
    }

    private static boolean bigger(Dimension d1, Dimension d2) {
        return d1.height > d2.height || d1.width > d2.width;
    }

    private void adjustSize() {
        if (this.dialog.isVisible()) {
            Dimension p = this.dialog.getPreferredSize();
            Point bottomRight = this.dialog.getLocationOnScreen();
            bottomRight.translate(p.width, p.height);
            if (Editor.bigger(p, this.dialog.getSize()) && GuiUtil.isPointOnScreen(bottomRight)) {
                this.dialog.pack();
            }
        }
    }

    public static interface Tester {
        public String test(Window var1, Component var2, int var3, int var4, String var5);
    }

    private class ChangeListener
    implements DocumentListener {
        private ChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Editor.this.updateOkButton();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor.this.adjustSize();
                }
            });
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Editor.this.updateOkButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Editor.this.updateOkButton();
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String changed;
            if (e.getSource() == Editor.this.okButton) {
                Editor.this.result = Editor.this.input.getText();
                Editor.this.dialog.setVisible(false);
            } else if (e.getSource() == Editor.this.cancelButton) {
                Editor.this.dialog.setVisible(false);
            } else if (e.getSource() == Editor.this.toggleInfoButton) {
                Editor.this.info.setVisible(Editor.this.toggleInfoButton.isSelected());
                Editor.this.dialog.pack();
            } else if (e.getSource() == Editor.this.testButton && Editor.this.tester != null && (changed = Editor.this.tester.test(Editor.this.dialog, Editor.this.testButton, 0, Editor.this.testButton.getHeight(), Editor.this.input.getText())) != null) {
                Editor.this.input.setText(changed);
            }
        }
    }
}

