/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.StringEditor;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import chatty.util.SyntaxHighlighter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorStringSetting
extends JPanel
implements StringSetting {
    private StringEditor editor;
    private final JTextField preview;
    private final JButton editButton;
    private LinkLabelListener linkLabelListener;
    private boolean showInfoByDefault;
    private SyntaxHighlighter syntaxHighlighter;
    private String value;
    private String info;
    private ChangeListener listener;

    public EditorStringSetting(Window parent, String title, int size, boolean allowEmpty, boolean allowLinebreaks, String info) {
        this(parent, title, size, allowEmpty, allowLinebreaks, info, null);
    }

    public EditorStringSetting(Window parent, String title, int size, boolean allowEmpty, boolean allowLinebreaks, String defaultInfo, Editor.Tester tester) {
        this(parent, title, size, () -> EditorStringSetting.createEditor(parent, allowEmpty, allowLinebreaks, tester));
        this.info = defaultInfo;
    }

    private static Editor createEditor(Window parent, boolean allowEmpty, boolean allowLinebreaks, Editor.Tester tester) {
        Editor editor = new Editor(parent);
        editor.setAllowEmpty(allowEmpty);
        editor.setAllowLinebreaks(allowLinebreaks);
        editor.setTester(tester);
        return editor;
    }

    public EditorStringSetting(Window parent, final String title, int size, final Supplier<StringEditor> editorCreator) {
        this.setLayout(new BorderLayout(2, 0));
        this.editButton = new JButton(Language.getString("dialog.button.edit"));
        GuiUtil.smallButtonInsets(this.editButton);
        this.editButton.setToolTipText(title);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String result;
                if (EditorStringSetting.this.editor == null) {
                    EditorStringSetting.this.editor = (StringEditor)editorCreator.get();
                    EditorStringSetting.this.setLinkLabelListener(EditorStringSetting.this.linkLabelListener);
                    EditorStringSetting.this.setShowInfoByDefault(EditorStringSetting.this.showInfoByDefault);
                    if (EditorStringSetting.this.editor instanceof Editor) {
                        ((Editor)EditorStringSetting.this.editor).setSyntaxHighlighter(EditorStringSetting.this.syntaxHighlighter);
                    }
                }
                if ((result = EditorStringSetting.this.editor.showDialog(title, EditorStringSetting.this.value, EditorStringSetting.this.info)) != null) {
                    EditorStringSetting.this.setSettingValue(result);
                }
            }
        });
        if (size > -1) {
            this.preview = new JTextField(size);
            this.preview.setEditable(false);
            this.add((Component)this.preview, "Center");
        } else {
            this.preview = null;
        }
        this.add((Component)this.editButton, "East");
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public void setLinkLabelListener(LinkLabelListener listener) {
        if (this.editor != null) {
            this.editor.setLinkLabelListener(listener);
        } else {
            this.linkLabelListener = listener;
        }
    }

    public void setSyntaxHighlighter(SyntaxHighlighter hl) {
        this.syntaxHighlighter = hl;
        if (this.editor instanceof Editor) {
            ((Editor)this.editor).setSyntaxHighlighter(this.syntaxHighlighter);
        }
    }

    @Override
    public String getSettingValue() {
        return this.value;
    }

    @Override
    public void setSettingValue(String value) {
        if (!Objects.equals(this.value, value)) {
            this.value = value;
            if (this.preview != null) {
                this.preview.setText(value);
            }
            if (this.listener != null) {
                this.listener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setShowInfoByDefault(boolean show) {
        if (this.editor != null) {
            if (this.editor instanceof Editor) {
                ((Editor)this.editor).setShowInfoByDefault(show);
            }
        } else {
            this.showInfoByDefault = show;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
    }
}

