/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import chatty.util.api.IgnoredEmotes;
import chatty.util.seventv.WebPUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class EmoteSettings
extends SettingsPanel {
    protected final LocalEmotesDialog localEmotesDialog;
    private static EditIgnoredEmote editIgnoredEmoteDialog;

    protected EmoteSettings(SettingsDialog d) {
        JPanel main = this.addTitledPanel(Language.getString("settings.section.emoticons"), 0);
        main.add((Component)d.addSimpleBooleanSetting("emoticonsEnabled"), SettingsDialog.makeGbc(0, 0, 2, 1, 17));
        IgnoredEmotesDialog ignoredEmotesDialog = new IgnoredEmotesDialog(d);
        JButton ignoredEmotesButton = new JButton(Language.getString("settings.emoticons.button.editIgnored"));
        GuiUtil.smallButtonInsets(ignoredEmotesButton);
        ignoredEmotesButton.addActionListener(e -> ignoredEmotesDialog.show(d));
        main.add((Component)ignoredEmotesButton, SettingsDialog.makeGbc(2, 0, 3, 1, 13));
        main.add((Component)new JLabel(Language.getString("settings.emoticons.chatScale")), SettingsDialog.makeGbc(0, 3, 1, 1, 17));
        ComboLongSetting emoteScale = new ComboLongSetting(EmoteSettings.makeScaleValues());
        d.addLongSetting("emoteScale", emoteScale);
        main.add((Component)emoteScale, SettingsDialog.makeGbc(1, 3, 1, 1, 17));
        main.add((Component)new JLabel(Language.getString("settings.emoticons.maxHeight")), SettingsDialog.makeGbc(2, 3, 1, 1, 13));
        main.add((Component)d.addSimpleLongSetting("emoteMaxHeight", 3, true), SettingsDialog.makeGbc(3, 3, 1, 1, 17));
        main.add((Component)new JLabel(Language.getString("settings.emoticons.maxHeightPixels")), SettingsDialog.makeGbc(4, 3, 1, 1, 17));
        main.add((Component)new JLabel(Language.getString("settings.emoticons.gigantifiedScale")), SettingsDialog.makeGbc(0, 4, 1, 1, 17));
        ComboLongSetting emoteScaleGigantified = new ComboLongSetting(EmoteSettings.makeScaleValuesGigantified());
        d.addLongSetting("emoteScaleGigantified", emoteScaleGigantified);
        main.add((Component)emoteScaleGigantified, SettingsDialog.makeGbc(1, 4, 1, 1, 17));
        main.add((Component)new JLabel(Language.getString("settings.emoticons.dialogScale")), SettingsDialog.makeGbc(0, 5, 1, 1, 17));
        ComboLongSetting emoteScaleDialog = new ComboLongSetting(EmoteSettings.makeScaleValues());
        d.addLongSetting("emoteScaleDialog", emoteScaleDialog);
        main.add((Component)emoteScaleDialog, SettingsDialog.makeGbc(1, 5, 1, 1, 17));
        main.add((Component)d.addSimpleBooleanSetting("closeEmoteDialogOnDoubleClick"), SettingsDialog.makeGbc(0, 6, 3, 1));
        ComboLongSetting animatePauseSetting = d.addComboLongSetting("animationPause", 0, 1, 2);
        ComboLongSetting animatePauseFrameSetting = d.addComboLongSetting("animationPauseFrame", 0, 1, 2);
        SettingsUtil.addSubsettings(animatePauseSetting, s -> s != 2L, animatePauseFrameSetting);
        SettingsUtil.addLabeledComponent(main, "animationPause", 0, 7, 4, 17, animatePauseSetting);
        SettingsUtil.addLabeledComponent(main, "animationPauseFrame", 0, 8, 4, 17, animatePauseFrameSetting);
        JLabel webpTest = new JLabel("WebP not supported.");
        main.add((Component)webpTest, SettingsDialog.makeGbc(2, 9, 3, 1, 17));
        WebPUtil.runIfWebPAvailable(() -> webpTest.setText("WebP is supported."));
        main.add((Component)d.addSimpleBooleanSetting("webp"), SettingsDialog.makeGbc(0, 9, 2, 1, 17));
        JPanel providerSettingsPanel = this.addTitledPanel("Provider-specific Emote Settings", 1);
        JTabbedPane providerSettingsTabs = new JTabbedPane();
        JPanel twitchSettings = new JPanel(new GridBagLayout());
        JPanel ffzSettings = new JPanel(new GridBagLayout());
        JPanel bttvSettings = new JPanel(new GridBagLayout());
        JPanel seventvSettings = new JPanel(new GridBagLayout());
        JPanel emojiSettings = new JPanel(new GridBagLayout());
        providerSettingsTabs.addTab("Twitch", twitchSettings);
        providerSettingsTabs.addTab("FFZ", ffzSettings);
        providerSettingsTabs.addTab("BTTV", bttvSettings);
        providerSettingsTabs.addTab("7TV", seventvSettings);
        providerSettingsTabs.addTab(Language.getString("settings.section.emoji"), emojiSettings);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 17);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        providerSettingsPanel.add((Component)providerSettingsTabs, gbc);
        LinkedHashMap<String, String> cheeringTypeDef = new LinkedHashMap<String, String>();
        cheeringTypeDef.put("none", Language.getString("settings.emoticons.cheers.option.text"));
        cheeringTypeDef.put("static", Language.getString("settings.emoticons.cheers.option.static"));
        cheeringTypeDef.put("animated", Language.getString("settings.emoticons.cheers.option.animated"));
        ComboStringSetting cheersType = new ComboStringSetting((Map<String, String>)cheeringTypeDef);
        d.addStringSetting("cheersType", cheersType);
        twitchSettings.add((Component)new JLabel(Language.getString("settings.emoticons.cheers")), SettingsDialog.makeGbc(0, 6, 1, 1, 10));
        twitchSettings.add((Component)cheersType, SettingsDialog.makeGbc(1, 6, 2, 1, 17));
        twitchSettings.add((Component)d.addSimpleBooleanSetting("animatedEmotes"), SettingsDialog.makeGbc(0, 7, 3, 1, 17));
        SettingsUtil.topAlign(twitchSettings, 10);
        SimpleBooleanSetting ffz = d.addSimpleBooleanSetting("ffz");
        ffzSettings.add((Component)ffz, SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        SimpleBooleanSetting ffzMod = d.addSimpleBooleanSetting("ffzModIcon");
        ffzSettings.add((Component)ffzMod, SettingsDialog.makeGbcSub(0, 2, 1, 1, 17));
        SimpleBooleanSetting ffzEvent = d.addSimpleBooleanSetting("ffzEvent");
        ffzSettings.add((Component)ffzEvent, SettingsDialog.makeGbcSub(0, 3, 1, 1, 17));
        SettingsUtil.addSubsettings(ffz, ffzMod, ffzEvent);
        SettingsUtil.topAlign(ffzSettings, 10);
        bttvSettings.add((Component)d.addSimpleBooleanSetting("bttvEmotes"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        SettingsUtil.topAlign(bttvSettings, 10);
        seventvSettings.add((Component)d.addSimpleBooleanSetting("seventv"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        SettingsUtil.topAlign(seventvSettings, 10);
        LinkedHashMap<String, String> emojiSetDef = new LinkedHashMap<String, String>();
        emojiSetDef.put("twemoji", "Twemoji (Twitter)");
        emojiSetDef.put("e1", "Emoji One [outdated]");
        emojiSetDef.put("none", Language.getString("settings.emoji.option.none"));
        ComboStringSetting emojiSet = new ComboStringSetting((Map<String, String>)emojiSetDef);
        d.addStringSetting("emoji", emojiSet);
        emojiSettings.add((Component)new JLabel(Language.getString("settings.emoji.set")), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        emojiSettings.add((Component)emojiSet, SettingsDialog.makeGbc(1, 0, 1, 1, 17));
        emojiSettings.add((Component)d.addSimpleBooleanSetting("emojiReplace"), SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        SettingsUtil.addLabeledComponent(emojiSettings, "emojiZWJ", 0, 2, 1, 17, d.addComboLongSetting("emojiZWJ", 0, 1, 2));
        SettingsUtil.topAlign(emojiSettings, 10);
        JPanel localEmoteSettings = this.addTitledPanel(Language.getString("settings.section.localEmotes"), 3);
        localEmoteSettings.add((Component)new LinkLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>Emotes configured in this section will always be available in your sent messages, however other people will only see them in your messages if you actually have access to them. [help-settings:EmoticonsLocal Learn More]", d.getLinkLabelListener()), SettingsDialog.makeGbc(0, 0, 2, 1, 17));
        LinkedHashMap<Long, String> smiliesDef = new LinkedHashMap<Long, String>();
        smiliesDef.put(0L, "Off");
        smiliesDef.put(1L, "Robot");
        smiliesDef.put(2L, "Glitch");
        smiliesDef.put(3L, "Monkey");
        smiliesDef.put(10L, "Robot (Set automatically)");
        smiliesDef.put(20L, "Glitch (Set automatically)");
        smiliesDef.put(30L, "Monkey (Set automatically)");
        ComboLongSetting smilies = new ComboLongSetting((Map<Long, String>)smiliesDef);
        d.addLongSetting("smilies", smilies);
        SettingsUtil.addLabeledComponent(localEmoteSettings, "smilies", 0, 2, 1, 17, smilies);
        this.localEmotesDialog = new LocalEmotesDialog(d);
        JButton localEmotesButton = new JButton("View Local Emotes");
        GuiUtil.smallButtonInsets(localEmotesButton);
        localEmotesButton.addActionListener(e -> this.localEmotesDialog.show(d));
        localEmoteSettings.add((Component)localEmotesButton, SettingsDialog.makeGbc(0, 1, 2, 1, 17));
    }

    public static Map<Long, String> makeScaleValues() {
        LinkedHashMap<Long, String> scaleDef = new LinkedHashMap<Long, String>();
        for (int i = 50; i <= 200; i += 10) {
            scaleDef.put(Long.valueOf(i), i + "%");
        }
        return scaleDef;
    }

    public static Map<Long, String> makeScaleValuesGigantified() {
        LinkedHashMap<Long, String> scaleDef = new LinkedHashMap<Long, String>();
        for (int i = 100; i <= 200; i += 10) {
            scaleDef.put(Long.valueOf(i), "+" + (i - 100) + "%");
        }
        return scaleDef;
    }

    public void setData(Collection<Emoticon> data) {
        this.localEmotesDialog.setData(data);
    }

    public Collection<Emoticon> getData() {
        return this.localEmotesDialog.getData();
    }

    public static IgnoredEmotes.Item showIgnoredEmoteEditDialog(Window owner, Component comp, Emoticon emote, Collection<IgnoredEmotes.Item> currentMatches) {
        if (editIgnoredEmoteDialog == null) {
            editIgnoredEmoteDialog = new EditIgnoredEmote(owner);
        }
        return editIgnoredEmoteDialog.showDialog(comp, emote, currentMatches);
    }

    public static void main(String[] args) {
        ArrayList<IgnoredEmotes.Item> matches = new ArrayList<IgnoredEmotes.Item>();
        matches.add(IgnoredEmotes.Item.parse("Kappa for:c"));
        matches.add(IgnoredEmotes.Item.parse("Kappa for:t"));
        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.TWITCH, "Kappa");
        System.out.println(new EditIgnoredEmote(null).showDialog(null, b.build(), matches));
        System.exit(0);
    }

    private static class IgnoredEmotesDialog
    extends LazyDialog {
        private final SettingsDialog d;
        private final ListSelector setting;

        private IgnoredEmotesDialog(SettingsDialog d) {
            this.d = d;
            this.setting = d.addListSetting("ignoredEmotes", "Ignored Emote", 280, 280, false, true);
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(IgnoredEmotesDialog.this.d);
                this.setTitle(Language.getString("settings.ignoredEmotes.title"));
                this.setModal(true);
                this.setLayout(new GridBagLayout());
                IgnoredEmotesDialog.this.d;
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                this.add((Component)IgnoredEmotesDialog.this.setting, gbc);
                IgnoredEmotesDialog.this.d;
                gbc = SettingsDialog.makeGbc(1, 0, 1, 1);
                gbc.anchor = 11;
                this.add((Component)new JLabel("<html><body style='width:240px;'><p style='padding:5px;'>" + Language.getString("settings.ignoredEmotes.info1") + "</p><p style='padding:5px;'>In addition to the name you can provide the following restrictions:</p><ul style='padding:5px;padding-left:0'><li><code>for:t</code> - Only hide from TAB Completion (<code>c</code> - Chat, <code>d</code> - Emote Dialog, <code>t</code> - TAB Completion)</li><li><code>type:ffz</code> - Must be an FFZ emote (<code>twitch</code>, <code>bttv</code>, <code>7tv</code>)</li><li><code>id:123</code> - Emote must have the given id</li></ul><p style='padding:5px;'>" + Language.getString("settings.ignoredEmotes.info2") + "</p>"), gbc);
                JButton closeButton = new JButton(Language.getString("dialog.button.close"));
                closeButton.addActionListener(e -> this.setVisible(false));
                IgnoredEmotesDialog.this.d;
                gbc = SettingsDialog.makeGbc(0, 1, 2, 1);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                this.add((Component)closeButton, gbc);
                this.pack();
                GuiUtil.installEscapeCloseOperation(this);
            }
        }
    }

    private static class LocalEmotesDialog
    extends LazyDialog {
        private final TableEditor<Emoticon> editor;
        private final SettingsDialog d;

        private LocalEmotesDialog(SettingsDialog d) {
            this.d = d;
            this.editor = new TableEditor(1, false);
            this.editor.setItemEditor(() -> new TableEditor.ItemEditor<Emoticon>(){

                @Override
                public Emoticon showEditor(Emoticon preset, Component c, boolean edit, int column) {
                    JOptionPane.showMessageDialog(c, "Emotes should be added through the Emote Context Menu (e.g. right-click on an Emote in chat).");
                    return null;
                }
            });
            this.editor.setModel(new ListTableModel<Emoticon>(new String[]{"Image", "Code", "Id"}){

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return this.get(rowIndex);
                        }
                        case 1: {
                            return ((Emoticon)this.get((int)rowIndex)).code;
                        }
                        case 2: {
                            return ((Emoticon)this.get((int)rowIndex)).stringId;
                        }
                    }
                    return null;
                }
            });
            this.editor.setRendererForColumn(0, new EmoteRenderer(new CachedImage.CachedImageUser(){

                @Override
                public void iconLoaded(Image oldImage, Image newImage, boolean sizeChanged) {
                    editor.repaint();
                }
            }));
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        public void setData(Collection<Emoticon> data) {
            this.editor.setData(new ArrayList<Emoticon>(data));
        }

        public List<Emoticon> getData() {
            return this.editor.getData();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(LocalEmotesDialog.this.d);
                this.setTitle("Local Emotes");
                this.setModal(true);
                this.setLayout(new GridBagLayout());
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                this.add((Component)LocalEmotesDialog.this.editor, gbc);
                this.pack();
                GuiUtil.installEscapeCloseOperation(this);
            }
        }
    }

    public static class EditIgnoredEmote
    extends JDialog {
        private final JPanel beforePanel;
        private final JCheckBox chatB = new JCheckBox(Language.getString("settings.ignoredEmotes.for.chat"));
        private final JCheckBox dialogB = new JCheckBox(Language.getString("settings.ignoredEmotes.for.emoteDialog"));
        private final JCheckBox completionB = new JCheckBox(Language.getString("settings.ignoredEmotes.for.completion"));
        private final JCheckBox chat = new JCheckBox(Language.getString("settings.ignoredEmotes.for.chat"));
        private final JCheckBox dialog = new JCheckBox(Language.getString("settings.ignoredEmotes.for.emoteDialog"));
        private final JCheckBox completion = new JCheckBox(Language.getString("settings.ignoredEmotes.for.completion"));
        private final JTextArea before = new JTextArea();
        private final JTextField after = new JTextField();
        private final JLabel info = new JLabel();
        private final JToggleButton ignoredButton;
        private final JToggleButton unignoredButton;
        private Emoticon emote;
        private boolean save;
        private IgnoredEmotes.Item result;

        public EditIgnoredEmote(Window owner) {
            super(owner);
            this.setModal(true);
            this.setTitle(Language.getString("settings.ignoredEmotes.title"));
            this.setLayout(new GridBagLayout());
            this.beforePanel = new JPanel(new GridBagLayout());
            this.before.setColumns(20);
            this.before.setEditable(false);
            this.before.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            this.before.setBorder(this.after.getBorder());
            this.after.setEditable(false);
            this.after.setColumns(20);
            this.before.setFont(Font.decode("Monospaced"));
            this.after.setFont(Font.decode("Monospaced"));
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 2, 1);
            this.add((Component)this.info, gbc);
            gbc = SettingsDialog.makeGbc(0, 0, 2, 1, 10);
            JLabel beforeLabel = new JLabel(Language.getString("settings.ignoredEmotes.before"));
            this.beforePanel.add((Component)beforeLabel, gbc);
            this.chatB.setEnabled(false);
            this.dialogB.setEnabled(false);
            this.completionB.setEnabled(false);
            gbc = SettingsDialog.makeGbc(0, 1, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.beforePanel.add((Component)this.before, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 2, 2, 1, 17);
            this.beforePanel.add((Component)this.chatB, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 3, 2, 1, 17);
            this.beforePanel.add((Component)this.dialogB, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 4, 2, 1, 17);
            this.beforePanel.add((Component)this.completionB, gbc);
            gbc = SettingsDialog.makeGbc(0, 1, 2, 1, 17);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 5, 0);
            this.add((Component)this.beforePanel, gbc);
            gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
            this.add((Component)new JLabel(Language.getString("settings.ignoredEmotes.after")), gbc);
            gbc = SettingsDialog.makeGbc(0, 3, 2, 1);
            gbc.fill = 2;
            this.add((Component)this.after, gbc);
            JPanel buttonPanel = new JPanel();
            this.ignoredButton = new JToggleButton(Language.getString("settings.ignoredEmotes.button.allIgnored"));
            GuiUtil.smallButtonInsets(this.ignoredButton);
            this.unignoredButton = new JToggleButton(Language.getString("settings.ignoredEmotes.button.notIgnored"));
            GuiUtil.smallButtonInsets(this.unignoredButton);
            buttonPanel.add(this.ignoredButton);
            buttonPanel.add(this.unignoredButton);
            gbc = SettingsDialog.makeGbcCloser(0, 4, 2, 1, 17);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)buttonPanel, gbc);
            this.ignoredButton.addActionListener(e -> {
                boolean selected = this.ignoredButton.isSelected();
                this.chat.setSelected(selected);
                this.dialog.setSelected(selected);
                this.completion.setSelected(selected);
            });
            this.unignoredButton.addActionListener(e -> {
                boolean selected = this.unignoredButton.isSelected();
                this.chat.setSelected(!selected);
                this.dialog.setSelected(!selected);
                this.completion.setSelected(!selected);
            });
            gbc = SettingsDialog.makeGbcCloser(0, 5, 2, 1, 17);
            this.add((Component)this.chat, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 6, 2, 1, 17);
            this.add((Component)this.dialog, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 7, 2, 1, 17);
            this.add((Component)this.completion, gbc);
            JButton okButton = new JButton(Language.getString("dialog.button.ok"));
            okButton.addActionListener(e -> {
                this.save = true;
                this.dispose();
            });
            gbc = SettingsDialog.makeGbc(0, 8, 1, 1, 17);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)okButton, gbc);
            JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
            cancelButton.addActionListener(e -> this.dispose());
            gbc = SettingsDialog.makeGbc(1, 8, 1, 1, 17);
            gbc.fill = 2;
            gbc.weightx = 0.3;
            this.add((Component)cancelButton, gbc);
            this.chat.setSelected(true);
            this.dialog.setSelected(true);
            this.completion.setSelected(true);
            this.chat.addItemListener(e -> this.updateResult());
            this.dialog.addItemListener(e -> this.updateResult());
            this.completion.addItemListener(e -> this.updateResult());
        }

        private void updateResult() {
            int in = 0;
            in += this.chat.isSelected() ? 1 : 0;
            in += this.dialog.isSelected() ? 2 : 0;
            this.ignoredButton.setSelected((in += this.completion.isSelected() ? 4 : 0) == 7);
            this.unignoredButton.setSelected(in == 0);
            IgnoredEmotes.Item item = IgnoredEmotes.Item.create(this.emote, in);
            if (in == 0) {
                this.after.setText("<not ignored>");
            } else {
                this.after.setText(item.toString());
                this.after.setCaretPosition(0);
            }
            this.result = item;
        }

        public IgnoredEmotes.Item showDialog(Component parent, Emoticon emote, Collection<IgnoredEmotes.Item> beforeData) {
            this.emote = emote;
            this.beforePanel.setVisible(!beforeData.isEmpty());
            this.info.setText("<html><body style='width:300px'>" + Language.getString("settings.ignoredEmotes.editInfo", emote) + "<br><br>" + Language.getString("settings.ignoredEmotes.editInfo2"));
            if (!beforeData.isEmpty()) {
                this.before.setText(StringUtil.join(beforeData, "\n"));
                this.before.setCaretPosition(0);
                int combinedIn = 0;
                for (IgnoredEmotes.Item item : beforeData) {
                    combinedIn |= item.context;
                }
                this.chatB.setSelected(combinedIn & true);
                this.dialogB.setSelected((combinedIn & 2) != 0);
                this.completionB.setSelected((combinedIn & 4) != 0);
            }
            this.result = null;
            this.updateResult();
            this.pack();
            this.setLocationRelativeTo(parent);
            this.save = false;
            this.setVisible(true);
            if (this.save) {
                return this.result;
            }
            return null;
        }
    }

    public static class EmoteRenderer
    extends JLabel
    implements TableCellRenderer {
        private final CachedImage.CachedImageUser emoticonUser;

        public EmoteRenderer(CachedImage.CachedImageUser emoticonUser) {
            this.emoticonUser = emoticonUser;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            Emoticon emote = (Emoticon)value;
            this.setIcon(emote.getIcon(this.emoticonUser).getImageIcon());
            return this;
        }
    }
}

