/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.InputListListener;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog
implements InputListListener,
ListSelectionListener,
ActionListener {
    private final InputList fontList;
    private final InputList fontSizeList;
    private final JCheckBox bold;
    private final JCheckBox italic;
    private static final String PREVIEW_TEXT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890\n\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00f4\u00e0\u00fa\u00e5\u00e3\u00eb.,-\\/#+-\u00b5[:]{}$";
    private final JTextArea preview = new JTextArea();
    private final JTextField test = new JTextField();
    private final JButton ok = new JButton(Language.getString("dialog.button.ok"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private int closeAction;
    public static final int ACTION_OK = 1;
    public static final int ACTION_CANCEL = 0;
    private Font font;
    private static final int FALLBACK_FONT_SIZE = 14;
    private String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "26", "28", "30", "32", "36", "48", "60", "72"};
    private final Dialog owner;

    public FontChooser(Dialog owner, String[] fonts, boolean showStyles) {
        super(owner, Language.getString("settings.chooseFont.title"), true);
        this.owner = owner;
        this.setLayout(new GridBagLayout());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel fontSelection = new JPanel(new GridBagLayout());
        if (fonts == null) {
            fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        this.fontList = new InputList(fonts);
        this.fontSizeList = new InputList(this.fontSizes, new IntegerVerifier());
        this.fontSizeList.getList().setFixedCellWidth(60);
        this.bold = new JCheckBox(Language.getString("settings.chooseFont.bold"));
        this.italic = new JCheckBox(Language.getString("settings.chooseFont.italic"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        fontSelection.add((Component)this.fontList, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        fontSelection.add((Component)this.fontSizeList, gbc);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        fontSelection.add((Component)this.bold, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        fontSelection.add((Component)this.italic, gbc);
        fontSelection.setBorder(BorderFactory.createTitledBorder(Language.getString("settings.chooseFont.selectFont")));
        this.bold.setEnabled(showStyles);
        this.italic.setEnabled(showStyles);
        this.fontList.addInputListListener(this);
        this.fontSizeList.addInputListListener(this);
        this.bold.addActionListener(e -> this.updateFont());
        this.italic.addActionListener(e -> this.updateFont());
        this.preview.setText(PREVIEW_TEXT);
        this.preview.setEditable(false);
        this.preview.setOpaque(false);
        this.preview.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.preview.setRows(6);
        this.preview.setLineWrap(true);
        this.preview.setWrapStyleWord(true);
        JPanel fontPreview = new JPanel(new BorderLayout());
        JScrollPane previewScroll = new JScrollPane(this.preview);
        previewScroll.setBorder(null);
        fontPreview.add(previewScroll);
        fontPreview.setBorder(BorderFactory.createTitledBorder(Language.getString("settings.chooseFont.preview")));
        JPanel fontTest = new JPanel(new BorderLayout());
        fontTest.add(this.test);
        this.test.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FontChooser.this.updatePreviewText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FontChooser.this.updatePreviewText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FontChooser.this.updatePreviewText();
            }
        });
        fontTest.setBorder(BorderFactory.createTitledBorder(Language.getString("settings.chooseFont.enterText")));
        gbc = this.makeGbc(0, 0, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.7;
        this.add((Component)fontSelection, gbc);
        gbc = this.makeGbc(0, 1, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.3;
        this.add((Component)fontPreview, gbc);
        gbc = this.makeGbc(0, 2, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)fontTest, gbc);
        gbc = this.makeGbc(0, 3, 1, 1);
        gbc.anchor = 13;
        gbc.weightx = 0.5;
        this.add((Component)this.ok, gbc);
        gbc = this.makeGbc(1, 3, 1, 1);
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        this.add((Component)this.cancel, gbc);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    public String getFontName() {
        return this.font.getName();
    }

    public Integer getFontSize() {
        return this.font.getSize();
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public int showDialog(Font font, String msg) {
        this.fontList.setValue(font.getName());
        this.fontSizeList.setValue(String.valueOf(font.getSize()));
        this.bold.setSelected(font.isBold());
        this.italic.setSelected(font.isItalic());
        if (msg != null) {
            this.preview.setText(msg);
        } else {
            this.preview.setText(PREVIEW_TEXT);
        }
        this.closeAction = 0;
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        return this.closeAction;
    }

    private void updateFont() {
        String fontName = this.fontList.getValue();
        Integer fontSize = 14;
        try {
            fontSize = Integer.parseInt(this.fontSizeList.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int style = 0;
        if (this.bold.isSelected()) {
            style |= 1;
        }
        if (this.italic.isSelected()) {
            style |= 2;
        }
        this.font = new Font(fontName, style, fontSize);
        this.preview.setFont(this.font);
    }

    private void updatePreviewText() {
        this.preview.setText("ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890\n\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00f4\u00e0\u00fa\u00e5\u00e3\u00eb.,-\\/#+-\u00b5[:]{}$\n" + this.test.getText());
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateFont();
    }

    @Override
    public void valueChanged(String value) {
        this.updateFont();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.closeAction = 1;
        }
        this.setVisible(false);
    }

    static class InputList
    extends JPanel
    implements ListSelectionListener,
    ActionListener,
    DocumentListener {
        private JList<String> list;
        private JTextField input;
        private InputListListener listener;

        InputList(String[] data) {
            this(data, null);
        }

        InputList(String[] data, InputVerifier inputVerifier) {
            this.list = new JList<String>(data);
            this.list.addListSelectionListener(this);
            this.list.setSelectionMode(0);
            JScrollPane listScroll = new JScrollPane(this.list);
            this.input = new JTextField();
            this.input.setInputVerifier(inputVerifier);
            this.input.addActionListener(this);
            this.input.getDocument().addDocumentListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.input, "North");
            this.add(listScroll);
        }

        public JList getList() {
            return this.list;
        }

        public void addInputListListener(InputListListener listener) {
            this.listener = listener;
        }

        public String getValue() {
            return this.input.getText();
        }

        public void setValue(String value) {
            this.list.clearSelection();
            this.list.setSelectedValue(value, true);
            this.input.setText(value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.valueChanged(this.input.getText());
        }

        private void valueChanged(String newValue) {
            if (this.listener != null) {
                this.listener.valueChanged(newValue);
            }
        }

        private void updateTextInput() {
            String newValue = this.list.getSelectedValue();
            if (newValue != null && !newValue.isEmpty()) {
                this.input.setText(newValue);
                this.valueChanged(newValue);
            }
        }

        private void updateListSelection() {
            String inputValue = StringUtil.toLowerCase(this.input.getText());
            if (inputValue.isEmpty()) {
                return;
            }
            int size = this.list.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                String value = this.list.getModel().getElementAt(i);
                if (value.equalsIgnoreCase(inputValue)) {
                    this.list.setSelectedValue(value, true);
                    this.valueChanged(value);
                    break;
                }
                if (!StringUtil.toLowerCase(value).startsWith(inputValue)) continue;
                this.scrollToValue(value);
                break;
            }
        }

        private void scrollToValue(String value) {
            this.list.setSelectedValue(value, true);
            this.list.clearSelection();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateListSelection();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateListSelection();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.updateTextInput();
                }
            });
        }
    }

    static class IntegerVerifier
    extends InputVerifier {
        IntegerVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField component = (JTextField)input;
            try {
                Integer.parseInt(component.getText());
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }
}

