/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.FontChooser;
import chatty.gui.components.settings.LongSetting;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontSetting
extends JPanel {
    public static final int NO_OPTION = 0;
    public static final int RESTRICTED_FONTS = 1;
    public static final int NO_STYLE_SELECTION = 2;
    private final JTextField fontField;
    private final JTextField fontSizeField;
    private final JButton editButton;
    private final StringSetting fontSetting;
    private final LongSetting fontSizeSetting;
    private final SettingType settingType;
    private FontChooser fontChooser;
    private String fontSettingValue;
    private int fontSizeSettingValue;
    private Font current = Font.decode("Dialog");

    public FontSetting(Dialog parent, SettingType settingType) {
        this(parent, settingType, 0);
    }

    public FontSetting(Dialog parent, SettingType settingType, int options) {
        String[] stringArray;
        boolean optionRestrictedFonts = (options & 1) != 0;
        boolean optionNoStyle = (options & 2) != 0;
        this.settingType = settingType;
        this.fontField = new JTextField(14);
        this.fontField.setEditable(false);
        this.fontSizeField = new JTextField(3);
        this.fontSizeField.setEditable(false);
        this.editButton = new JButton(Language.getString("dialog.button.change"));
        GuiUtil.smallButtonInsets(this.editButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.fontField, gbc);
        gbc.weightx = 0.0;
        ++gbc.gridx;
        this.add((Component)this.fontSizeField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.editButton, gbc);
        if (optionRestrictedFonts) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "Dialog";
            stringArray2[1] = "DialogInput";
            stringArray2[2] = "Monospaced";
            stringArray2[3] = "Serif";
            stringArray = stringArray2;
            stringArray2[4] = "SansSerif";
        } else {
            stringArray = null;
        }
        String[] fonts = stringArray;
        this.editButton.addActionListener(e -> {
            String info;
            int result;
            if (this.fontChooser == null) {
                this.fontChooser = new FontChooser(parent, fonts, !optionNoStyle);
            }
            if ((result = this.fontChooser.showDialog(this.current, info = optionRestrictedFonts ? Language.getString("settings.otherFonts.restrictedInfo") : null)) == 1) {
                this.current = this.fontChooser.getSelectedFont();
                this.saveFont();
            }
        });
        this.fontSetting = new StringSetting(){

            @Override
            public String getSettingValue() {
                return FontSetting.this.fontSettingValue;
            }

            @Override
            public void setSettingValue(String value) {
                FontSetting.this.fontSettingValue = value;
                FontSetting.this.loadFont();
            }
        };
        this.fontSizeSetting = new LongSetting(){

            @Override
            public Long getSettingValue() {
                return FontSetting.this.fontSizeSettingValue;
            }

            @Override
            public Long getSettingValue(Long def) {
                return FontSetting.this.fontSizeSettingValue;
            }

            @Override
            public void setSettingValue(Long setting) {
                FontSetting.this.fontSizeSettingValue = setting.intValue();
                FontSetting.this.loadFont();
            }
        };
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editButton.setEnabled(enabled);
        this.fontField.setEnabled(enabled);
        this.fontSizeField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void loadFont() {
        this.current = this.settingType == SettingType.STRING ? Font.decode(this.fontSettingValue) : Font.decode(this.fontSettingValue + " " + this.fontSizeSettingValue);
        this.updateDisplay();
    }

    private void saveFont() {
        this.fontSettingValue = this.settingType == SettingType.STRING ? this.makeFontName(this.current) + " " + this.current.getSize() : this.current.getName();
        this.fontSizeSettingValue = this.current.getSize();
        this.updateDisplay();
    }

    private String makeFontName(Font font) {
        if (font.isBold() && font.isItalic()) {
            return font.getName() + " BoldItalic";
        }
        return String.format("%s%s%s", font.getName(), font.isBold() ? " Bold" : "", font.isItalic() ? " Italic" : "");
    }

    private void updateDisplay() {
        this.fontField.setText(this.makeFontName(this.current));
        this.fontSizeField.setText(String.valueOf(this.current.getSize()));
    }

    public StringSetting getFontSetting() {
        return this.fontSetting;
    }

    public LongSetting getFontSizeSetting() {
        return this.fontSizeSetting;
    }

    public static enum SettingType {
        STRING,
        STRING_INT;

    }
}

