/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComboBox;

public class GenericComboSetting<E>
extends JComboBox<Entry<E>> {
    private final Set<Consumer<GenericComboSetting<E>>> listeners = new HashSet<Consumer<GenericComboSetting<E>>>();

    public GenericComboSetting() {
    }

    public GenericComboSetting(E[] initialItems) {
        for (E item : initialItems) {
            this.add(item);
        }
        if (initialItems.length > 0) {
            this.setSelectedIndex(0);
        }
    }

    public GenericComboSetting(Map<E, String> items) {
        for (E value : items.keySet()) {
            String label = items.get(value);
            this.add(value, label);
        }
    }

    public E getSettingValue() {
        return this.getSettingValue(null);
    }

    public E getSettingValue(E def) {
        Entry selected = (Entry)this.getSelectedItem();
        if (selected == null) {
            return def;
        }
        return selected.value;
    }

    public Entry<E> getEntry(E value) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!Objects.equals(((Entry)this.getItemAt((int)i)).value, value)) continue;
            return (Entry)this.getItemAt(i);
        }
        return null;
    }

    public boolean containsValue(E value) {
        return this.getEntry(value) != null;
    }

    public void setSettingValue(E value) {
        Entry<E> entry = this.getEntry(value);
        if (entry == null) {
            entry = new Entry<E>(value, value == null ? "" : String.valueOf(value));
            if (!this.isEditable()) {
                this.addItem(entry);
            }
        }
        this.setSelectedItem(entry);
        this.informSettingChangeListeners();
    }

    public void add(E value) {
        Entry<E> entry = new Entry<E>(value, String.valueOf(value));
        this.addItem(entry);
    }

    public void add(E value, String label) {
        Entry<E> entry = new Entry<E>(value, label);
        this.addItem(entry);
    }

    public void insert(E value, String label, int pos) {
        Entry<E> entry = new Entry<E>(value, label);
        this.insertItemAt(entry, pos);
    }

    public void remove(E value) {
        Entry<E> entry = new Entry<E>(value, String.valueOf(value));
        this.removeItem(entry);
    }

    public void replace(E search, E replace) {
        Entry<E> searchEntry = new Entry<E>(search, String.valueOf(search));
        Entry<E> replaceEntry = new Entry<E>(replace, String.valueOf(replace));
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!((Entry)this.getItemAt(i)).equals(searchEntry)) continue;
            this.removeItemAt(i);
            this.insertItemAt(replaceEntry, i);
            return;
        }
    }

    public void clear() {
        this.removeAllItems();
    }

    public void setData(Map<E, String> data) {
        this.clear();
        this.addData(data);
    }

    public void addData(Map<E, String> data) {
        if (data != null) {
            for (E key : data.keySet()) {
                this.add(key, data.get(key));
            }
        }
    }

    public void addSettingChangeListener(Consumer<GenericComboSetting<E>> listener) {
        if (listener != null) {
            if (this.listeners.isEmpty()) {
                this.addItemListener(e -> this.informSettingChangeListeners());
            }
            this.listeners.add(listener);
        }
    }

    public void informSettingChangeListeners() {
        for (Consumer<GenericComboSetting<E>> listener : this.listeners) {
            listener.accept(this);
        }
    }

    public static class Entry<E> {
        public final E value;
        public final String label;

        public Entry(E value, String label) {
            this.value = value;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static Object valueOf(String value) {
            return new Entry<String>(value, value);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode(this.value);
            return hash;
        }
    }
}

