/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.HighlightSettings;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class HighlightBlacklist
extends LazyDialog {
    private final SettingsDialog d;
    private final ListSelector setting;
    private final String type;

    public HighlightBlacklist(SettingsDialog d, String type, String settingName) {
        this.d = d;
        this.setting = d.addListSetting(settingName, "Blacklist", 100, 250, false, true);
        this.type = type;
    }

    @Override
    public JDialog createDialog() {
        return new Dialog();
    }

    public void addItem(String item) {
        item = item.trim();
        List<String> values = this.setting.getData();
        if (!item.isEmpty() && !values.contains(item)) {
            values.add(item);
            this.setting.setData(values);
        }
    }

    private class Dialog
    extends JDialog {
        private Dialog() {
            super(HighlightBlacklist.this.d);
            this.setDefaultCloseOperation(1);
            this.setTitle(Language.getString("settings.blacklist." + HighlightBlacklist.this.type + ".title"));
            this.setLayout(new GridBagLayout());
            HighlightBlacklist.this.d;
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
            this.add((Component)new JLabel("<html><body style='width:340px;padding:4px;'>" + SettingsUtil.getInfo("info-blacklist.html", null)), gbc);
            HighlightBlacklist.this.d;
            gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            HighlightBlacklist.this.setting.setInfo(HighlightSettings.getMatchingHelp("highlightBlacklist"));
            HighlightBlacklist.this.setting.setDataFormatter(input -> input.trim());
            HighlightBlacklist.this.setting.setInfoLinkLabelListener(HighlightBlacklist.this.d.getLinkLabelListener());
            HighlightBlacklist.this.setting.setEditor(() -> {
                HighlighterTester tester = new HighlighterTester((Window)HighlightBlacklist.this.d, true, HighlightBlacklist.this.type);
                tester.setEditingBlacklistItem(true);
                tester.setLinkLabelListener(HighlightBlacklist.this.d.getLinkLabelListener());
                return tester;
            });
            this.add((Component)HighlightBlacklist.this.setting, gbc);
            JButton closeButton = new JButton(Language.getString("dialog.button.close"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dialog.this.setVisible(false);
                }
            });
            HighlightBlacklist.this.d;
            gbc = SettingsDialog.makeGbc(0, 5, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)closeButton, gbc);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
        }
    }
}

