/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.HighlightBlacklist;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.StringEditor;
import chatty.lang.Language;
import chatty.util.Replacer2;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class HighlightSettings
extends SettingsPanel {
    public static final String INFO_HEADER = "<html><body style='width:370px;font-weight:normal;'>";
    private final ListSelector items;
    private final NoHighlightUsers noHighlightUsers;
    private final HighlightBlacklist highlightBlacklist;
    private final Substitutes substitutes;

    public static String getMatchingHelp(String type) {
        return INFO_HEADER + SettingsUtil.getInfo("info-matching.html", type);
    }

    public HighlightSettings(SettingsDialog d) {
        super(true);
        this.noHighlightUsers = new NoHighlightUsers(d);
        this.highlightBlacklist = new HighlightBlacklist(d, "highlight", "highlightBlacklist");
        this.substitutes = new Substitutes(d);
        JPanel base = this.addTitledPanel(Language.getString("settings.section.highlightMessages"), 0, true);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.insets.bottom -= 3;
        gbc.anchor = 17;
        SimpleBooleanSetting highlightEnabled = d.addSimpleBooleanSetting("highlightEnabled");
        base.add((Component)highlightEnabled, gbc);
        Insets settingInsets = new Insets(1, 14, 1, 4);
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.anchor = 17;
        gbc.insets = settingInsets;
        SimpleBooleanSetting highlightUsername = d.addSimpleBooleanSetting("highlightUsername");
        base.add((Component)highlightUsername, gbc);
        gbc = SettingsDialog.makeGbc(1, 1, 1, 1);
        gbc.insets = settingInsets;
        gbc.anchor = 17;
        SimpleBooleanSetting highlightNextMessages = d.addSimpleBooleanSetting("highlightNextMessages");
        base.add((Component)highlightNextMessages, gbc);
        gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
        gbc.insets = settingInsets;
        gbc.anchor = 17;
        SimpleBooleanSetting highlightOwnText = d.addSimpleBooleanSetting("highlightOwnText");
        base.add((Component)highlightOwnText, gbc);
        gbc = SettingsDialog.makeGbc(1, 2, 1, 1);
        gbc.insets = settingInsets;
        gbc.anchor = 17;
        SimpleBooleanSetting highlightIgnored = d.addSimpleBooleanSetting("highlightIgnored");
        base.add((Component)highlightIgnored, gbc);
        gbc = SettingsDialog.makeGbc(1, 3, 1, 1);
        gbc.insets = settingInsets;
        gbc.anchor = 17;
        SimpleBooleanSetting highlightOverrideIgnored = d.addSimpleBooleanSetting("highlightOverrideIgnored");
        base.add((Component)highlightOverrideIgnored, gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 1, 1, 17);
        gbc.insets = settingInsets;
        SimpleBooleanSetting highlightMatches = d.addSimpleBooleanSetting("highlightMatches");
        base.add((Component)highlightMatches, gbc);
        gbc = SettingsDialog.makeGbc(0, 4, 1, 1, 17);
        gbc.insets = new Insets(1, 23, 1, 14);
        SimpleBooleanSetting highlightMatchesAll = d.addSimpleBooleanSetting("highlightMatchesAll");
        base.add((Component)highlightMatchesAll, gbc);
        gbc = SettingsDialog.makeGbc(1, 4, 1, 1, 17);
        gbc.insets = settingInsets;
        SimpleBooleanSetting highlightMatchesAllEntries = d.addSimpleBooleanSetting("highlightMatchesAllEntries");
        base.add((Component)highlightMatchesAllEntries, gbc);
        gbc = SettingsDialog.makeGbc(0, 5, 2, 1, 17);
        SimpleBooleanSetting highlightByPoints = d.addSimpleBooleanSetting("highlightByPoints");
        base.add((Component)highlightByPoints, gbc);
        gbc = SettingsDialog.makeGbc(0, 6, 2, 1);
        gbc.insets = new Insets(5, 10, 5, 5);
        this.items = d.addListSetting("highlight", "Highlight", 220, 250, true, true);
        this.items.setInfo(HighlightSettings.getMatchingHelp("highlight"));
        this.items.setInfoLinkLabelListener(d.getLinkLabelListener());
        this.items.setEditor(() -> {
            HighlighterTester tester = new HighlighterTester((Window)d, true, "highlight");
            tester.setAddToBlacklistListener(e -> this.highlightBlacklist.addItem(e.getActionCommand()));
            tester.setLinkLabelListener(d.getLinkLabelListener());
            return tester;
        });
        this.items.setDataFormatter(input -> input.trim());
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        base.add((Component)this.items, gbc);
        JButton noHighlightUsersButton = new JButton("Users to never highlight");
        GuiUtil.smallButtonInsets(noHighlightUsersButton);
        noHighlightUsersButton.addActionListener(e -> this.noHighlightUsers.show(this));
        gbc = SettingsDialog.makeGbc(0, 7, 1, 1);
        gbc.insets = new Insets(1, 10, 5, 5);
        gbc.fill = 2;
        base.add((Component)noHighlightUsersButton, gbc);
        JButton highlightBlacklistButton = new JButton("Highlight Blacklist");
        GuiUtil.smallButtonInsets(highlightBlacklistButton);
        highlightBlacklistButton.addActionListener(e -> this.highlightBlacklist.show(this));
        gbc = SettingsDialog.makeGbc(1, 7, 1, 1);
        gbc.insets = new Insets(1, 5, 5, 30);
        gbc.fill = 2;
        base.add((Component)highlightBlacklistButton, gbc);
        JButton presetsButton = new JButton("Presets");
        GuiUtil.smallButtonInsets(presetsButton);
        presetsButton.addActionListener(e -> d.showMatchingPresets());
        gbc = SettingsDialog.makeGbc(0, 8, 1, 1);
        gbc.insets = new Insets(1, 10, 5, 5);
        gbc.fill = 2;
        base.add((Component)presetsButton, gbc);
        JButton substitutesButton = new JButton("Substitutes / Lookalikes");
        GuiUtil.smallButtonInsets(substitutesButton);
        substitutesButton.addActionListener(e -> this.substitutes.show(this));
        gbc = SettingsDialog.makeGbc(1, 8, 1, 1);
        gbc.insets = new Insets(1, 5, 5, 30);
        gbc.fill = 2;
        base.add((Component)substitutesButton, gbc);
        SettingsUtil.addSubsettings(highlightEnabled, highlightUsername, highlightNextMessages, highlightOwnText, highlightIgnored, highlightOverrideIgnored, highlightMatches, this.items, noHighlightUsersButton, highlightBlacklistButton);
        SettingsUtil.addSubsettings(highlightMatches, highlightMatchesAll, highlightMatchesAllEntries);
    }

    public void selectItem(String item) {
        this.items.setSelected(item);
    }

    public void selectItems(Collection<String> selectItems) {
        this.items.setSelected(selectItems);
    }

    public static void main(String[] args) {
        SubstitutesEditor editor = new SubstitutesEditor(new JDialog());
        editor.showDialog("abc", "o # o \u043e \u03bf \u0585", null);
        System.exit(0);
    }

    private static class NoHighlightUsers
    extends LazyDialog {
        private static final DataFormatter<String> FORMATTER = new DataFormatter<String>(){

            @Override
            public String format(String input) {
                return StringUtil.toLowerCase(input.replaceAll("\\s", ""));
            }
        };
        private final SettingsDialog d;
        private final ListSelector noHighlightUsers;

        public NoHighlightUsers(SettingsDialog d) {
            this.d = d;
            this.noHighlightUsers = d.addListSetting("noHighlightUsers", "No Highlight User", 180, 250, false, true);
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private class Dialog
        extends JDialog {
            Dialog() {
                super(NoHighlightUsers.this.d);
                this.setDefaultCloseOperation(1);
                this.setTitle("Users to never highlight");
                this.setLayout(new GridBagLayout());
                NoHighlightUsers.this.d;
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
                this.add((Component)new JLabel("<html><body style='width:260px;padding:4px;'>Users on this list will never trigger a Highlight. This can be useful e.g. for bots in your channel that repeatedly post messages containing your name."), gbc);
                NoHighlightUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 0.5;
                gbc.weighty = 1.0;
                NoHighlightUsers.this.noHighlightUsers.setDataFormatter(FORMATTER);
                this.add((Component)NoHighlightUsers.this.noHighlightUsers, gbc);
                JButton closeButton = new JButton(Language.getString("dialog.button.close"));
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.setVisible(false);
                    }
                });
                NoHighlightUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.add((Component)closeButton, gbc);
                this.pack();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }

    private static class Substitutes
    extends LazyDialog {
        private final SettingsDialog d;
        private final JCheckBox substitutesEnabled;
        private final ListSelector substitutes;

        public Substitutes(SettingsDialog d) {
            this.d = d;
            this.substitutesEnabled = d.addSimpleBooleanSetting("matchingSubstitutesEnabled");
            this.substitutes = d.addListSetting("matchingSubstitutes", "Substitutes", 180, 250, true, true);
            this.substitutes.setChangeListener(value -> this.updateTestSubstitutes());
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private void updateTestSubstitutes() {
            HighlighterTester.substitutesItem = Replacer2.create(this.substitutes.getSettingValue());
            HighlighterTester.substitutesDefault = this.substitutesEnabled.isSelected();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(Substitutes.this.d);
                this.setDefaultCloseOperation(1);
                this.setTitle("Substitutes / Lookalikes");
                this.setLayout(new GridBagLayout());
                Substitutes.this.d;
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 2, 1);
                this.add((Component)new JLabel("<html><body style='width:340px;padding:4px;'>" + SettingsUtil.getInfo("info-substitutes.html", null)), gbc);
                Substitutes.this.d;
                gbc = SettingsDialog.makeGbc(0, 1, 1, 1, 17);
                Substitutes.this.substitutesEnabled.addItemListener(e -> Substitutes.this.updateTestSubstitutes());
                this.add((Component)Substitutes.this.substitutesEnabled, gbc);
                Substitutes.this.d;
                gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
                this.add((Component)new JLabel("<html><body style='width:340px;padding:4px;padding-top:0'>Independent of this setting the <code>config:s</code> prefix can enable and <code>config:!s</code> disable this feature on a per Highlight-item basis."), gbc);
                JButton addDefaults = new JButton("Add default entries");
                GuiUtil.smallButtonInsets(addDefaults);
                addDefaults.addActionListener(e -> {
                    int result = JOptionPane.showConfirmDialog(this.rootPane, "This will add 26 (a-z) lookalikes entries. Existing entries will remain.", "Add entries?", 0);
                    if (result == 0) {
                        List<String> data = Substitutes.this.substitutes.getData();
                        data.addAll(Replacer2.LOOKALIKES);
                        Substitutes.this.substitutes.setData(data);
                    }
                });
                Substitutes.this.d;
                gbc = SettingsDialog.makeGbc(1, 1, 1, 1, 13);
                this.add((Component)addDefaults, gbc);
                Substitutes.this.d;
                gbc = SettingsDialog.makeGbc(0, 3, 2, 1);
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                Substitutes.this.substitutes.setEditor(() -> new SubstitutesEditor(this));
                this.add((Component)Substitutes.this.substitutes, gbc);
                JButton closeButton = new JButton(Language.getString("dialog.button.close"));
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.setVisible(false);
                    }
                });
                Substitutes.this.d;
                gbc = SettingsDialog.makeGbc(0, 4, 2, 1);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.add((Component)closeButton, gbc);
                this.pack();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }

    private static class SubstitutesEditor
    extends JDialog
    implements StringEditor {
        private static final int INPUT_LENGTH_LIMIT = 200000;
        private final JTextArea itemValue = new JTextArea(4, 20);
        private final JTextArea info = new JTextArea(20, 68);
        private final JButton okButton = new JButton(Language.getString("dialog.button.save"));
        private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
        private String result;

        public SubstitutesEditor(Dialog owner) {
            super(owner);
            this.setModal(true);
            this.setTitle("Editor");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 2, 1);
            this.itemValue.setFont(new Font("Monospaced", 0, this.itemValue.getFont().getSize()));
            this.itemValue.setLineWrap(true);
            GuiUtil.installLengthLimitDocumentFilter(this.itemValue, 200000, false, new Object[0]);
            this.info.setEditable(false);
            this.info.setFont(new Font("Monospaced", 0, this.info.getFont().getSize()));
            JSplitPane splitPane = new JSplitPane(0, new JScrollPane(this.itemValue), new JScrollPane(this.info));
            gbc = SettingsDialog.makeGbc(0, 1, 2, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)splitPane, gbc);
            gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
            this.add((Component)new JLabel("<html><body style='width:340px;'>Automatically generated characters are indented. Duplicates within this entry are marked with [Duplicate], but shouldn't cause any issues."), gbc);
            GuiUtil.addChangeListener(this.itemValue.getDocument(), e -> this.updateItem());
            this.okButton.setMnemonic(83);
            this.cancelButton.setMnemonic(67);
            gbc = GuiUtil.makeGbc(0, 21, 1, 1, 13);
            gbc.weightx = 1.0;
            this.add((Component)this.okButton, gbc);
            this.add((Component)this.cancelButton, GuiUtil.makeGbc(1, 21, 1, 1, 13));
            this.okButton.addActionListener(e -> {
                this.result = this.itemValue.getText();
                this.setVisible(false);
            });
            this.cancelButton.addActionListener(e -> this.setVisible(false));
            this.pack();
        }

        private void updateItem() {
            String text = this.itemValue.getText();
            if (text.trim().isEmpty()) {
                this.info.setText("Nothing entered yet");
            } else {
                List<Replacer2.Part> split = Replacer2.parse(text);
                StringBuilder b = new StringBuilder();
                HashSet<String> checkUnique = new HashSet<String>();
                for (int i = 0; i < split.size(); ++i) {
                    if (i == 0) {
                        b.append("Replace with:");
                        b.append("\n");
                    } else if (i == 1) {
                        b.append("Replace:");
                        b.append("\n");
                    }
                    Replacer2.Part partItem = split.get(i);
                    String part = partItem.text;
                    if (checkUnique.contains(part) && !part.isEmpty()) {
                        b.append("[Duplicate]");
                    }
                    if (i > 1) {
                        checkUnique.add(part);
                    }
                    if (!partItem.valid && !partItem.text.isEmpty()) {
                        b.append("[Invalid]");
                    }
                    if (split.get((int)i).autoGenerated) {
                        b.append(" ");
                    }
                    b.append(" ");
                    b.append(part);
                    b.append(" : ");
                    IntStream stream = part.trim().codePoints();
                    stream.forEachOrdered(codePoint -> {
                        b.append(String.format("U+%04X", codePoint));
                        b.append("/").append(Character.getName(codePoint));
                        b.append(", ");
                    });
                    b.delete(b.length() - 2, b.length());
                    b.append("\n");
                }
                this.info.setText(b.toString());
            }
            boolean canSave = !text.trim().isEmpty();
            this.okButton.setEnabled(canSave);
        }

        @Override
        public String showDialog(String title, String preset, String info) {
            SwingUtilities.invokeLater(() -> {
                this.setMinimumSize(this.getPreferredSize());
                this.itemValue.setText(preset);
                this.updateItem();
            });
            this.setMinimumSize(this.getPreferredSize());
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
            return this.result;
        }

        @Override
        public void setLinkLabelListener(LinkLabelListener listener) {
        }
    }
}

