/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.Highlighter;
import chatty.gui.MainGui;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.ScrollPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.StringEditor;
import chatty.lang.Language;
import chatty.util.Replacer2;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.irc.MsgTags;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class HighlighterTester
extends JDialog
implements StringEditor {
    public static Map<String, CustomCommand> testPresets;
    public static Replacer2 substitutesItem;
    public static boolean substitutesDefault;
    private static final int MAX_INPUT_LENGTH = 50000;
    private static final String TEST_PRESET = "Enter test text.";
    private static final String TEST_PRESET_EXAMPLE = "Enter test text. Example: ";
    private final JButton okButton = new JButton(Language.getString("dialog.button.save"));
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton addToBlacklistButton = new JButton("Add to Blacklist");
    private final JTextField itemValue = new JTextField(40);
    private final JTextField blacklistValue = new JTextField(40);
    private final JTextPane testInput = new JTextPane();
    private final DefaultStyledDocument doc = new DefaultStyledDocument();
    private final JLabel testResult = new JLabel("Abc");
    private final LinkLabel infoText = new LinkLabel("", null);
    private final JTextArea parseResult = new JTextArea();
    private final JTabbedPane tabs = new JTabbedPane();
    private final ItemFields itemFields;
    private final MutableAttributeSet matchAttr1 = new SimpleAttributeSet();
    private final MutableAttributeSet matchAttr2 = new SimpleAttributeSet();
    private final MutableAttributeSet defaultAttr = new SimpleAttributeSet();
    private final MutableAttributeSet blacklistAttr = new SimpleAttributeSet();
    private final String type;
    private boolean editingBlacklistItem;
    private boolean allowEmpty;
    private String result;
    private ActionListener addToBlacklistListener;
    private String prevTestText;
    private Replacer2.Result substitutionResult;
    private Highlighter.HighlightItem highlightItem;
    private Highlighter.HighlightItem blacklistItem;
    private static final Border EDITING_BORDER;
    private static final Border DEFAULT_BORDER;
    private String lastSetInfo;
    public static final String TEST_INFO = "<html><body style='width:300px;font-weight:normal;'>Quick reference (see [help-settings:Highlight help] for more):<ul style='margin-left:30px'><li><code>Bets open</code> - 'Bets open' anywhere in the message<li><code>cs:Bets open</code> - Same, but case-sensitive</li><li><code>w:Clip</code> - 'Clip' as a word, so e.g. not 'Clipped'</li><li><code>wcs:Clip</code> - Same, but case-sensitive</li><li><code>start:!slot</code> - Message beginning with '!slot'</li><li><code>reg:(?i)^!\\w+$</code> - Regular expression (Regex)</li></ul>Meta prefixes (in front of text matching):<ul style='margin-left:30px'><li><code>chan:joshimuz</code> - Restrict to channel 'joshimuz'</li><li><code>user:Elorie</code> - Restrict to user 'Elorie'</li><li><code>cat:vip</code> - Restrict to users in category 'vip'</li><li><code>config:info</code> - Match info messages</li></ul>";

    public HighlighterTester(Window owner, boolean showBlacklist, String type) {
        super(owner);
        this.type = type;
        this.setTitle("Test and Edit");
        StyleConstants.setBackground(this.matchAttr1, Color.BLUE);
        StyleConstants.setForeground(this.matchAttr1, Color.WHITE);
        StyleConstants.setBackground(this.matchAttr2, new Color(0, 140, 100));
        StyleConstants.setForeground(this.matchAttr2, Color.WHITE);
        StyleConstants.setStrikeThrough(this.blacklistAttr, true);
        this.setLayout(new GridBagLayout());
        Insets leftInsets = new Insets(5, 16, 5, 5);
        ScrollPanel base = new ScrollPanel(new GridBagLayout());
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 1, 1, 17);
        gbc.insets = new Insets(10, 5, 0, 5);
        main.add((Component)new JLabel("Full " + type + " item:"), gbc);
        gbc = GuiUtil.makeGbc(1, 1, 1, 1, 13);
        gbc.insets = new Insets(10, 5, 0, 5);
        main.add((Component)new JLabel("(You may edit it here or below.)"), gbc);
        gbc = GuiUtil.makeGbc(0, 2, 2, 1);
        gbc.fill = 2;
        gbc.insets = leftInsets;
        gbc.weightx = 1.0;
        this.itemValue.setFont(Font.decode("Monospaced"));
        GuiUtil.installLengthLimitDocumentFilter(this.itemValue, 50000, false, new Object[0]);
        main.add((Component)this.itemValue, gbc);
        this.itemFields = new ItemFields(this.itemValue);
        this.itemFields.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        gbc = GuiUtil.makeGbc(0, 4, 2, 1);
        gbc.insets = leftInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        main.add((Component)this.itemFields, gbc);
        if (showBlacklist) {
            gbc = GuiUtil.makeGbc(0, 11, 2, 1, 21);
            gbc.insets = new Insets(10, 5, 0, 5);
            JLabel blacklistLabel = new JLabel("Blacklist item:");
            blacklistLabel.setToolTipText(SettingsUtil.addTooltipLinebreaks("You can enter a single blacklist item here to test how it would affect text matches if it were on the blacklist."));
            main.add((Component)blacklistLabel, gbc);
            gbc = GuiUtil.makeGbc(0, 12, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = leftInsets;
            this.blacklistValue.setFont(Font.decode("Monospaced"));
            GuiUtil.installLengthLimitDocumentFilter(this.blacklistValue, 50000, false, new Object[0]);
            main.add((Component)this.blacklistValue, gbc);
            gbc = GuiUtil.makeGbc(0, 13, 2, 1);
            gbc.insets = new Insets(0, 5, 4, 5);
            GuiUtil.smallButtonInsets(this.addToBlacklistButton);
            main.add((Component)this.addToBlacklistButton, gbc);
            this.addToBlacklistButton.setVisible(false);
            this.addToBlacklistButton.addActionListener(e -> {
                if (this.addToBlacklistListener != null) {
                    this.addToBlacklistListener.actionPerformed(new ActionEvent(this.addToBlacklistButton, 1001, this.blacklistValue.getText()));
                    this.addToBlacklistButton.setEnabled(false);
                }
            });
        }
        gbc = GuiUtil.makeGbc(0, 14, 1, 1, 17);
        gbc.insets = new Insets(10, 5, 0, 5);
        JLabel testLabel = new JLabel("Test text:");
        testLabel.setToolTipText("Non-text requirements are ignored for testing.");
        main.add((Component)testLabel, gbc);
        gbc = GuiUtil.makeGbc(0, 15, 2, 1);
        gbc.insets = leftInsets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.testInput.setDocument(this.doc);
        this.testInput.setFont(Font.decode("Monospaced"));
        this.testInput.setBorder(this.itemValue.getBorder());
        GuiUtil.resetFocusTraversalKeys(this.testInput);
        GuiUtil.installLengthLimitDocumentFilter(this.testInput, 1000, false, new Object[0]);
        main.add((Component)this.testInput, gbc);
        gbc = GuiUtil.makeGbc(0, 16, 2, 1, 17);
        gbc.insets = leftInsets;
        main.add((Component)this.testResult, gbc);
        gbc = GuiUtil.makeGbc(0, 10, 2, 1);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 4, 0, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        base.add((Component)main, gbc);
        this.okButton.setMnemonic(83);
        this.cancelButton.setMnemonic(67);
        gbc = GuiUtil.makeGbc(0, 21, 1, 1, 13);
        gbc.weightx = 1.0;
        this.add((Component)this.okButton, gbc);
        this.add((Component)this.cancelButton, GuiUtil.makeGbc(1, 21, 1, 1, 13));
        JPanel helpPanel = new JPanel();
        helpPanel.add(this.infoText);
        JPanel parseResultPanel = new JPanel(new BorderLayout());
        JLabel parseResultInfo = new JLabel("<html><body style='width:370px;font-weight:normal;'>Shows parsing information and the requirements for a match (each line's condition has to be satisified).");
        parseResultInfo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        parseResultPanel.add((Component)parseResultInfo, "North");
        parseResultPanel.add((Component)new JScrollPane(this.parseResult), "Center");
        this.parseResult.setFont(new Font("Monospaced", 0, this.parseResult.getFont().getSize()));
        this.parseResult.setEditable(false);
        this.parseResult.setLineWrap(true);
        this.parseResult.setWrapStyleWord(true);
        this.tabs.add("Help", helpPanel);
        this.tabs.add("Parse Result", parseResultPanel);
        gbc = GuiUtil.makeGbc(0, 20, 3, 1, 10);
        gbc.insets = new Insets(10, 5, 5, 5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        base.add((Component)this.tabs, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 2, 1);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JScrollPane baseScroll = new JScrollPane(base);
        baseScroll.setBorder(null);
        this.add((Component)baseScroll, gbc);
        this.okButton.addActionListener(e -> {
            this.result = this.editingBlacklistItem ? this.blacklistValue.getText() : this.itemValue.getText();
            this.setVisible(false);
        });
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        this.doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                fb.insertString(offset, StringUtil.removeLinebreakCharacters(string), attr);
                HighlighterTester.this.updateMatches((DefaultStyledDocument)fb.getDocument());
                HighlighterTester.this.updateInfoText();
                HighlighterTester.this.updateParseResult();
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                fb.remove(offset, length);
                HighlighterTester.this.updateMatches((DefaultStyledDocument)fb.getDocument());
                HighlighterTester.this.updateInfoText();
                HighlighterTester.this.updateParseResult();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                fb.replace(offset, length, StringUtil.removeLinebreakCharacters(text), attrs);
                HighlighterTester.this.updateMatches((DefaultStyledDocument)fb.getDocument());
                HighlighterTester.this.updateInfoText();
                HighlighterTester.this.updateParseResult();
            }
        });
        HighlighterTester.addDocumentListener(this.itemValue, e -> this.updateItem());
        HighlighterTester.addDocumentListener(this.blacklistValue, e -> this.updateBlacklistItem());
        this.updateEditIndicator();
        this.updateSaveButton();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(this.getPreferredSize().width, 200));
    }

    private static void addDocumentListener(JTextField textField, final Consumer<DocumentEvent> action) {
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                action.accept(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                action.accept(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                action.accept(e);
            }
        });
    }

    private Highlighter.HighlightItem createItem(String value) {
        String typeSuffix = this.editingBlacklistItem ? "Blacklist" : "";
        return new Highlighter.HighlightItem(value, this.type + typeSuffix, false, testPresets != null ? testPresets : new HashMap());
    }

    private String getTestText() {
        String text = this.testInput.getText();
        if (this.type.equals("highlight")) {
            if (substitutesItem != null && this.highlightItem != null && this.highlightItem.substitutesEnabled(substitutesDefault)) {
                this.substitutionResult = substitutesItem.replace(text);
                if (this.substitutionResult != null) {
                    text = this.substitutionResult.getChangedText();
                }
            } else {
                this.substitutionResult = null;
            }
        }
        return text;
    }

    private void updateItem() {
        String value = this.itemValue.getText();
        this.highlightItem = value.isEmpty() ? null : this.createItem(value);
        this.updateInfoText();
        this.updateMatches(this.doc);
        this.updateSaveButton();
        this.updateTestText();
        this.updateParseResult();
        this.itemFields.update();
    }

    private void updateBlacklistItem() {
        String value = this.blacklistValue.getText();
        if (value.isEmpty()) {
            this.blacklistItem = null;
            this.addToBlacklistButton.setEnabled(false);
        } else {
            this.blacklistItem = this.createItem(value);
            this.addToBlacklistButton.setEnabled(!this.blacklistItem.hasError());
        }
        this.updateInfoText();
        this.updateMatches(this.doc);
        this.updateSaveButton();
        this.updateTestText();
        this.updateParseResult();
    }

    public void updateParseResult() {
        String text = "";
        boolean warningIcon = false;
        if (this.highlightItem != null) {
            if (this.highlightItem.patternThrowsError()) {
                warningIcon = true;
            }
            if (this.highlightItem.getMainPrefix() == null && this.highlightItem.getTextWithoutPrefix().matches("^\\+?!?\\w+:.*")) {
                text = text + "[!] The beginning of the text has the format of a prefix (even though it's not one as of yet), so to keep it safe for the future, it is recommended to prefix 'text:' (or another Text Matching Prefix) to indicate no more prefixes are to come:\n\n text:" + this.highlightItem.getTextWithoutPrefix() + "\n\n";
                warningIcon = true;
            }
        }
        if (warningIcon) {
            int size = this.tabs.getFontMetrics(this.tabs.getFont()).getHeight();
            Icon icon = GuiUtil.getFallbackIcon(UIManager.getIcon("OptionPane.warningIcon"), MainGui.class, "warning.png");
            this.tabs.setIconAt(1, GuiUtil.getScaledIcon(icon, size, size));
        } else {
            this.tabs.setIconAt(1, null);
        }
        if (this.highlightItem != null) {
            text = text + this.highlightItem.getMatchInfo();
        }
        if (this.blacklistItem != null) {
            text = text + "\n### Blacklist ###\n" + this.blacklistItem.getMatchInfo();
        }
        if (this.substitutionResult != null) {
            text = text + "---\nTest text after applying substitutes: " + this.substitutionResult.getChangedText();
        }
        this.parseResult.setText(text);
    }

    private void updateInfoText() {
        Highlighter.Blacklist blacklist = null;
        if (this.blacklistItem != null) {
            blacklist = new Highlighter.Blacklist(Highlighter.HighlightItem.Type.ANY, this.getTestText(), -2, -2, null, null, null, null, MsgTags.EMPTY, Arrays.asList(this.blacklistItem));
        }
        if (this.highlightItem == null) {
            this.testResult.setText("Empty item.");
        } else if (this.highlightItem.hasError()) {
            this.testResult.setText("Error: " + this.highlightItem.getError());
        } else if (this.highlightItem.matchesTextOnly(this.getTestText(), blacklist)) {
            this.testResult.setText("Matched.");
        } else {
            String failedReason = this.highlightItem.getFailedReason();
            if (failedReason == null) {
                this.testResult.setText("No match.");
            } else {
                this.testResult.setText("No match: " + failedReason);
            }
            if (this.highlightItem.hasMatchingError()) {
                this.testResult.setText("Error: " + this.highlightItem.getMatchingError());
            }
        }
        if (this.blacklistItem != null && this.blacklistItem.hasError()) {
            this.testResult.setText("Blacklist error: " + this.blacklistItem.getError());
        }
    }

    private void updateMatches(StyledDocument doc) {
        try {
            Highlighter.Match m;
            int i;
            List<Highlighter.Match> matches;
            doc.setCharacterAttributes(0, doc.getLength(), this.defaultAttr, true);
            if (this.highlightItem != null && (matches = this.highlightItem.getTextMatches(this.getTestText(), -2, -2, this.substitutionResult)) != null) {
                for (i = 0; i < matches.size(); ++i) {
                    m = matches.get(i);
                    if (i % 2 == 0) {
                        doc.setCharacterAttributes(m.start, m.end - m.start, this.matchAttr1, false);
                        continue;
                    }
                    doc.setCharacterAttributes(m.start, m.end - m.start, this.matchAttr2, false);
                }
            }
            if (this.blacklistItem != null) {
                List<Highlighter.Match> blacklistMatches = this.blacklistItem.getTextMatches(this.getTestText(), -2, -2, this.substitutionResult);
                if (blacklistMatches != null) {
                    for (i = 0; i < blacklistMatches.size(); ++i) {
                        m = blacklistMatches.get(i);
                        doc.setCharacterAttributes(m.start, m.end - m.start, this.blacklistAttr, false);
                    }
                } else if (this.blacklistItem.matchesTextOnly(this.getTestText(), null)) {
                    doc.setCharacterAttributes(0, doc.getLength(), this.blacklistAttr, false);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setEditingBlacklistItem(boolean editingBlacklistItem) {
        this.editingBlacklistItem = editingBlacklistItem;
        this.updateEditIndicator();
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    private void updateEditIndicator() {
        if (this.editingBlacklistItem) {
            this.blacklistValue.setBorder(EDITING_BORDER);
            this.itemValue.setBorder(DEFAULT_BORDER);
        } else {
            this.blacklistValue.setBorder(DEFAULT_BORDER);
            this.itemValue.setBorder(EDITING_BORDER);
        }
    }

    private void updateTestText() {
        boolean matches;
        Highlighter.HighlightItem item = this.editingBlacklistItem ? this.blacklistItem : this.highlightItem;
        boolean bl = matches = item != null && item.matchesAny(this.getTestText(), null);
        if (!matches && (this.testInput.getText().isEmpty() || this.testInput.getText().equals(this.prevTestText))) {
            if (item != null && item.getTextWithoutPrefix().length() < 20) {
                this.testInput.setText(TEST_PRESET_EXAMPLE + item.getTextWithoutPrefix());
            } else {
                this.testInput.setText(TEST_PRESET);
            }
            this.prevTestText = this.testInput.getText();
        }
    }

    private void updateSaveButton() {
        if (this.editingBlacklistItem) {
            this.okButton.setEnabled(this.blacklistItem != null && !this.blacklistItem.hasError());
        } else {
            this.okButton.setEnabled(this.highlightItem != null && !this.highlightItem.hasError() || this.allowEmpty);
        }
    }

    @Override
    public String showDialog(String title, String preset, String info) {
        if (this.editingBlacklistItem) {
            this.blacklistValue.requestFocusInWindow();
        } else {
            this.itemValue.requestFocusInWindow();
        }
        this.setTitle(title);
        this.result = null;
        if (!Objects.equals(this.lastSetInfo, info)) {
            this.infoText.setText(info);
            this.lastSetInfo = info;
            this.revalidate();
            this.pack();
        }
        this.itemValue.setText(null);
        this.blacklistValue.setText(null);
        this.parseResult.setText(null);
        SwingUtilities.invokeLater(() -> {
            this.setMinimumSize(new Dimension(this.getPreferredSize().width, 200));
            if (this.editingBlacklistItem) {
                this.blacklistValue.setText(preset);
            } else {
                this.itemValue.setText(preset);
            }
            this.updateItem();
            this.updateBlacklistItem();
            this.updateTestText();
        });
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.result;
    }

    @Override
    public void setLinkLabelListener(LinkLabelListener listener) {
        this.infoText.setListener(listener);
        this.itemFields.setLinkLabelListener(listener);
    }

    public void setAddToBlacklistListener(ActionListener listener) {
        this.addToBlacklistListener = listener;
        if (listener != null) {
            this.addToBlacklistButton.setVisible(true);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            testPresets = Highlighter.HighlightItem.makePresets(Arrays.asList("_test $replace($1-,$\"\\\\!\",$\"[\\W_]*?\",reg)"));
            HighlighterTester tester = new HighlighterTester(null, true, "highlight");
            tester.setAddToBlacklistListener(e -> System.out.println(e));
            tester.setEditingBlacklistItem(false);
            System.out.println(tester.showDialog("Highlight Item", "!start:abc", TEST_INFO));
            System.exit(0);
        });
    }

    static {
        EDITING_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(1, 2, 1, 2));
        DEFAULT_BORDER = new JTextField().getBorder();
    }

    private static class ItemFields
    extends JPanel {
        private final JTextComponent item;
        private final JTextField metaPrefixes = new JTextField();
        private final LinkLabel metaPrefixesLabel;
        private final JLabel metaPrefixesError = new JLabel();
        private final LinkLabel textMatchLabel;
        private final JTextField mainPrefix;
        private final JTextField mainText = new JTextField();
        private final MatchOptions matchOptions = new MatchOptions();
        private boolean updating;

        ItemFields(JTextComponent item) {
            this.item = item;
            this.setLayout(new GridBagLayout());
            JPanel metaPrefixesLabelPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 4, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.metaPrefixesLabel = new LinkLabel("[help-settings:Highlight_Meta_Matching Meta Prefixes:]", null);
            this.metaPrefixesLabel.setMargin(null);
            metaPrefixesLabelPanel.add((Component)this.metaPrefixesLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 4, 1, 1);
            gbc.insets = new Insets(0, 0, 0, 0);
            metaPrefixesLabelPanel.add((Component)this.metaPrefixesError, gbc);
            gbc = GuiUtil.makeGbc(0, 4, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)metaPrefixesLabelPanel, gbc);
            gbc = GuiUtil.makeGbc(0, 5, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.metaPrefixes.setFont(Font.decode("Monospaced"));
            this.add((Component)this.metaPrefixes, gbc);
            gbc = GuiUtil.makeGbc(0, 7, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.textMatchLabel = new LinkLabel("[help-settings:Highlight_Matching Text Match:]", null);
            this.textMatchLabel.setMargin(null);
            this.add((Component)this.textMatchLabel, gbc);
            JPanel textMatchPanel = new JPanel();
            textMatchPanel.setLayout(new GridBagLayout());
            gbc = GuiUtil.makeGbc(0, 0, 1, 1);
            this.mainPrefix = new JTextField(8){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.mainPrefix.setFont(Font.decode("Monospaced"));
            this.mainPrefix.setEditable(false);
            textMatchPanel.add((Component)this.mainPrefix, gbc);
            gbc = GuiUtil.makeGbc(1, 0, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.mainText.setFont(Font.decode("Monospaced"));
            textMatchPanel.add((Component)this.mainText, gbc);
            gbc = GuiUtil.makeGbc(0, 8, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)textMatchPanel, gbc);
            gbc = GuiUtil.makeGbc(0, 9, 2, 1);
            gbc.insets = new Insets(0, 0, 5, 5);
            gbc.anchor = 17;
            this.add((Component)this.matchOptions, gbc);
            this.matchOptions.setListener(p -> {
                if (p != null) {
                    this.mainPrefix.setText((String)p);
                    this.constructValue();
                }
            });
            HighlighterTester.addDocumentListener(this.metaPrefixes, e -> this.constructValue());
            HighlighterTester.addDocumentListener(this.mainText, e -> this.constructValue());
        }

        private void constructValue() {
            if (this.updating) {
                return;
            }
            this.updating = true;
            Highlighter.HighlightItem metaItem = new Highlighter.HighlightItem(this.metaPrefixes.getText(), "", false, null);
            String mPrefixes = metaItem.getMetaPrefixes();
            String mPrefixesExtra = metaItem.getRaw().substring(metaItem.getMetaPrefixes().length()).trim();
            String newValue = mPrefixes;
            if (!mPrefixesExtra.isEmpty()) {
                this.metaPrefixesError.setText("Not a meta prefix: " + StringUtil.shortenTo(mPrefixesExtra, 20));
            } else {
                this.metaPrefixesError.setText(null);
            }
            String main = "";
            if (!this.mainText.getText().trim().isEmpty()) {
                main = this.mainPrefix.getText() + this.mainText.getText();
            }
            newValue = StringUtil.append(newValue, " ", main);
            this.item.setText(newValue);
            this.updating = false;
        }

        public void setLinkLabelListener(LinkLabelListener listener) {
            this.metaPrefixesLabel.setListener(listener);
            this.textMatchLabel.setListener(listener);
        }

        public void update() {
            if (this.updating) {
                return;
            }
            Highlighter.HighlightItem i = new Highlighter.HighlightItem(this.item.getText(), "", false, null);
            this.updating = true;
            String mPrefix = i.getMainPrefix();
            if (StringUtil.isNullOrEmpty(mPrefix)) {
                mPrefix = "text:";
            }
            this.mainPrefix.setText(mPrefix);
            this.matchOptions.setPrefix(mPrefix);
            this.mainText.setText(i.getTextWithoutPrefix());
            this.metaPrefixes.setText(i.getMetaPrefixes());
            this.updating = false;
        }
    }

    private static class MatchOptions
    extends JPanel {
        private static final int OTHER = 16;
        private final JCheckBox regex = new JCheckBox("Regex");
        private final JCheckBox caseSensitive = new JCheckBox("Case-sensitive");
        private final JCheckBox word = new JCheckBox("Word");
        private final JCheckBox start = new JCheckBox("Start");
        private final JCheckBox inverted = new JCheckBox("Inverted");
        private final JCheckBox other = new JCheckBox("Other");
        private final List<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        private Consumer<String> listener;
        private boolean setInProgress;
        private String lastSetPrefix;

        MatchOptions() {
            this.setLayout(new FlowLayout(3, 5, 0));
            this.regex.setToolTipText(SettingsUtil.addTooltipLinebreaks("Use Regular Expressions"));
            this.caseSensitive.setToolTipText(SettingsUtil.addTooltipLinebreaks("Case-sentitive text matching (e.g. 'Test' would not be the same as 'TEST')"));
            this.word.setToolTipText(SettingsUtil.addTooltipLinebreaks("The beginning and end must be at a word boundary (e.g. 'w:test' would match 'This is a test!' but not 'This is testing!')"));
            this.start.setToolTipText(SettingsUtil.addTooltipLinebreaks("The text must be at the beginning of the message (e.g. 'start:!quote' would match when '!quote' is at the beginning of the message)"));
            this.inverted.setToolTipText(SettingsUtil.addTooltipLinebreaks("The match is inverted (e.g. '!start:quote' would match when there is no '!quote' at the beginning of the message)"));
            this.other.setToolTipText(SettingsUtil.addTooltipLinebreaks("This is checked when prefixes that can't be selected here are used (unchecking switches the prefix and allows you to use the other checkboxes again)"));
            this.add(this.regex);
            this.add(this.caseSensitive);
            this.add(this.word);
            this.add(this.start);
            this.add(this.inverted);
            this.add(this.other);
            this.checkboxes.add(this.start);
            this.checkboxes.add(this.word);
            this.checkboxes.add(this.caseSensitive);
            this.checkboxes.add(this.regex);
            this.checkboxes.add(this.other);
            for (JCheckBox check : this.checkboxes) {
                check.addItemListener(e -> this.updateSelected());
            }
            this.inverted.addItemListener(e -> this.updateSelected());
        }

        private void updateSelected() {
            if (this.listener != null && !this.setInProgress) {
                this.updateDisabled();
                this.listener.accept(this.getPrefix());
            }
        }

        private void setSelectedOptions(int selected) {
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                this.checkboxes.get(i).setSelected((selected & 1 << i) != 0);
            }
            this.updateDisabled();
        }

        private void updateDisabled() {
            int enabled;
            this.setInProgress = true;
            int possibleOptions = enabled = this.getSelectedOptions();
            for (Prefix option : Prefix.values()) {
                if ((option.options & enabled) != enabled) continue;
                possibleOptions |= option.options;
            }
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                boolean optionPossible = (possibleOptions & 1 << i) != 0;
                this.checkboxes.get(i).setEnabled(optionPossible);
                if (optionPossible) continue;
                this.checkboxes.get(i).setSelected(false);
            }
            this.setInProgress = false;
        }

        private int getSelectedOptions() {
            int selected = 0;
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                selected += this.checkboxes.get(i).isSelected() ? 1 << i : 0;
            }
            return selected;
        }

        public void setPrefix(String prefix) {
            this.setInProgress = true;
            this.inverted.setSelected(prefix.startsWith("!"));
            this.lastSetPrefix = prefix = prefix.startsWith("!") ? prefix.substring(1) : prefix;
            boolean prefixFound = false;
            for (Prefix p : Prefix.values()) {
                if (!p.name.equals(prefix)) continue;
                this.setSelectedOptions(p.options);
                prefixFound = true;
            }
            if (!prefixFound) {
                this.setSelectedOptions(16);
            }
            this.setInProgress = false;
        }

        public String getPrefix() {
            String result = this.lastSetPrefix;
            int selectedOptions = this.getSelectedOptions();
            for (Prefix p : Prefix.values()) {
                if (p.options != selectedOptions) continue;
                result = p.name;
            }
            return this.inverted.isSelected() ? "!" + result : result;
        }

        public void setListener(Consumer<String> listener) {
            this.listener = listener;
        }

        private static enum Prefix {
            TEXT("text:", 0),
            CS("cs:", 4),
            W("w:", 2),
            WCS("wcs:", 6),
            START("start:", 1),
            STARTW("startw:", 3),
            REG("reg:", 12),
            REGI("regi:", 8),
            REGW("regw:", 14),
            REGWI("regwi:", 10);

            public final String name;
            public final int options;

            private Prefix(String prefix, int options) {
                this.name = prefix;
                this.options = options;
            }
        }
    }
}

