/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ChannelFormatter;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HistorySettings
extends SettingsPanel
implements ActionListener {
    private final JButton clearHistory = new JButton("Clear history");
    private final SettingsDialog d;

    public HistorySettings(SettingsDialog d) {
        this.d = d;
        JPanel main = this.addTitledPanel("Channel History (shown in the Favorites/History Dialog)", 0);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        main.add((Component)d.addSimpleBooleanSetting("saveChannelHistory", "Enable History", "If enabled, automatically add joined channels to the history"), gbc);
        JPanel days = new JPanel();
        ((FlowLayout)days.getLayout()).setVgap(0);
        days.add(d.addSimpleBooleanSetting("historyClear", "Only keep channels joined in the last ", ""));
        days.add(d.addSimpleLongSetting("channelHistoryKeepDays", 3, true));
        days.add(new JLabel("days"));
        gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 20, 5, 5);
        main.add((Component)days, gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 1, 1);
        gbc.insets = new Insets(5, 20, 10, 5);
        main.add((Component)new JLabel("<html><body style='width: 280px'>Expired entries (defined as per the setting above) are automatically deleted from the history when you start Chatty."), gbc);
        gbc = SettingsDialog.makeGbc(0, 4, 1, 1);
        gbc.anchor = 17;
        main.add((Component)this.clearHistory, gbc);
        this.clearHistory.addActionListener(this);
        JPanel presets = this.addTitledPanel("Status Presets (shown in the Presets in the Admin Dialog)", 1);
        gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        presets.add((Component)d.addSimpleBooleanSetting("saveStatusHistory", "Enable History", "If enabled, automatically add used status (title/game) to the history"), gbc);
        JPanel daysPresets = new JPanel();
        ((FlowLayout)daysPresets.getLayout()).setVgap(0);
        daysPresets.add(d.addSimpleBooleanSetting("statusHistoryClear", "Only keep entries used in the last ", "Whether to remove old status history entries."));
        daysPresets.add(d.addSimpleLongSetting("statusHistoryKeepDays", 3, true));
        daysPresets.add(new JLabel("days"));
        gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 20, 5, 5);
        presets.add((Component)daysPresets, gbc);
        JPanel externalHistory = this.addTitledPanel("History Service", 2);
        externalHistory.add((Component)new LinkLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>Chatty uses the [url:https://recent-messages.robotty.de recent-messages.robotty.de] API to get messages of the last 24 hours when joining a channel.", d.getLinkLabelListener()), SettingsDialog.makeGbc(0, 0, 2, 1, 11));
        SimpleBooleanSetting historyServiceEnabled = d.addSimpleBooleanSetting("historyServiceEnabled", "Enable History Service", "Use an external service to get the channel history");
        externalHistory.add((Component)historyServiceEnabled, SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        ComboLongSetting historyServiceLimit = d.addComboLongSetting("historyServiceLimit", 5, 10, 15, 20, 30, 40, 50, 60, 70, 80, 90, 100);
        SettingsUtil.addStandardSetting(externalHistory, "historyServiceLimit", 2, historyServiceLimit, true);
        String matchOptionsTip = "Using the matching prefix \"config:historic2\" will allow the match even for features that are disabled here, while \"config:historic\" does the same but will restrict the match to history messages only.";
        JLabel matchOptionsLabel = new JLabel("Allow for history messages:");
        matchOptionsLabel.setToolTipText(SettingsUtil.addTooltipLinebreaks(matchOptionsTip));
        externalHistory.add((Component)matchOptionsLabel, SettingsDialog.makeGbcSub2(0, 3, 2, 1, 17));
        JPanel matchOptions = new JPanel();
        matchOptions.add(d.addSimpleBooleanSetting("historyMessageHighlight", Language.getString("settings.page.highlight"), matchOptionsTip));
        matchOptions.add(d.addSimpleBooleanSetting("historyMessageIgnore", Language.getString("settings.page.ignore"), matchOptionsTip));
        matchOptions.add(d.addSimpleBooleanSetting("historyMessageMsgColors", Language.getString("settings.page.msgColors"), matchOptionsTip));
        matchOptions.add(d.addSimpleBooleanSetting("historyMessageRouting", "Routing", matchOptionsTip));
        matchOptions.add(d.addSimpleBooleanSetting("historyMessageNotifications", Language.getString("settings.page.notifications"), matchOptionsTip));
        externalHistory.add((Component)matchOptions, SettingsDialog.makeGbcSub2(0, 4, 2, 1, 17));
        externalHistory.add((Component)new JLabel("Excluded channels:"), SettingsDialog.makeGbcSub2(0, 5, 2, 1, 17));
        ListSelector excludedChannels = d.addListSetting("historyServiceExcluded", "Channel to be excluded from history", 250, 200, false, true);
        ChannelFormatter formatter = new ChannelFormatter();
        excludedChannels.setDataFormatter(formatter);
        externalHistory.add((Component)excludedChannels, SettingsDialog.makeGbcSub2(0, 6, 2, 1, 17));
        SettingsUtil.addSubsettings(historyServiceEnabled, historyServiceLimit, excludedChannels);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        if (e.getSource() == this.clearHistory && (result = JOptionPane.showConfirmDialog(this, "Do you want to delete all history entries?", "Clear history", 0, 3)) == 0) {
            this.d.clearHistory();
        }
    }
}

