/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.lang.Language;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class HotkeyDialog {
    private final JDialog dialog = new JDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), Language.getString("settings.hotkeys.key.set.title"));
    private KeyStroke hotkey;

    public HotkeyDialog() {
        this.dialog.setModal(true);
        this.dialog.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27 && e.getModifiers() == 0) {
                    HotkeyDialog.this.dialog.setVisible(false);
                    return;
                }
                HotkeyDialog.this.hotkey = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                HotkeyDialog.this.dialog.setVisible(false);
                e.consume();
            }
        });
        this.dialog.setFocusTraversalKeysEnabled(false);
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        JLabel info = new JLabel(Language.getString("settings.hotkeys.key.set.info"));
        info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.add(info);
        this.dialog.pack();
    }

    private KeyStroke getKeyStrokeInternal() {
        this.dialog.setVisible(true);
        return this.hotkey;
    }

    public static KeyStroke getKeyStroke() {
        return new HotkeyDialog().getKeyStrokeInternal();
    }
}

