/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.HotkeyTextField;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.LongTextField;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.commands.CommandSyntaxHighlighter;
import chatty.util.commands.CustomCommand;
import chatty.util.hotkeys.Hotkey;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HotkeyEditor
extends TableEditor<Hotkey> {
    private static final Set<String> RECOMMENDED_APPLICATION_ACTIONS = new HashSet<String>(Arrays.asList("about"));
    private static final Set<String> RECOMMENDED_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("dialog.toggleTransparency"));
    private MyItemEditor itemEditor;
    public final MyTableModel data = new MyTableModel();
    private final Set<KeyStroke> conflictWarning = new HashSet<KeyStroke>();
    private Map<String, String> actions;
    private Map<String, String> descriptions;
    private boolean globalHotkeysAvailable;

    public HotkeyEditor(JDialog owner, final Consumer<Hotkey> globalHotkeyCheck, final TableEditor.TableEditorListener<Hotkey> tableListener) {
        super(1, false);
        this.setModel(this.data);
        this.setItemEditor(() -> {
            if (this.itemEditor == null) {
                this.itemEditor = new MyItemEditor(owner, k -> this.getExistingHotkey((KeyStroke)k));
                this.itemEditor.setActions(this.actions);
                this.itemEditor.setDescriptions(this.descriptions);
                this.itemEditor.setGlobalHotkeysAvailable(this.globalHotkeysAvailable);
            }
            return this.itemEditor;
        });
        this.setFixedColumnWidth(2, 60);
        this.setTableEditorListener(new TableEditor.TableEditorListener<Hotkey>(){

            @Override
            public void itemAdded(Hotkey item) {
                HotkeyEditor.this.updateConflicts();
                globalHotkeyCheck.accept(item);
                tableListener.itemAdded(item);
            }

            @Override
            public void itemRemoved(Hotkey item) {
                HotkeyEditor.this.updateConflicts();
                tableListener.itemRemoved(item);
            }

            @Override
            public void itemEdited(Hotkey oldItem, Hotkey newItem) {
                HotkeyEditor.this.updateConflicts();
                globalHotkeyCheck.accept(newItem);
                tableListener.itemEdited(oldItem, newItem);
            }

            @Override
            public void allItemsChanged(List<Hotkey> newItems) {
                HotkeyEditor.this.updateConflicts();
                tableListener.allItemsChanged(newItems);
            }

            @Override
            public void itemsSet() {
                HotkeyEditor.this.updateConflicts();
                tableListener.itemsSet();
            }

            @Override
            public void refreshData() {
            }
        });
    }

    public Hotkey getExistingHotkey(KeyStroke keyStroke) {
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            Hotkey hotkey = (Hotkey)this.data.get(i);
            if (!hotkey.keyStroke.equals(keyStroke)) continue;
            return hotkey;
        }
        return null;
    }

    public void updateConflicts() {
        this.conflictWarning.clear();
        HashSet<KeyStroke> usedKeys = new HashSet<KeyStroke>();
        for (Hotkey hotkey : this.data.getData()) {
            if (usedKeys.contains(hotkey.keyStroke)) {
                this.conflictWarning.add(hotkey.keyStroke);
            }
            usedKeys.add(hotkey.keyStroke);
        }
        this.repaint();
    }

    public void setData(Map<String, String> actions, Map<String, String> descriptions, List<Hotkey> hotkeys, boolean globalHotkeysAvailable) {
        this.data.setActions(actions);
        this.setData(hotkeys);
        if (this.itemEditor != null) {
            this.itemEditor.setActions(actions);
            this.itemEditor.setDescriptions(descriptions);
            this.itemEditor.setGlobalHotkeysAvailable(globalHotkeysAvailable);
        } else {
            this.actions = actions;
            this.descriptions = descriptions;
            this.globalHotkeysAvailable = globalHotkeysAvailable;
        }
    }

    public void addHotkey(Hotkey hotkey) {
        this.data.add(hotkey);
    }

    public void edit(String id) {
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            Hotkey hotkey = (Hotkey)this.data.get(i);
            if (!hotkey.actionId.equals(id)) continue;
            this.editItem(i);
            return;
        }
        this.addItem(new Hotkey(id, null, Hotkey.Type.GLOBAL, null, 0));
    }

    private class MyTableModel
    extends ListTableModel<Hotkey> {
        private Map<String, String> actions;

        public MyTableModel() {
            super(new String[]{"Action", "Hotkey", "Type"});
            this.actions = new HashMap<String, String>();
        }

        public void setActions(Map<String, String> actions) {
            this.actions = new HashMap<String, String>(actions);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Hotkey hotkey = (Hotkey)this.get(rowIndex);
            if (columnIndex == 0) {
                String action = this.actions.get(hotkey.actionId);
                if (hotkey.custom != null && !hotkey.custom.isEmpty()) {
                    action = action + " (" + hotkey.custom + ")";
                }
                return action;
            }
            if (columnIndex == 1) {
                if (HotkeyEditor.this.conflictWarning.contains(hotkey.keyStroke)) {
                    return ((Hotkey)this.get(rowIndex)).getHotkeyText() + " (duplicate)";
                }
                return ((Hotkey)this.get(rowIndex)).getHotkeyText();
            }
            return ((Hotkey)this.get((int)rowIndex)).type.name;
        }

        public Class getColumnClass(int c) {
            return String.class;
        }
    }

    public static class MyItemEditor
    implements TableEditor.ItemEditor<Hotkey> {
        private static final String GLOBAL_HOTKEY_WARNING_GENERAL = "<br /><br />This message will not be shown again this session.";
        private static final String GLOBAL_HOTKEY_WARNING_VERSION = "<html><body style='width:300px;'>Global Hotkey feature is not available in this version, so global hotkeys will not work.<br /><br />This message will not be shown again this session.";
        private static final String GLOBAL_HOTKEY_WARNING_ERROR = "<html><body style='width:300px;'>Global Hotkey feature was not initialized properly, so global hotkeys will not work.<br /><br />This message will not be shown again this session.";
        private final JDialog dialog;
        private final ComboStringSetting actionId = new ComboStringSetting(new String[0]);
        private final JTextField custom = new JTextField();
        private final EditorStringSetting anonymousCustomCommand;
        private final JLabel description = new JLabel();
        private final HotkeyTextField hotkeyChooser;
        private final JLabel hotkeyInfo = new JLabel();
        private final LongTextField delay;
        private KeyStroke currentHotkey;
        private boolean globalHotkeysAvailable;
        private boolean globalHotkeysAvailableWarningShown;
        private final Function<KeyStroke, Hotkey> getExistingHotkey;
        private Map<String, String> actionNames;
        private Map<String, String> descriptions;
        private Hotkey preset;
        private final JRadioButton regular = new JRadioButton("Regular");
        private final JRadioButton applicationWide = new JRadioButton("Application");
        private final JRadioButton global = new JRadioButton("Global");
        private final JLabel scopeTip = new JLabel();
        private final JButton ok = new JButton("Done");
        private final JButton cancel = new JButton("Cancel");

        public MyItemEditor(JDialog owner, Function<KeyStroke, Hotkey> getExistingHotkey) {
            this.getExistingHotkey = getExistingHotkey;
            this.delay = new LongTextField(4, true);
            this.hotkeyChooser = new HotkeyTextField(12, new HotkeyTextField.HotkeyEditListener(){

                @Override
                public void hotkeyChanged(KeyStroke newHotkey) {
                    currentHotkey = newHotkey;
                    this.updateButtons();
                }

                @Override
                public void hotkeyEntered(KeyStroke newHotkey) {
                    Hotkey hotkey = this.getHotkeyForKeyStroke(newHotkey);
                    if (hotkey != null && hotkey != preset) {
                        String action = (String)actionNames.get(hotkey.actionId);
                        String message = "Used already: " + action;
                        hotkeyInfo.setText(message);
                        dialog.pack();
                        JOptionPane.showMessageDialog(dialog, "Hotkey already used for action: " + action);
                    } else {
                        hotkeyInfo.setText(null);
                        dialog.pack();
                    }
                }
            });
            this.custom.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateButtons();
                }
            });
            this.anonymousCustomCommand = new EditorStringSetting(owner, "Anonymous Custom Command", 10, false, false, "", new Editor.Tester(){

                @Override
                public String test(Window parent, Component component, int x, int y, String value) {
                    CustomCommand command = CustomCommand.parse(value);
                    CommandSettings.showCommandInfoPopup(component, command);
                    return null;
                }
            });
            this.anonymousCustomCommand.setInfo("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>Enter the command to execute, for example <code>/echo Currently open channels are: $(chans)</code>.");
            this.anonymousCustomCommand.setShowInfoByDefault(true);
            this.anonymousCustomCommand.setSettingValue("");
            this.anonymousCustomCommand.setChangeListener(e -> this.updateButtons());
            this.anonymousCustomCommand.setSyntaxHighlighter(new CommandSyntaxHighlighter());
            this.dialog = new JDialog(owner);
            this.dialog.setTitle("Edit Item");
            this.dialog.setModal(true);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ok) {
                        dialog.setVisible(false);
                    } else if (e.getSource() == cancel) {
                        currentHotkey = null;
                        dialog.setVisible(false);
                    } else if (e.getSource() == actionId) {
                        this.updateButtons();
                        this.updateDescription();
                    } else if (e.getSource() == global) {
                        this.checkForGlobalHotkeyWarning();
                    }
                }
            };
            this.ok.addActionListener(listener);
            this.cancel.addActionListener(listener);
            this.actionId.addActionListener(listener);
            this.global.addActionListener(listener);
            this.regular.setToolTipText("Hotkey that can only be triggered if the focus is on the Chatty main window");
            this.applicationWide.setToolTipText("Hotkey that can be triggered anywhere in Chatty");
            this.global.setToolTipText("Hotkey that can be triggered globally on your computer");
            ButtonGroup scopeSelection = new ButtonGroup();
            scopeSelection.add(this.regular);
            scopeSelection.add(this.applicationWide);
            scopeSelection.add(this.global);
            JPanel scopeSelectionPanel = new JPanel();
            ((FlowLayout)scopeSelectionPanel.getLayout()).setVgap(0);
            scopeSelectionPanel.add(this.regular);
            scopeSelectionPanel.add(this.applicationWide);
            scopeSelectionPanel.add(this.global);
            this.dialog.setLayout(new GridBagLayout());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
            JLabel actionLabel = new JLabel(Language.getString("settings.hotkeys.action"));
            actionLabel.setLabelFor(this.actionId);
            this.dialog.add((Component)actionLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 0, 4, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.actionId, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 4, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.custom, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 4, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.anonymousCustomCommand, gbc);
            gbc = GuiUtil.makeGbc(1, 2, 4, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.description, gbc);
            gbc = GuiUtil.makeGbc(0, 3, 1, 1);
            JLabel hotkeyLabel = new JLabel("Hotkey:");
            hotkeyLabel.setLabelFor(this.hotkeyChooser);
            this.dialog.add((Component)hotkeyLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 3, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.hotkeyChooser, gbc);
            gbc = GuiUtil.makeGbc(1, 4, 4, 1);
            gbc.anchor = 17;
            this.hotkeyInfo.setForeground(Color.red);
            gbc.insets = new Insets(-1, 5, 3, 5);
            this.dialog.add((Component)this.hotkeyInfo, gbc);
            gbc = GuiUtil.makeGbc(1, 5, 3, 1);
            gbc.anchor = 17;
            this.dialog.add((Component)scopeSelectionPanel, gbc);
            gbc = GuiUtil.makeGbc(1, 6, 3, 1);
            gbc.anchor = 17;
            gbc.insets = new Insets(-1, 5, 7, 5);
            this.dialog.add((Component)this.scopeTip, gbc);
            JLabel delayLabel = new JLabel(Language.getString("settings.hotkeys.delay"));
            delayLabel.setToolTipText(Language.getString("settings.hotkeys.delay.tip"));
            delayLabel.setLabelFor(this.delay);
            gbc = GuiUtil.makeGbc(0, 7, 1, 1);
            gbc.anchor = 17;
            this.dialog.add((Component)delayLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 7, 1, 1);
            gbc.anchor = 17;
            this.dialog.add((Component)this.delay, gbc);
            gbc = GuiUtil.makeGbc(1, 8, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.ok, gbc);
            gbc = GuiUtil.makeGbc(3, 8, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.1;
            this.dialog.add((Component)this.cancel, gbc);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }

        @Override
        public Hotkey showEditor(Hotkey preset, Component c, boolean edit, int column) {
            this.preset = preset;
            if (edit) {
                this.dialog.setTitle("Edit hotkey");
            } else {
                this.dialog.setTitle("Add hotkey");
            }
            this.dialog.setLocationRelativeTo(c);
            if (preset != null) {
                this.actionId.setSettingValue(preset.actionId);
                this.hotkeyChooser.setHotkey(preset.keyStroke);
                this.setCustom(preset.custom);
                this.delay.setText("" + preset.delay);
                this.setHotkeyType(preset.type);
            } else {
                this.actionId.setSettingValue(null);
                this.hotkeyChooser.setHotkey(null);
                this.setCustom("");
                this.delay.setText("0");
                this.setHotkeyType(null);
            }
            if (!this.actionId.isEnabled()) {
                this.dialog.setTitle(this.dialog.getTitle() + ": " + this.actionId.getSelectedItem());
            }
            this.hotkeyInfo.setText(null);
            this.dialog.pack();
            this.updateButtons();
            this.dialog.setVisible(true);
            if (this.actionId.getSettingValue() != null && this.currentHotkey != null) {
                String action = this.actionId.getSettingValue();
                return new Hotkey(action, this.currentHotkey, this.getHotkeyType(), this.getCustom(), this.getDelay());
            }
            return null;
        }

        private boolean isAnonCommand() {
            return "custom.anonCommand".equals(this.actionId.getSettingValue());
        }

        private void setCustom(String text) {
            if (this.isAnonCommand()) {
                this.anonymousCustomCommand.setSettingValue(text);
                this.custom.setText("");
            } else {
                this.anonymousCustomCommand.setSettingValue("");
                this.custom.setText(text);
            }
        }

        private String getCustom() {
            if (this.isAnonCommand()) {
                return this.anonymousCustomCommand.getSettingValue();
            }
            return this.custom.getText();
        }

        private int getDelay() {
            try {
                return Integer.parseInt(this.delay.getText());
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }

        private void setHotkeyType(Hotkey.Type type) {
            if (type == Hotkey.Type.APPLICATION) {
                this.applicationWide.setSelected(true);
            } else if (type == Hotkey.Type.GLOBAL) {
                this.global.setSelected(true);
            } else {
                this.regular.setSelected(true);
            }
        }

        public Hotkey.Type getHotkeyType() {
            if (this.applicationWide.isSelected()) {
                return Hotkey.Type.APPLICATION;
            }
            if (this.global.isSelected()) {
                return Hotkey.Type.GLOBAL;
            }
            return Hotkey.Type.REGULAR;
        }

        private void updateButtons() {
            String action = this.actionId.getSettingValue();
            boolean customEnabled = action != null && (action.startsWith("custom.") || action.equals("tabs.switch"));
            boolean anonCustom = this.isAnonCommand();
            this.custom.setEnabled(customEnabled);
            this.custom.setEditable(customEnabled);
            this.custom.setVisible(!anonCustom);
            this.anonymousCustomCommand.setVisible(anonCustom);
            if (action != null && RECOMMENDED_GLOBAL_ACTIONS.contains(action)) {
                this.scopeTip.setVisible(true);
                this.scopeTip.setText("Global scope recommended for this action");
            } else if (action != null && (action.startsWith("dialog.") || RECOMMENDED_APPLICATION_ACTIONS.contains(action))) {
                this.scopeTip.setVisible(true);
                this.scopeTip.setText("Application scope recommended for this action");
            } else {
                this.scopeTip.setVisible(false);
            }
            this.dialog.pack();
            boolean enabled = this.actionId.getSettingValue() != null && this.currentHotkey != null && (!customEnabled || !this.getCustom().isEmpty());
            this.ok.setEnabled(enabled);
        }

        private void updateDescription() {
            if (this.descriptions == null) {
                return;
            }
            String text = this.descriptions.get(this.actionId.getSettingValue());
            this.description.setVisible(!StringUtil.isNullOrEmpty(text));
            if (text != null) {
                this.description.setText("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + text);
            }
            GuiUtil.packKeepCenter(this.dialog);
        }

        private void checkForGlobalHotkeyWarning() {
            if (this.global.isSelected() && !this.globalHotkeysAvailable && !this.globalHotkeysAvailableWarningShown) {
                JOptionPane.showMessageDialog(this.dialog, GLOBAL_HOTKEY_WARNING_ERROR, "Global Hotkeys not available", 2);
                this.globalHotkeysAvailableWarningShown = true;
            }
        }

        public void setFixedAction() {
            this.actionId.setEnabled(false);
        }

        public void setActions(Map<String, String> actions) {
            this.actionId.clear();
            if (actions.size() > 1) {
                this.actionId.add((String)null, "--Select Action--");
            }
            this.actionId.addData(actions);
            this.actionNames = actions;
            this.dialog.pack();
        }

        public void setDescriptions(Map<String, String> descriptions) {
            this.descriptions = descriptions;
            this.updateDescription();
        }

        public void setGlobalHotkeysAvailable(boolean available) {
            this.globalHotkeysAvailable = available;
        }

        private Hotkey getHotkeyForKeyStroke(KeyStroke keyStroke) {
            return this.getExistingHotkey.apply(keyStroke);
        }
    }
}

