/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.HotkeyEditor;
import chatty.lang.Language;
import chatty.util.hotkeys.Hotkey;
import java.awt.Component;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotkeyPanel
extends JPanel {
    private final JTextField hotkeyField = new JTextField(20);
    private final JButton editButton = new JButton("Edit");
    private final JButton removeButton = new JButton("Remove");
    private Hotkey currentHotkey;
    private Map<String, String> actions;

    public HotkeyPanel(JDialog owner, String actionId, Hotkey.Type type, Function<KeyStroke, Hotkey> getExistingHotkey, HotkeyHelperListener listener) {
        this.currentHotkey = new Hotkey(actionId, null, type, null, 1);
        this.add(this.hotkeyField);
        this.add(this.editButton);
        this.add(this.removeButton);
        this.hotkeyField.setEditable(false);
        this.editButton.addActionListener(e -> {
            HotkeyEditor.MyItemEditor editor = new HotkeyEditor.MyItemEditor(owner, getExistingHotkey);
            editor.setActions(this.actions);
            editor.setFixedAction();
            Hotkey edited = editor.showEditor(this.currentHotkey, (Component)this.hotkeyField, true, 0);
            if (edited != null) {
                listener.changeHotkey(this.currentHotkey, edited);
                this.updateHotkey(this.currentHotkey, edited);
            }
        });
        this.removeButton.addActionListener(e -> {
            if (this.currentHotkey.keyStroke != null) {
                listener.deleteHotkey(this.currentHotkey);
                this.setCurrentHotkey(null);
            }
        });
        this.updateState();
    }

    public void updateHotkey(Hotkey current, Hotkey changed) {
        if (current == null) {
            if (changed.actionId.equals(this.currentHotkey.actionId)) {
                this.setCurrentHotkey(changed);
            }
        } else if (current.actionId.equals(this.currentHotkey.actionId)) {
            if (this.currentHotkey.keyStroke == null) {
                this.setCurrentHotkey(changed);
            } else if (this.currentHotkey.keyStroke.equals(current.keyStroke)) {
                this.setCurrentHotkey(changed);
            }
        }
    }

    public void setActions(Map<String, String> actions) {
        this.actions = actions;
    }

    private void setCurrentHotkey(Hotkey hotkey) {
        this.currentHotkey = hotkey == null ? new Hotkey(this.currentHotkey.actionId, null, this.currentHotkey.type, null, this.currentHotkey.delay) : hotkey;
        this.updateState();
    }

    private void updateState() {
        if (this.currentHotkey == null || this.currentHotkey.keyStroke == null) {
            this.hotkeyField.setText(Language.getString("settings.hotkeys.key.empty"));
            this.removeButton.setEnabled(false);
        } else {
            this.hotkeyField.setText(this.currentHotkey.getHotkeyText());
            this.removeButton.setEnabled(true);
        }
    }

    public static interface HotkeyHelperListener {
        public void changeHotkey(Hotkey var1, Hotkey var2);

        public void deleteHotkey(Hotkey var1);
    }
}

