/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.HotkeyEditor;
import chatty.gui.components.settings.HotkeyPanel;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.TableEditor;
import chatty.util.hotkeys.Hotkey;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class HotkeySettings
extends SettingsPanel {
    private final SettingsDialog d;
    private final HotkeyEditor data;
    private final List<HotkeyPanel> hotkeyPanels = new ArrayList<HotkeyPanel>();

    public HotkeySettings(SettingsDialog d) {
        super(true);
        this.d = d;
        JPanel main = this.addTitledPanel("Hotkeys", 0, true);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.anchor = 17;
        main.add((Component)d.addSimpleBooleanSetting("globalHotkeysEnabled", "Enable global hotkeys", "Enable or disable currently defined global hotkeys"), gbc);
        JButton addTabSwitchKeys = new JButton(String.format("<html><body>Add <kbd>%s</kbd> to <kbd>%s</kbd> for switching tabs", Hotkey.keyStrokeToText(KeyStroke.getKeyStroke("ctrl 1")), Hotkey.keyStrokeToText(KeyStroke.getKeyStroke("ctrl 9"))));
        addTabSwitchKeys.setToolTipText("Add hotkeys to directly switch to a tab index in the active tab pane");
        GuiUtil.smallButtonInsets(addTabSwitchKeys);
        gbc = SettingsDialog.makeGbc(1, 1, 1, 1);
        gbc.insets = new Insets(5, 5, 5, 30);
        gbc.anchor = 13;
        main.add((Component)addTabSwitchKeys, gbc);
        this.data = new HotkeyEditor(d, item -> {
            if (item.type == Hotkey.Type.GLOBAL && !d.getBooleanSettingValue("globalHotkeysEnabled").booleanValue()) {
                JOptionPane.showMessageDialog(d, "You have added a global hotkey, but global hotkeys are currently disabled (see setting at bottom).");
            }
        }, new TableEditor.TableEditorListener<Hotkey>(){

            @Override
            public void itemAdded(Hotkey item) {
                HotkeySettings.this.updateHotkeyPanel(null, item);
            }

            @Override
            public void itemRemoved(Hotkey item) {
                HotkeySettings.this.updateHotkeyPanel(item, null);
            }

            @Override
            public void itemEdited(Hotkey oldItem, Hotkey newItem) {
                HotkeySettings.this.updateHotkeyPanel(oldItem, newItem);
            }

            @Override
            public void allItemsChanged(List<Hotkey> newItems) {
            }

            @Override
            public void itemsSet() {
            }

            @Override
            public void refreshData() {
            }
        });
        this.data.setPreferredSize(new Dimension(1, 270));
        gbc = SettingsDialog.makeGbc(0, 0, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        main.add((Component)this.data, gbc);
        addTabSwitchKeys.addActionListener(e -> {
            List hotkeys = this.data.getData();
            for (int i = 1; i <= 9; ++i) {
                Hotkey hotkey = new Hotkey("tabs.switch", KeyStroke.getKeyStroke("ctrl " + i), Hotkey.Type.APPLICATION, String.valueOf(i), 0);
                boolean actionAlreadyExists = false;
                for (Hotkey existingHotkey : hotkeys) {
                    if (!existingHotkey.actionId.equals(hotkey.actionId) || !existingHotkey.custom.equals(hotkey.custom)) continue;
                    actionAlreadyExists = true;
                }
                if (actionAlreadyExists) continue;
                this.data.addHotkey(hotkey);
            }
            this.data.updateConflicts();
        });
    }

    public void setData(Map<String, String> actions, Map<String, String> descriptions, List<Hotkey> hotkeys, boolean globalHotkeysAvailable) {
        this.data.setData(actions, descriptions, hotkeys, globalHotkeysAvailable);
        for (Hotkey hotkey : hotkeys) {
            this.updateHotkeyPanel(null, hotkey);
        }
        for (HotkeyPanel panel : this.hotkeyPanels) {
            panel.setActions(actions);
        }
    }

    public List<Hotkey> getData() {
        return this.data.getData();
    }

    public void edit(String id) {
        this.data.edit(id);
    }

    public HotkeyPanel createHotkeyPanel(String actionId, Hotkey.Type type) {
        HotkeyPanel panel = new HotkeyPanel(this.d, actionId, type, k -> this.data.getExistingHotkey((KeyStroke)k), new HotkeyPanel.HotkeyHelperListener(){

            @Override
            public void changeHotkey(Hotkey current, Hotkey changed) {
                List<Hotkey> currentHotkeys = HotkeySettings.this.getData();
                Hotkey toRemove = HotkeySettings.this.getMatchingHotkey(currentHotkeys, current);
                if (toRemove != null) {
                    currentHotkeys.remove(toRemove);
                }
                currentHotkeys.add(changed);
                HotkeySettings.this.data.setData(currentHotkeys);
            }

            @Override
            public void deleteHotkey(Hotkey current) {
                List<Hotkey> currentHotkeys = HotkeySettings.this.getData();
                Hotkey toRemove = HotkeySettings.this.getMatchingHotkey(currentHotkeys, current);
                if (toRemove != null) {
                    currentHotkeys.remove(toRemove);
                    HotkeySettings.this.data.setData(currentHotkeys);
                }
            }
        });
        this.hotkeyPanels.add(panel);
        return panel;
    }

    private Hotkey getMatchingHotkey(Collection<Hotkey> hotkeys, Hotkey search) {
        for (Hotkey hotkey : hotkeys) {
            if (!hotkey.actionId.equals(search.actionId) || !hotkey.keyStroke.equals(search.keyStroke)) continue;
            return hotkey;
        }
        return null;
    }

    private void updateHotkeyPanel(Hotkey current, Hotkey changed) {
        for (HotkeyPanel panel : this.hotkeyPanels) {
            panel.updateHotkey(current, changed);
        }
    }
}

