/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.HotkeyDialog;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import chatty.util.hotkeys.Hotkey;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotkeyTextField
extends JPanel
implements StringSetting {
    private final HotkeyEditListener listener;
    private final JTextField textField;
    private KeyStroke hotkey;

    public HotkeyTextField(int size, HotkeyEditListener listener) {
        this.listener = listener;
        this.textField = new JTextField(size);
        this.textField.setEditable(false);
        this.textField.getAccessibleContext().setAccessibleDescription("");
        JButton setButton = new JButton("Set");
        setButton.addActionListener(e -> {
            KeyStroke keyStroke = HotkeyDialog.getKeyStroke();
            if (keyStroke != null) {
                this.setHotkey(keyStroke);
                if (listener != null) {
                    listener.hotkeyEntered(keyStroke);
                }
            }
        });
        setButton.setMargin(GuiUtil.SMALLER_BUTTON_INSETS);
        GuiUtil.matchHeight(setButton, this.textField);
        setButton.setToolTipText(Language.getString("settings.hotkeys.key.button.set"));
        JButton resetButton = new JButton("Remove");
        resetButton.addActionListener(e -> this.setHotkey(null));
        resetButton.setMargin(GuiUtil.SMALLER_BUTTON_INSETS);
        GuiUtil.matchHeight(resetButton, this.textField);
        resetButton.setToolTipText(Language.getString("settings.hotkeys.key.button.clear"));
        this.setLayout(new FlowLayout(3, 0, 0));
        this.add(this.textField);
        this.add(setButton);
        this.add(resetButton);
    }

    public void setHotkey(KeyStroke hotkey) {
        this.hotkey = hotkey;
        if (hotkey != null) {
            this.textField.setText(Hotkey.keyStrokeToText(hotkey));
            this.textField.setToolTipText(String.format("Key Code: %1$d (0x%1$X)", hotkey.getKeyCode()));
        } else {
            this.textField.setText(Language.getString("settings.hotkeys.key.empty"));
        }
        if (this.listener != null) {
            this.listener.hotkeyChanged(hotkey);
        }
    }

    public KeyStroke getHotkey() {
        return this.hotkey;
    }

    @Override
    public String getSettingValue() {
        if (this.hotkey == null) {
            return "";
        }
        return this.hotkey.toString();
    }

    @Override
    public void setSettingValue(String value) {
        this.setHotkey(KeyStroke.getKeyStroke(value));
    }

    public static interface HotkeyEditListener {
        public void hotkeyChanged(KeyStroke var1);

        public void hotkeyEntered(KeyStroke var1);
    }
}

