/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.HighlightBlacklist;
import chatty.gui.components.settings.HighlightSettings;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IgnoreSettings
extends SettingsPanel {
    private final ListSelector items;
    private final IgnoredUsers ignoredUsers;

    public IgnoreSettings(SettingsDialog d) {
        super(true);
        this.ignoredUsers = new IgnoredUsers(d);
        HighlightBlacklist blacklist = new HighlightBlacklist(d, "ignore", "ignoreBlacklist");
        JPanel base = this.addTitledPanel("Ignore Messages", 0, true);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        SimpleBooleanSetting ignoredEnabled = d.addSimpleBooleanSetting("ignoreEnabled");
        base.add((Component)ignoredEnabled, gbc);
        gbc = SettingsDialog.makeGbc(2, 1, 1, 1, 13);
        gbc.weightx = 1.0;
        base.add((Component)new JLabel("Ignore Hints:"), gbc);
        final SimpleBooleanSetting ignoreShowNotDialog = d.addSimpleBooleanSetting("ignoreShowNotDialog", "Only show if ignored messages dialog is not open", "");
        HashMap<Long, String> modeDef = new HashMap<Long, String>();
        modeDef.put(0L, "Hide");
        modeDef.put(1L, "Show count");
        modeDef.put(2L, "Show names");
        final ComboLongSetting mode = new ComboLongSetting((Map<Long, String>)modeDef);
        mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Long)mode.getSettingValue() == 0L) {
                    ignoreShowNotDialog.setEnabled(false);
                } else if ((Long)mode.getSettingValue() == 1L) {
                    ignoreShowNotDialog.setEnabled(true);
                } else if ((Long)mode.getSettingValue() == 2L) {
                    ignoreShowNotDialog.setEnabled(true);
                }
            }
        });
        d.addLongSetting("ignoreMode", mode);
        gbc = SettingsDialog.makeGbc(3, 1, 1, 1);
        gbc.insets = new Insets(0, 12, 2, 5);
        gbc.anchor = 13;
        base.add((Component)mode, gbc);
        gbc = SettingsDialog.makeGbc(0, 2, 4, 1, 13);
        gbc.insets = new Insets(0, 5, 4, 4);
        base.add((Component)ignoreShowNotDialog, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 2, 1, 13);
        gbc.insets = new Insets(0, 12, 2, 5);
        SimpleBooleanSetting ignoreOwnText = d.addSimpleBooleanSetting("ignoreOwnText", "Check own text for ignoring", "If enabled, allows messages you wrote yourself to be ignored as well. Good for testing.");
        base.add((Component)ignoreOwnText, gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 4, 1);
        gbc.insets = new Insets(5, 10, 5, 5);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.items = d.addListSetting("ignore", "Ignore", 390, 160, true, true);
        this.items.setInfo(HighlightSettings.getMatchingHelp("ignore"));
        this.items.setInfoLinkLabelListener(d.getLinkLabelListener());
        this.items.setEditor(() -> {
            HighlighterTester tester = new HighlighterTester((Window)d, false, "ignore");
            tester.setLinkLabelListener(d.getLinkLabelListener());
            tester.setAddToBlacklistListener(e -> blacklist.addItem(e.getActionCommand()));
            return tester;
        });
        this.items.setDataFormatter(input -> input.trim());
        base.add((Component)this.items, gbc);
        SettingsUtil.addSubsettings(ignoredEnabled, ignoreOwnText, this.items);
        JButton ignoredUsersButton = new JButton("Ignored Users");
        GuiUtil.smallButtonInsets(ignoredUsersButton);
        ignoredUsersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoreSettings.this.ignoredUsers.show(IgnoreSettings.this);
            }
        });
        gbc = SettingsDialog.makeGbc(0, 4, 2, 1);
        gbc.insets = new Insets(1, 10, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        base.add((Component)ignoredUsersButton, gbc);
        JButton blacklistButton = new JButton("Ignore Blacklist");
        GuiUtil.smallButtonInsets(blacklistButton);
        blacklistButton.addActionListener(e -> blacklist.show(this));
        gbc = SettingsDialog.makeGbc(2, 4, 2, 1);
        gbc.insets = new Insets(1, 5, 5, 30);
        gbc.fill = 2;
        base.add((Component)blacklistButton, gbc);
    }

    public void selectItem(String item) {
        this.items.setSelected(item);
    }

    public void selectItems(Collection<String> selectItems) {
        this.items.setSelected(selectItems);
    }

    private static class IgnoredUsers
    extends LazyDialog {
        private final SettingsDialog d;
        private final ListSelector ignoredChat;
        private final ListSelector ignoredWhispers;
        private final JCheckBox hideIgnoredUsers;
        private static final DataFormatter<String> FORMATTER = new DataFormatter<String>(){

            @Override
            public String format(String input) {
                return StringUtil.toLowerCase(input.replaceAll("\\s", ""));
            }
        };

        public IgnoredUsers(SettingsDialog d) {
            this.d = d;
            this.ignoredChat = d.addListSetting("ignoredUsers", "Ignored User", 180, 250, false, true);
            this.ignoredWhispers = d.addListSetting("ignoredUsersWhisper", "Ignored User (Whisper)", 180, 250, false, true);
            this.hideIgnoredUsers = d.addSimpleBooleanSetting("ignoredUsersHideInGUI", "Hide 'Ignored in chat' users from the userlist/joins/parts", "This only applies to users that are not already on the userlist when you ignore them");
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(IgnoredUsers.this.d);
                this.setDefaultCloseOperation(1);
                this.setTitle("Ignored Users");
                this.setLayout(new GridBagLayout());
                IgnoredUsers.this.d;
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
                this.add((Component)new JLabel("Ignored in chat"), gbc);
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(1, 0, 1, 1);
                this.add((Component)new JLabel("Ignored for whispers"), gbc);
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 0.5;
                gbc.weighty = 1.0;
                IgnoredUsers.this.ignoredChat.setDataFormatter(FORMATTER);
                this.add((Component)IgnoredUsers.this.ignoredChat, gbc);
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(1, 1, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 0.5;
                gbc.weighty = 1.0;
                IgnoredUsers.this.ignoredWhispers.setDataFormatter(FORMATTER);
                this.add((Component)IgnoredUsers.this.ignoredWhispers, gbc);
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
                this.add((Component)new JLabel("<html><body style='width:260px;'>These lists are independant from the main ignore list, so the users are ignored even if the Ignore system is disabled."), gbc);
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 3, 2, 1);
                this.add((Component)IgnoredUsers.this.hideIgnoredUsers, gbc);
                JButton closeButton = new JButton("Close");
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.setVisible(false);
                    }
                });
                IgnoredUsers.this.d;
                gbc = SettingsDialog.makeGbc(0, 5, 2, 1);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.add((Component)closeButton, gbc);
                this.pack();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }
}

