/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.EmoteSettings;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.TableEditor;
import chatty.gui.components.settings.UsericonEditor;
import chatty.lang.Language;
import chatty.util.api.usericons.Usericon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImageSettings
extends SettingsPanel {
    private final UsericonEditor usericonsData;
    private final HiddenBadgesDialog hiddenBadgesDialog;

    public ImageSettings(SettingsDialog d) {
        super(true);
        JPanel usericons = this.addTitledPanel(Language.getString("settings.section.usericons"), 0, false);
        JPanel custom = this.addTitledPanel(Language.getString("settings.section.customUsericons"), 1, true);
        SimpleBooleanSetting usericonsEnabled = d.addSimpleBooleanSetting("usericonsEnabled");
        SimpleBooleanSetting botBadgeEnabled = d.addSimpleBooleanSetting("botBadgeEnabled");
        SimpleBooleanSetting customUsericonsEnabled = d.addSimpleBooleanSetting("customUsericonsEnabled");
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 2, 1, 17);
        usericons.add((Component)usericonsEnabled, gbc);
        gbc = SettingsDialog.makeGbc(2, 0, 1, 1, 17);
        usericons.add((Component)botBadgeEnabled, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 4, 1, 10);
        usericons.add((Component)new JLabel(Language.getString("settings.ffzBadgesInfo")), gbc);
        ComboLongSetting usericonScale = new ComboLongSetting(EmoteSettings.makeScaleValues());
        d.addLongSetting("usericonScale", usericonScale);
        SettingsUtil.addLabeledComponent(usericons, "usericonScale", 0, 2, 2, 17, usericonScale);
        ComboLongSetting customUsericonScaleMode = d.addComboLongSetting("customUsericonScaleMode", 0, 1, 2);
        d.addLongSetting("customUsericonScaleMode", customUsericonScaleMode);
        SettingsUtil.addLabeledComponent(usericons, "customUsericonScaleMode", 0, 3, 2, 17, customUsericonScaleMode);
        this.hiddenBadgesDialog = new HiddenBadgesDialog(d);
        JButton hiddenBadgesButton = new JButton("View Hidden Badges");
        GuiUtil.smallButtonInsets(hiddenBadgesButton);
        hiddenBadgesButton.addActionListener(e -> this.hiddenBadgesDialog.show(d));
        usericons.add((Component)hiddenBadgesButton, SettingsDialog.makeGbc(3, 0, 1, 1, 17));
        gbc = SettingsDialog.makeGbcSub(0, 1, 1, 1, 17);
        custom.add((Component)customUsericonsEnabled, gbc);
        this.usericonsData = new UsericonEditor(d, d.getLinkLabelListener());
        this.usericonsData.setPreferredSize(new Dimension(150, 250));
        gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        custom.add((Component)this.usericonsData, gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 2, 1, 17);
        custom.add((Component)new JLabel(Language.getString("settings.customUsericons.info")), gbc);
        SettingsUtil.addSubsettings(usericonsEnabled, customUsericonsEnabled, botBadgeEnabled);
        SettingsUtil.addSubsettings(customUsericonsEnabled, this.usericonsData);
    }

    public void setData(List<Usericon> data) {
        this.usericonsData.setData(data);
    }

    public void setTwitchBadgeTypes(Set<String> data) {
        this.usericonsData.setTwitchBadgeTypes(data);
    }

    public List<Usericon> getData() {
        return this.usericonsData.getData();
    }

    public void setHiddenBadgesData(Collection<Usericon> data) {
        this.hiddenBadgesDialog.setData(data);
    }

    public List<Usericon> getHiddenBadgesData() {
        return this.hiddenBadgesDialog.getData();
    }

    public void addUsericonOfBadgeType(Usericon.Type type, String idVersion) {
        this.usericonsData.addUsericonOfBadgeType(type, idVersion);
    }

    private static class HiddenBadgesDialog
    extends LazyDialog {
        private final SettingsDialog d;
        private final TableEditor<Usericon> editor;

        private HiddenBadgesDialog(SettingsDialog d) {
            this.d = d;
            this.editor = new TableEditor(1, false);
            this.editor.setItemEditor(() -> new TableEditor.ItemEditor<Usericon>(){

                @Override
                public Usericon showEditor(Usericon preset, Component c, boolean edit, int column) {
                    JOptionPane.showMessageDialog(c, "Badge types can be added through the Badge Context Menu (right-click on a Badge in chat).");
                    return null;
                }
            });
            this.editor.setModel(new ListTableModel<Usericon>(new String[]{"Badge Type"}){

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return ((Usericon)this.get(rowIndex)).readableLenientType();
                }
            });
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        public void setData(Collection<Usericon> data) {
            this.editor.setData(new ArrayList<Usericon>(data));
        }

        public List<Usericon> getData() {
            return this.editor.getData();
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(HiddenBadgesDialog.this.d);
                this.setTitle("Hidden Badges");
                this.setModal(true);
                this.setLayout(new GridBagLayout());
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
                this.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>All types of badges on this list won't show up in chat. Custom Badges always take precedence though, so if e.g. you have configured a custom Partner badge, then it may show up even if it is hidden here.<br /><br />It is also possible to add a Custom Badge with no image to hide a badge, which allows for more control over which badge should be hidden under what conditions."), gbc);
                gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                this.add((Component)HiddenBadgesDialog.this.editor, gbc);
                this.pack();
                GuiUtil.installEscapeCloseOperation(this);
            }
        }
    }
}

