/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.colors.ColorItem;
import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;

public class ItemColorEditor<T extends ColorItem>
extends TableEditor<T> {
    private final MyTableModel data;
    private final ItemCreator<T> itemCreator;
    private final ColorRenderer colorRenderer = new ColorRenderer();
    private MyItemEditor<T> editor;
    private Color defaultForeground;
    private Color defaultBackground;

    public ItemColorEditor(JDialog owner, ItemCreator<T> itemCreator, boolean editBackground, Component info) {
        super(0, false);
        this.itemCreator = itemCreator;
        this.data = new MyTableModel(editBackground);
        this.setModel(this.data);
        this.setItemEditor(() -> {
            if (this.editor == null) {
                this.editor = new MyItemEditor(owner, itemCreator, editBackground, info);
                this.editor.setDefaultForeground(this.defaultForeground);
                this.editor.setDefaultBackground(this.defaultBackground);
            }
            return this.editor;
        });
        this.setRendererForColumn(1, this.colorRenderer);
        if (editBackground) {
            this.setRendererForColumn(2, this.colorRenderer);
        }
    }

    public void edit(String item) {
        ColorItem preset = (ColorItem)this.itemCreator.createItem(item, Color.BLACK, true, Color.WHITE, true);
        int index = this.data.indexOf(preset);
        if (index == -1) {
            this.addItem(preset);
        } else {
            this.editItem(index);
        }
    }

    public void setSelected(String item) {
        ColorItem preset = (ColorItem)this.itemCreator.createItem(item, Color.BLACK, true, Color.WHITE, true);
        int index = this.data.indexOf(preset);
        if (index != -1) {
            super.selectItem(index);
        }
    }

    public void setDefaultForeground(Color color) {
        this.colorRenderer.setDefaultForeground(color);
        if (this.editor != null) {
            this.editor.setDefaultForeground(color);
        } else {
            this.defaultForeground = color;
        }
    }

    public void setDefaultBackground(Color color) {
        this.colorRenderer.setBackgroundColor(color);
        if (this.editor != null) {
            this.editor.setDefaultBackground(color);
        } else {
            this.defaultBackground = color;
        }
    }

    public static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private Color defaultForeground;
        private Color defaultBackground;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        public void setDefaultForeground(Color color) {
            this.defaultForeground = color;
        }

        public void setBackgroundColor(Color color) {
            this.defaultBackground = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String tooltip;
            String output;
            Color background;
            if (value == null) {
                return this;
            }
            ColorItem item = (ColorItem)value;
            Color foreground = item.getForegroundIfEnabled();
            if (foreground == null) {
                foreground = this.defaultForeground;
            }
            if ((background = item.getBackgroundIfEnabled()) == null) {
                background = this.defaultBackground;
            }
            this.setForeground(foreground);
            this.setBackground(background);
            Color settingColor = null;
            if (column == 1) {
                settingColor = item.getForegroundIfEnabled();
            } else if (column == 2) {
                settingColor = item.getBackgroundIfEnabled();
            }
            if (settingColor == null) {
                output = "(default)";
                tooltip = "Using default color";
            } else {
                output = HtmlColors.getNamedColorString(settingColor);
                tooltip = HtmlColors.getColorString(settingColor);
            }
            this.setText(output);
            this.setToolTipText(tooltip);
            return this;
        }
    }

    public static interface ItemCreator<T> {
        public T createItem(String var1, Color var2, boolean var3, Color var4, boolean var5);
    }

    private static class MyTableModel<T extends ColorItem>
    extends ListTableModel<T> {
        public MyTableModel(boolean editBackground) {
            super(new String[]{"Item", "Color"});
            if (editBackground) {
                this.setColumnNames(new String[]{Language.getString("settings.general.item"), Language.getString("settings.general.foreground"), Language.getString("settings.general.background")});
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.get(rowIndex);
        }

        @Override
        public String getSearchValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((ColorItem)this.get(rowIndex)).getId();
            }
            if (columnIndex == 1) {
                return HtmlColors.getNamedColorString(((ColorItem)this.get(rowIndex)).getForeground());
            }
            return HtmlColors.getNamedColorString(((ColorItem)this.get(rowIndex)).getBackground());
        }

        public Class getColumnClass(int c) {
            return ColorItem.class;
        }
    }

    public static class MyItemEditor<T extends ColorItem>
    implements TableEditor.ItemEditor<T> {
        private final ItemCreator<T> itemCreator;
        private final boolean editBackground;
        private final JDialog dialog;
        private final JTextField id = new JTextField(10);
        private final JButton changeColor = new JButton("Select Color");
        private final ColorSetting foreground;
        private final ColorSetting background;
        private final JCheckBox foregroundEnabled;
        private final JCheckBox backgroundEnabled;
        private final JButton ok = new JButton("Done");
        private final JButton cancel = new JButton("Cancel");
        private Color defaultForeground;
        private Color defaultBackground;
        boolean save;

        public MyItemEditor(JDialog owner, ItemCreator itemCreator, boolean editBackground, Component info) {
            this.itemCreator = itemCreator;
            this.editBackground = editBackground;
            this.dialog = new JDialog(owner);
            this.dialog.setTitle("Edit Item");
            this.dialog.setModal(true);
            this.id.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateButtons();
                }
            });
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ok) {
                        dialog.setVisible(false);
                        save = true;
                    } else if (e.getSource() == cancel) {
                        dialog.setVisible(false);
                    }
                }
            };
            this.changeColor.addActionListener(listener);
            this.ok.addActionListener(listener);
            this.cancel.addActionListener(listener);
            this.dialog.setLayout(new GridBagLayout());
            this.dialog.add((Component)new JLabel("Item:"), GuiUtil.makeGbc(0, 0, 1, 1));
            GridBagConstraints gbc = GuiUtil.makeGbc(1, 0, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)this.id, gbc);
            this.foreground = new ColorSetting(0, null, "Foreground", "Foreground Color", () -> new ColorChooser(owner));
            this.background = new ColorSetting(1, null, "Background", "Background Color", () -> new ColorChooser(owner));
            this.foregroundEnabled = new JCheckBox("Enabled");
            this.backgroundEnabled = new JCheckBox("Enabled");
            this.foreground.addListener(() -> this.updateColors());
            this.background.addListener(() -> this.updateColors());
            this.foregroundEnabled.addItemListener(e -> this.updateColors());
            this.backgroundEnabled.addItemListener(e -> this.updateColors());
            gbc = GuiUtil.makeGbc(1, 1, 2, 1);
            gbc.fill = 2;
            this.dialog.add((Component)this.foreground, gbc);
            if (editBackground) {
                gbc = GuiUtil.makeGbc(1, 2, 2, 1);
                gbc.fill = 2;
                this.dialog.add((Component)this.background, gbc);
                this.dialog.add((Component)this.foregroundEnabled, GuiUtil.makeGbc(0, 1, 1, 1));
                this.dialog.add((Component)this.backgroundEnabled, GuiUtil.makeGbc(0, 2, 1, 1));
            } else {
                this.backgroundEnabled.setSelected(false);
            }
            if (info != null) {
                gbc = GuiUtil.makeGbc(0, 3, 3, 1, 10);
                gbc.weightx = 1.0;
                this.dialog.add(info, gbc);
            }
            gbc = GuiUtil.makeGbc(1, 4, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.ok, gbc);
            gbc = GuiUtil.makeGbc(2, 4, 1, 1);
            this.dialog.add((Component)this.cancel, gbc);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }

        public void setDefaultForeground(Color color) {
            this.defaultForeground = color;
            this.updateColors();
        }

        public void setDefaultBackground(Color color) {
            this.defaultBackground = color;
            this.updateColors();
        }

        @Override
        public T showEditor(T preset, Component c, boolean edit, int column) {
            if (edit) {
                this.dialog.setTitle("Edit item");
            } else {
                this.dialog.setTitle("Add item");
            }
            this.dialog.setLocationRelativeTo(c);
            if (preset != null) {
                this.id.setText(((ColorItem)preset).getId());
                this.setColors(((ColorItem)preset).getForeground(), ((ColorItem)preset).getBackground());
                this.foregroundEnabled.setSelected(((ColorItem)preset).getForegroundEnabled());
                this.backgroundEnabled.setSelected(((ColorItem)preset).getBackgroundEnabled());
            } else {
                this.id.setText(null);
                this.setColors(this.defaultForeground, this.defaultBackground);
                this.foregroundEnabled.setSelected(true);
                this.backgroundEnabled.setSelected(true);
            }
            if (!this.editBackground) {
                this.background.setSettingValue(null);
                this.backgroundEnabled.setSelected(false);
            }
            this.updateColors();
            this.id.requestFocusInWindow();
            this.save = false;
            this.dialog.setVisible(true);
            if (!this.id.getText().isEmpty() && this.save) {
                return (T)((ColorItem)this.itemCreator.createItem(this.id.getText(), this.foreground.getSettingValueAsColor(), this.foregroundEnabled.isSelected(), this.background.getSettingValueAsColor(), this.backgroundEnabled.isSelected()));
            }
            return null;
        }

        private void setColors(Color foregroundColor, Color backgroundColor) {
            this.foreground.setSettingValue(HtmlColors.getNamedColorString(foregroundColor));
            this.background.setSettingValue(HtmlColors.getNamedColorString(backgroundColor));
        }

        private void updateColors() {
            if (this.foregroundEnabled.isSelected()) {
                this.background.setBaseColor(this.foreground.getSettingValue());
            } else {
                this.background.setBaseColor(this.defaultForeground);
            }
            if (this.backgroundEnabled.isSelected()) {
                this.foreground.setBaseColor(this.background.getSettingValue());
            } else {
                this.foreground.setBaseColor(this.defaultBackground);
            }
            this.background.setEnabled(this.backgroundEnabled.isSelected());
            this.foreground.setEnabled(this.foregroundEnabled.isSelected());
            this.updateButtons();
        }

        private void updateButtons() {
            boolean enabled = !(this.id.getText().isEmpty() || this.foreground.getSettingValue().isEmpty() && this.foregroundEnabled.isSelected() || this.background.getSettingValue().isEmpty() && this.backgroundEnabled.isSelected());
            this.ok.setEnabled(enabled);
        }
    }
}

