/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.ListSetting;
import chatty.gui.components.settings.StringEditor;
import chatty.lang.Language;
import chatty.util.SyntaxHighlighter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelector
extends JPanel
implements ListSetting<String> {
    private static final Dimension BUTTON_SIZE = new Dimension(27, 27);
    private final JList<String> list = new JList();
    private final DefaultListModel<String> data = new DefaultListModel();
    private final JButton add = new JButton();
    private final JButton remove = new JButton();
    private final JButton change = new JButton();
    private final JButton moveUp = new JButton();
    private final JButton moveDown = new JButton();
    private final JButton sort = new JButton();
    private final JButton editAll = new JButton();
    private final JTextField input = new JTextField();
    private final String title;
    private String info;
    private DataFormatter<String> formatter;
    private StringEditor editor;
    private Supplier<StringEditor> editorCreator;
    private Editor allEditor;
    private final Supplier<Editor> allEditorCreator;
    private LinkLabelListener linkLabelListener;
    private Editor.Tester tester;
    private SyntaxHighlighter syntaxHighlighter;
    private Consumer<List<String>> changeListener;

    public ListSelector(Window parent, String title, boolean manualSorting, boolean alphabeticSorting) {
        this.title = title;
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ListSelector.this.add || e.getSource() == ListSelector.this.input) {
                    ListSelector.this.addItem();
                } else if (e.getSource() == ListSelector.this.remove) {
                    ListSelector.this.removeItem();
                } else if (e.getSource() == ListSelector.this.change) {
                    ListSelector.this.changeItem();
                } else if (e.getSource() == ListSelector.this.moveUp) {
                    ListSelector.this.moveUp();
                } else if (e.getSource() == ListSelector.this.moveDown) {
                    ListSelector.this.moveDown();
                } else if (e.getSource() == ListSelector.this.sort) {
                    ListSelector.this.sort();
                } else if (e.getSource() == ListSelector.this.editAll) {
                    ListSelector.this.editAll();
                }
            }
        };
        this.list.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "removeItems");
        this.list.getActionMap().put("removeItems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelector.this.removeItem();
            }
        });
        this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "editItem");
        this.list.getActionMap().put("editItem", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelector.this.changeItem();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListSelector.this.changeItem();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelector.this.updateEditButtons();
            }
        });
        this.configureButton(this.add, "list-add.png", Language.getString("settings.listSelector.button.add.tip"));
        this.configureButton(this.remove, "list-remove.png", Language.getString("settings.listSelector.button.remove.tip"));
        this.configureButton(this.change, "edit.png", Language.getString("settings.listSelector.button.edit.tip"));
        this.configureButton(this.moveUp, "go-up.png", Language.getString("settings.listSelector.button.moveUp.tip"));
        this.configureButton(this.moveDown, "go-down.png", Language.getString("settings.listSelector.button.moveDown.tip"));
        this.configureButton(this.sort, "sort.png", Language.getString("settings.listSelector.button.sort.tip"));
        this.configureButton(this.editAll, "edit-all.png", Language.getString("settings.listSelector.button.editAll.tip"));
        this.add.addActionListener(buttonAction);
        this.remove.addActionListener(buttonAction);
        this.input.addActionListener(buttonAction);
        this.change.addActionListener(buttonAction);
        this.moveUp.addActionListener(buttonAction);
        this.moveDown.addActionListener(buttonAction);
        this.sort.addActionListener(buttonAction);
        this.editAll.addActionListener(buttonAction);
        this.list.setModel(this.data);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 1;
        this.add((Component)this.add, gbc);
        gbc.weightx = 0.0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.add((Component)this.remove, gbc);
        gbc.gridy = 2;
        this.add((Component)this.change, gbc);
        if (manualSorting) {
            gbc.gridy = 3;
            this.add((Component)this.moveUp, gbc);
            gbc.gridy = 4;
            this.add((Component)this.moveDown, gbc);
        }
        if (alphabeticSorting) {
            gbc.gridy = 5;
            this.add((Component)this.sort, gbc);
        }
        gbc.gridy = 6;
        this.add((Component)this.editAll, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 7;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list), gbc);
        this.updateEditButtons();
        this.editorCreator = () -> new Editor(parent);
        this.allEditorCreator = () -> {
            Editor e = new Editor(parent);
            e.setAllowLinebreaks(true);
            e.setAllowEmpty(true);
            return e;
        };
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setInfoLinkLabelListener(LinkLabelListener listener) {
        if (this.editor != null) {
            this.editor.setLinkLabelListener(listener);
        }
        if (this.allEditor != null) {
            this.allEditor.setLinkLabelListener(listener);
        }
        this.linkLabelListener = listener;
    }

    public void setTester(Editor.Tester tester) {
        if (this.editor instanceof Editor) {
            ((Editor)this.editor).setTester(tester);
        }
        this.tester = tester;
    }

    public void setEditor(Supplier<StringEditor> editorCreator) {
        this.editor = null;
        this.editorCreator = editorCreator;
    }

    private StringEditor getEditor() {
        if (this.editor == null) {
            this.editor = this.editorCreator.get();
            this.editor.setLinkLabelListener(this.linkLabelListener);
            if (this.editor instanceof Editor) {
                ((Editor)this.editor).setSyntaxHighlighter(this.syntaxHighlighter);
            }
            this.setTester(this.tester);
        }
        return this.editor;
    }

    private Editor getAllEditor() {
        if (this.allEditor == null) {
            this.allEditor = this.allEditorCreator.get();
            this.allEditor.setLinkLabelListener(this.linkLabelListener);
        }
        return this.allEditor;
    }

    private void configureButton(JButton button, String icon, String tooltip) {
        button.setIcon(new ImageIcon(ListSelector.class.getResource(icon)));
        button.setToolTipText(tooltip);
        button.setPreferredSize(BUTTON_SIZE);
        button.setSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        button.setMinimumSize(BUTTON_SIZE);
    }

    private void addItem() {
        String item = this.getEditor().showDialog(Language.getString("settings.listSelector.addEntry", this.title), "", this.info);
        if ((item = this.format(item)) != null && !item.isEmpty() && !this.data.contains(item)) {
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex != -1) {
                this.data.add(selectedIndex + 1, item);
                this.list.setSelectedValue(item, true);
            } else {
                this.data.addElement(item);
            }
            this.input.setText("");
        }
        this.informListener();
    }

    private void removeItem() {
        int selectedIndex = this.list.getSelectedIndex();
        for (String item : this.list.getSelectedValuesList()) {
            this.data.removeElement(item);
        }
        if (selectedIndex > -1) {
            if (selectedIndex < this.data.size()) {
                this.list.setSelectedValue(this.data.get(selectedIndex), true);
            } else if (selectedIndex > 0) {
                this.list.setSelectedValue(this.data.get(selectedIndex - 1), true);
            }
        }
        this.informListener();
    }

    private void changeItem() {
        String selectedValue = this.list.getSelectedValue();
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex > -1) {
            String newValue = this.getEditor().showDialog(Language.getString("settings.listSelector.editEntry", this.title), selectedValue, this.info);
            if ((newValue = this.format(newValue)) != null && !newValue.isEmpty()) {
                this.data.set(selectedIndex, newValue);
            }
        }
        this.informListener();
    }

    private void editAll() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.data.size(); ++i) {
            b.append(this.data.get(i)).append("\n");
        }
        String result = this.getAllEditor().showDialog(Language.getString("settings.listSelector.editAllEntries"), b.toString(), this.info);
        if (result != null) {
            String[] split = result.split("\n");
            this.data.clear();
            for (String item : split) {
                if ((item = this.format(item)) == null || item.isEmpty()) continue;
                this.data.addElement(item);
            }
        }
        this.informListener();
    }

    private void moveUp() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex > 0) {
            this.swap(selectedIndex, selectedIndex - 1);
            this.list.setSelectedValue(this.data.get(selectedIndex - 1), true);
        }
        this.informListener();
    }

    private void moveDown() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex > -1 && selectedIndex < this.data.size() - 1) {
            this.swap(selectedIndex, selectedIndex + 1);
            this.list.setSelectedValue(this.data.get(selectedIndex + 1), true);
        }
        this.informListener();
    }

    private void swap(int index1, int index2) {
        String temp = this.data.get(index2);
        this.data.set(index2, this.data.get(index1));
        this.data.set(index1, temp);
        this.informListener();
    }

    private void sort() {
        if (JOptionPane.showConfirmDialog(this.sort, Language.getString("settings.listSelector.sortEntries"), Language.getString("settings.listSelector.sortEntries.title"), 0) == 0) {
            List<String> sortData = this.getData();
            Collections.sort(sortData);
            this.setData(sortData);
        }
    }

    private void updateEditButtons() {
        boolean somethingIsSelected = this.list.getSelectedIndex() != -1 && this.isEnabled();
        boolean exactlyOneIsSelected = this.list.getSelectedIndices().length == 1 && this.isEnabled();
        this.remove.setEnabled(somethingIsSelected);
        this.change.setEnabled(exactlyOneIsSelected);
        this.moveUp.setEnabled(exactlyOneIsSelected);
        this.moveDown.setEnabled(exactlyOneIsSelected);
        this.add.setEnabled(this.isEnabled());
        this.sort.setEnabled(this.isEnabled());
        this.editAll.setEnabled(this.isEnabled());
    }

    public List<String> getData() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> e = this.data.elements();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public void setData(List<String> list) {
        this.data.clear();
        for (String item : list) {
            this.data.addElement(item);
        }
        this.informListener();
    }

    @Override
    public List<String> getSettingValue() {
        return this.getData();
    }

    @Override
    public void setSettingValue(List<String> value) {
        this.setData(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.input.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.updateEditButtons();
    }

    public void setDataFormatter(DataFormatter<String> formatter) {
        this.formatter = formatter;
    }

    public void setSyntaxHighlighter(SyntaxHighlighter highlighter) {
        if (highlighter == null) {
            return;
        }
        this.syntaxHighlighter = highlighter;
        if (this.editor instanceof Editor) {
            ((Editor)this.editor).setSyntaxHighlighter(highlighter);
        }
    }

    private String format(String input) {
        if (this.formatter != null && input != null) {
            return this.formatter.format(input);
        }
        return input;
    }

    public void setSelected(String item) {
        this.list.setSelectedValue(item, true);
    }

    public void setSelected(Collection<String> items) {
        this.list.clearSelection();
        if (items != null) {
            ArrayList<String> itemsReversed = new ArrayList<String>(items);
            Collections.reverse(itemsReversed);
            for (String item : itemsReversed) {
                int index = this.data.indexOf(item);
                if (index == -1) continue;
                this.list.addSelectionInterval(index, index);
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void setChangeListener(Consumer<List<String>> listener) {
        this.changeListener = listener;
    }

    private void informListener() {
        if (this.changeListener != null) {
            this.changeListener.accept(this.getData());
        }
    }
}

