/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ListTableModel<T>
extends AbstractTableModel {
    private String[] columnNames;
    private List<T> data = new ArrayList<T>();

    public ListTableModel(String[] columns) {
        this.columnNames = columns;
    }

    public void setColumnNames(String[] names) {
        this.columnNames = names;
    }

    public void setData(Collection<T> data) {
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.setData(null);
    }

    public List<T> getData() {
        return new ArrayList<T>(this.data);
    }

    public T get(int index) {
        return this.data.get(index);
    }

    public int add(T item) {
        this.data.add(item);
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        return this.data.size();
    }

    public void remove(T item) {
        int index = this.indexOf(item);
        if (index != -1) {
            this.remove(index);
        }
    }

    public void insert(int index, T item) {
        this.data.add(index, item);
        this.fireTableRowsInserted(index, index);
    }

    public void set(int index, T item) {
        this.data.set(index, item);
        this.fireTableRowsUpdated(index, index);
    }

    public boolean contains(T item) {
        return this.data.contains(item);
    }

    public int indexOf(T item) {
        return this.data.indexOf(item);
    }

    public void update(T item) {
        int present = this.indexOf(item);
        if (present != -1) {
            this.set(present, item);
        }
    }

    public int moveUp(int index) {
        if (index > 0) {
            this.swap(index, index - 1);
            this.fireTableRowsUpdated(index - 1, index);
            return index - 1;
        }
        return index;
    }

    public int moveDown(int index) {
        if (index < this.data.size() - 1) {
            this.swap(index, index + 1);
            this.fireTableRowsUpdated(index, index + 1);
            return index + 1;
        }
        return index;
    }

    public T remove(int index) {
        T removed = this.data.remove(index);
        this.fireTableRowsDeleted(index, index);
        return removed;
    }

    private void swap(int index, int index2) {
        T temp = this.data.get(index2);
        this.data.set(index2, this.data.get(index));
        this.data.set(index, temp);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public String getSearchValueAt(int row, int column) {
        return this.getValueAt(row, column).toString();
    }

    public int getSearchColumn(int column) {
        return column;
    }
}

