/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.LinkLabel;
import chatty.gui.components.LiveStreamsDialog;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.commands.CustomCommand;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LiveStreamsSettings
extends SettingsPanel {
    private final LinkLabel userReadPermission;
    private final JCheckBox requestFollowedStreams;

    public LiveStreamsSettings(SettingsDialog d) {
        JPanel listSettings = this.addTitledPanel(Language.getString("settings.section.liveStreams"), 0, false);
        JPanel gameFavorites = this.addTitledPanel(Language.getString("settings.section.gameFavorites"), 1, false);
        JPanel follows = this.addTitledPanel("Followed Streams", 2);
        LinkedHashMap<String, String> openActionOptions = new LinkedHashMap<String, String>();
        for (LiveStreamsDialog.OpenAction a : LiveStreamsDialog.OpenAction.values()) {
            openActionOptions.put(a.key, a.getLabel());
        }
        ComboStringSetting streamsAction = d.addComboStringSetting("liveStreamsAction", 10, false, openActionOptions);
        SettingsUtil.addLabeledComponent(listSettings, "liveStreamsAction", 0, 0, 1, 13, streamsAction);
        EditorStringSetting openCommand = d.addEditorStringSetting("liveStreamsCommand", 20, true, "Custom Command", false, "<code>$1-</code> contains all selected streams ([help-commands: Custom Commands Help], [url:https://www.youtube.com/watch?v=nU5AS8e9dLw Video Tutorial])", (parent, component, x, y, value) -> {
            CustomCommand parsedCommand = CustomCommand.parse(value);
            CommandSettings.showCommandInfoPopup(component, parsedCommand);
            return null;
        });
        openCommand.setLinkLabelListener(d.getLinkLabelListener());
        SettingsUtil.addLabeledComponent(listSettings, "liveStreamsCommand", 0, 1, 1, 13, openCommand, true);
        SettingsUtil.addSubsettings(streamsAction, t -> t.equals(LiveStreamsDialog.OpenAction.COMMAND.key), openCommand);
        SimpleBooleanSetting notificationAction = d.addSimpleBooleanSetting("liveStreamsNotificationAction");
        listSettings.add((Component)notificationAction, SettingsDialog.makeGbc(0, 2, 2, 1, 17));
        SettingsUtil.addSubsettings(streamsAction, t -> !t.equals(LiveStreamsDialog.OpenAction.INFO.key), notificationAction);
        listSettings.add((Component)d.addSimpleBooleanSetting("liveStreamsChatIcon"), SettingsDialog.makeGbc(0, 3, 2, 1, 17));
        listSettings.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>More options are available in the Live Streams list context menu."), SettingsDialog.makeGbc(0, 4, 2, 1));
        gameFavorites.add((Component)d.addListSetting("gameFavorites", Language.getString("settings.section.gameFavorites"), 250, 200, false, true), SettingsDialog.makeGbc(0, 0, 1, 1));
        gameFavorites.add((Component)new JLabel("<html><body style='width:200px'>The Live Streams list shows an icon for favorited games and optionally allows them to be sorted first.<br /><br />Games can also be added/removed through the Live Streams list context menu, which ensures the correct game name is added."), SettingsDialog.makeGbc(1, 0, 1, 1, 12));
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 17);
        this.requestFollowedStreams = d.addSimpleBooleanSetting("requestFollowedStreams", "Request followed streams", "Allows Chatty to know about live streams you follow to notify you and display a list of them");
        follows.add((Component)this.requestFollowedStreams, gbc);
        gbc = SettingsDialog.makeGbc(1, 0, 1, 1, 17);
        this.userReadPermission = new LinkLabel("", d.getLinkLabelListener());
        follows.add((Component)this.userReadPermission, gbc);
    }

    protected void setUserReadPermission(boolean enabled) {
        if (enabled) {
            this.userReadPermission.setText("Required access available. ([help:followed ?])");
        } else {
            this.userReadPermission.setText("Followed streams access required. ([help:followed ?])");
        }
    }
}

